#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/twin_prime_count nth_twin_prime/;

# 2^n using primesieve (fast), double checked with Pari 2.7.0 (slow):
#   a(n)=my(s, p=2); forprime(q=3, 2^n, if(q-p==2, s++); p=q); s
#   for (i=1,35,print(2^i," ", a(i)))
# 10^n from tables
my %nthvals = (
         0 =>           0,
         1 =>           3,
         2 =>           5,
         3 =>          11,
         5 =>          29,
         7 =>          59,
         8 =>          71,
        10 =>         107,
        17 =>         239,
        24 =>         461,
        35 =>         881,
        36 =>        1019,
        62 =>        2027,
       107 =>        4091,
       177 =>        8087,
       205 =>        9929,
       290 =>       16361,
       505 =>       32717,
       860 =>       65519,
      1224 =>       99989,
      1526 =>      131009,
      2679 =>      262109,
      4750 =>      524219,
      8169 =>      999959,
      8535 =>     1048571,
     15500 =>     2097131,
     27995 =>     4193801,
     50638 =>     8388449,
     58980 =>     9999971,
     92246 =>    16777139,
    168617 =>    33554009,
    309561 =>    67108667,
    440312 =>    99999587,
    571313 =>   134217437,
   1056281 =>   268435007,
   1961080 =>   536870837,
   3424506 =>   999999191,
   3650557 =>  1073741717,
   6810670 =>  2147482949,
  12739574 =>  4294965839,
  23878645 =>  8589934289,
  27412679 =>  9999999701,
  44849427 => 17179868807,
  84384508 => 34359737297,
  159082253 => 68719476389,
  224376048 => 99999999761,
 1870585220 => 999999999959,
);

plan tests => scalar(keys %nthvals);

foreach my $n (sort {$a <=> $b} keys %nthvals) {
  my $ntp = $nthvals{$n};
  is( nth_twin_prime($n), $ntp, "nth_twin_prime($n) = $ntp" );
}
