use warnings;
use strict;
use feature 'say';
use Data::Dumper;
use List::Util qw/max min/;

use Optimization::NSGAII qw/ f_Optim_NSGAII /;

my $case = 'CONSTR';
my $workdir = '/tmp';

my $startPop = [[1,1.40637140127829e-05,-0.000823401043590026,5.10540521833923e-05,0.00523423791398114,0.00189860212383878,0.00406993052436625,0.50386430616516,-0.0137085520604248,0.499258169270042],
[0,1.40637140127829e-05,-0.000823206843088544,2.4010551861485e-05,0.00523423791398114,0.00189860212383878,0.00406993052436625,0.50386430616516,-0.0137068091903261,0.499258169270042],
[0.0165136891779546,0.000298940459758946,-4.8697207093461e-05,-0.000401341786384381,0.00535526353338968,0.00218018001489058,0.00406993052436625,0.00201361689764923,-0.0136977926353321,0.499361914239233],
[0.772667784295095,0.00024862431710674,-0.000193214576316276,-1.08032067475306e-06,0.00529999692878926,0.00229322888137028,0.00406993052436625,0.00949651917370967,-0.0136930114752427,0.499354756530007],
[0.55784959027336,0.00024768302276212,-0.000193214576316276,-5.6219955223718e-05,0.00529999692878926,0.00220369463726727,0.00406993052436625,0.00419001527825394,-0.0136929377379537,0.499451617768346],
[0.00816052668891367,7.43036368718215e-05,0.0006628562542282,0.000302480411388576,0.00530059266771299,0.0022569447692176,0.00406993052436625,0.503746612856164,-0.0137046824473521,0.499262998558753],
[0.796070256192177,6.01579077613604e-05,-0.000193214576316276,-1.08032067475306e-06,0.00529861897617526,0.00229322888137028,0.00406993052436625,0.00949651917370967,-0.0136927831532495,0.499354756530007],
[0.992672840155317,1.40637140127829e-05,-0.000823399750585776,5.41333040433809e-05,0.00523423791398114,0.00189860212383878,0.00406993052436625,0.50386430616516,-0.013706823225346,0.499258169270042],
[0.430832462030237,0.000297095588524764,-0.000175520139725995,-0.000430409048084801,0.00537519970054859,0.00185482922556971,0.00406993052436625,0.00201361689764923,-0.0137126733856511,0.499455007325468],
[0.424430973768079,5.64723314642855e-05,0.00011830025005943,-7.76317355043301e-05,0.00531489143064038,0.00283474524302482,0.00406993052436625,0.503812525016656,-0.0136922996380119,0.499520149228951],
[0.117361844784959,0.000312497791511254,-0.00217753384388721,-0.000165623363904522,0.00535650668347215,0.00227979582540488,0.00406993052436625,0.503970495821432,-0.0136925994459699,0.499338433713905],
[0.525550131723046,0.000328405362691252,-0.000342592083423206,-0.000267155485840986,0.0053585625907498,0.00221758647763266,0.00406993052436625,0.00201361689764923,-0.0136920807938233,0.499412732605799],
[0.457201952610157,0.000324816892605599,-0.000332149593442556,-0.000223549672223262,0.00528777016833651,0.00229704025868611,0.00406993052436625,0.00201361689764923,-0.0136920807938233,0.499423786308081],
[0.271034260581389,0.000129342411389164,0.000137493177583576,0.000134291232430496,0.00529423887512976,0.00234981059301408,0.00406993052436625,0.503877203085193,-0.0136917313739457,0.499417280998127],
[0.375444552887181,5.64723314642855e-05,0.00011830025005943,-5.6219955223718e-05,0.00529859968014058,0.00229322888137028,0.00406993052436625,0.503812525016656,-0.0136930114752427,0.499502621873977],
[0.353076951063707,0.000282106621181418,5.23427932156535e-05,0.000166442767591004,0.00529652757415762,0.00219654501749135,0.00406993052436625,0.503871396887301,-0.0137080749465727,0.49944894070086],
[0.00361811430796436,0.000319186699494607,-3.53692103049881e-05,0.000246462045194911,0.00528091033882692,0.00288298452806351,0.00406993052436625,0.503827325048103,-0.013708445935924,0.499457402914699],
[0.131719656083204,0.0002542622001207,6.32860324689086e-06,-0.000301483520222838,0.00528091033882692,0.00288298452806351,0.00406993052436625,0.503827325048103,-0.013708445935924,0.499457402914699],
[0.165570830695237,0.000332201125644071,-0.00166599796715356,-0.00018880895322446,0.00528476088290899,0.00284817176588888,0.00406993052436625,0.503960049897439,-0.0136895015050675,0.499346201632341],
[0.14574491943281,0.000101293486953724,1.27207932284581e-05,-0.000574198948988672,0.00536555527491407,0.00224348744576218,0.00406993052436625,0.504169898034484,-0.0137066203989867,0.499219454938311],
[0.249924364034227,0.000129342411389164,0.00040976300388666,4.28767528674007e-05,0.00529290724306178,0.00219293845932256,0.00406993052436625,0.503877203085193,-0.0136893353996627,0.499234767818383],
[0.396970845022408,0.000193584931065295,8.60483876737671e-05,-0.000515398977348415,0.00528963997203483,0.00194203431744271,0.00406993052436625,0.503722393316539,-0.0136969018671274,0.499323482995105],
[0.152379707879601,-0.000169828235464372,0.000466611096646325,4.23074940676082e-05,0.00536544706470748,0.00281471794702238,0.00406993052436625,0.504037065476402,-0.0136899039204452,0.499243753036579],
[0.310772479559924,0.00010060145946502,0.000428476408082656,-0.000429226667910006,0.00531080496374435,0.00280932138529686,0.00406993052436625,0.504096922831921,-0.0137000511777301,0.499486683006463],
[0.414836926437355,0.00015259184386038,-0.000192618789212434,0.000219682990522415,0.00537920021604598,0.00292592993293918,0.00406993052436625,0.503914154116802,-0.0137116124124966,0.499228431519376],
[0.545259974325224,-9.00546697125979e-05,-0.000330046853225225,-0.000123670136794553,0.00536290244606505,0.00215126865718175,0.00406993052436625,0.00201361689764923,-0.0136933317560482,0.499444797040334],
[0.367117529171795,-0.000110378052320132,6.08280321164942e-05,-0.000515398977348415,0.00529655094055902,0.00280988408411404,0.00406993052436625,0.503617017387316,-0.013687582513692,0.499348402313645],
[0.182636620743662,0.000171280351945668,-0.00029796654009373,-0.000199533491689392,0.00537991115062352,0.00271661867771525,0.00406993052436625,0.503932669298043,-0.0136895983497803,0.499479732192581],
[0.296611454443701,-0.000293099182064655,-0.000240354919048854,-0.000699668593824109,0.00537686944025584,0.00241090684986759,0.00406993052436625,0.503876815263365,-0.0136916973189239,0.499310905285892],
[0.21023289965805,-7.11031699519494e-05,-4.40975315973295e-05,5.65707966147018e-05,0.00531343644644746,0.00280988408411404,0.00406993052436625,0.503825916897298,-0.0136897845128396,0.499311163257881],
[0.000662364766178396,0.000307099370742692,3.6993116041124e-05,0.000223425695393131,0.00526934215612195,0.00291290836440983,0.00406993052436625,0.50383302761729,-0.0136862725077598,0.499157937907439],
[0.17253450850506,0.000115375412128206,-0.000362463941141724,-7.78403827023965e-05,0.00537617707423543,0.0023147649633872,0.00406993052436625,0.503735695238947,-0.0136998663800893,0.499473708675085],
[0.195611617821464,-7.11031699519494e-05,0.000160844840141367,5.65707966147018e-05,0.00531343644644746,0.00280988408411404,0.00406993052436625,0.503829053709035,-0.0136987543804494,0.499298395726689],
[0.223199606051437,0.000147525216756443,-0.000106735603892774,-9.49161854406932e-05,0.00537931084261979,0.00287981080420641,0.00406993052436625,0.50382881503602,-0.0136825239154614,0.499452633590262],
[0.00531691771110211,0.000360789425420428,-8.24073314057966e-05,-0.000486546381984326,0.00528010421477391,0.00287308517613811,0.00406993052436625,0.503630222259341,-0.0136825676537353,0.499130735824461],
[0.122681186820546,-0.000156261810788549,0.000844865488717416,0.000134291232430496,0.00523570733624937,0.00219654501749135,0.00406993052436625,0.503630032037679,-0.0136925425675265,0.499415697813442],
[0.232932884447931,-0.000155681900931085,0.000682961104112915,-0.000194401706696838,0.00535929603395852,0.00289625128177627,0.00406993052436625,0.503970495821432,-0.013690430920427,0.499338433713905],
[0.282000084410296,0.000103231057896661,0.000428476408082656,-0.000413874614471654,0.00531080496374435,0.00280932138529686,0.00406993052436625,0.504096922831921,-0.0137000511777301,0.499486683006463],
[0.326282723977563,0.000122321950086307,0.000190912648192156,-0.000279194607360171,0.0053100296990923,0.0021964619831137,0.00406993052436625,0.504408990131005,-0.0136921085404779,0.499416505983057],
[0.529095776117252,3.24047877947909e-05,-0.000384879037183222,-0.000684269157932759,0.00530984984540286,0.00231029935911712,0.00406993052436625,0.00201361689764923,-0.0137069863339679,0.499277103069834],
[0.337831051348664,0.00012181295638189,0.000428476408082656,-0.000278498814519177,0.00531080496374435,0.00217578915435715,0.00406993052436625,0.504096922831921,-0.0137000511777301,0.499500513413582],
[0.288269900226125,-0.000247344509699276,-0.000240354919048854,-0.000699668593824109,0.00537686944025584,0.00241090684986759,0.00406993052436625,0.503722393316539,-0.0136896179093649,0.499310905285892],
[0.317932318265075,-3.69302162345087e-05,-0.000815801161562701,0.000106468596472542,0.00523423791398114,0.00153905779146028,0.00406993052436625,0.50386430616516,-0.0137086417788183,0.499258169270042],
[0.191481604328,0.000167709502014458,0.00011830025005943,-7.4283738489432e-05,0.00529859968014058,0.00229322888137028,0.00406993052436625,0.503936500164863,-0.0136924046866984,0.49948749810951],
[0.401473330673133,0.000399249268051157,0.000111996484750779,-0.000296788828786261,0.00531318771134267,0.0028121828739056,0.00406993052436625,0.504045115265271,-0.0136969018671274,0.499348604018574],
[0.239705655986272,0.000143864760809695,5.3776047876574e-05,-0.00041595801919581,0.005309827247573,0.00281047872449204,0.00406993052436625,0.503845592028773,-0.0136905601786206,0.499134503931826],
[0.213531793259524,9.0706688459604e-05,5.23427932156535e-05,0.000134291232430496,0.00529423887512976,0.00219654501749135,0.00406993052436625,0.503871396887301,-0.0136861341049111,0.499415780099626],
[0.000600631701403592,0.000307099370742692,1.44689699199689e-05,0.000208728032991496,0.00536060488412265,0.00286807411680958,0.00406993052436625,0.50383302761729,-0.0137049897602514,0.499157937907439],
[0.336240331752411,0.000122321950086307,0.000126658173323038,-0.000279194607360171,0.00528635112483046,0.0021964619831137,0.00406993052436625,0.503877203085193,-0.0136921085404779,0.499451187557708],
[0.444594042967976,0.00032364107921412,-0.000145447463095984,-0.000520920909273573,0.00529969875935529,0.00231073156468955,0.00406993052436625,0.00201361689764923,-0.0137044950051401,0.499482876888529]];

my $a_Gaussian_distrib = [-0.126552767332602,-0.124184833892298,-0.123850245771661,-0.123059544908239,-0.108536045218461,-0.108490455873466,-0.100265321848112,-0.099336861185447,-0.099020119889618,-0.097238287101082,-0.096818240899097,-0.094121589836443,-0.093926985711317,-0.092836016023371,-0.092005499073065,-0.090215050273506,-0.089677613720452,-0.088006114910809,-0.087918364584143,-0.087384053714757,-0.083186250872599,-0.082947584866554,-0.081915340273467,-0.081674777995713,-0.081125825339507,-0.08018331770188,-0.07958176315598,-0.078763373586161,-0.076361874452213,-0.0758039128666,-0.075192767348595,-0.074828584393573,-0.07385478581639,-0.073417462315762,-0.073326919291812,-0.072410437760289,-0.072369450238867,-0.06822533133922,-0.067541282136129,-0.067027294848943,-0.065569305652918,-0.064946825958067,-0.064492645582761,-0.06431612552763,-0.06408430645047,-0.062512196791939,-0.061465862704217,-0.060771119433615,-0.059890953447754,-0.058587354337482,-0.058343831506988,-0.056130122802563,-0.055368448755907,-0.055140324409331,-0.054366965848978,-0.053969474966137,-0.052065856301153,-0.051960539343234,-0.051300323988468,-0.049732894124879,-0.049208789753907,-0.047766599250157,-0.047261085380438,-0.047094056448582,-0.047073697340933,-0.046679472166131,-0.046257186406462,-0.046224260521509,-0.045824679055949,-0.045051810509039,-0.044934699317466,-0.043915684840997,-0.043733328847816,-0.043306080618606,-0.042880687853995,-0.042558234779959,-0.041122692795902,-0.041028937023039,-0.040359013677161,-0.040339456866299,-0.037540815139332,-0.036326388785047,-0.036154701123524,-0.035889131920911,-0.035293390707607,-0.035137908154844,-0.034975414916706,-0.034458451137207,-0.034320348658017,-0.033729313312596,-0.033579638436086,-0.033488635126438,-0.033258638680425,-0.032865500317595,-0.032472794171676,-0.032223021650734,-0.031795607280537,-0.03162967124853,-0.031603252577906,-0.031435979151288,-0.030110699598099,-0.030029891332627,-0.029813320893966,-0.029341470064056,-0.029317397868644,-0.028859849755164,-0.028562634283549,-0.028171884333171,-0.027726542897015,-0.026923498537139,-0.02687105086103,-0.02669067119419,-0.026639027594616,-0.026623510692149,-0.026502217613141,-0.026306892902042,-0.025101973658881,-0.024829369039305,-0.024278033931223,-0.024055052989489,-0.023728083921173,-0.023431362574378,-0.023155865499278,-0.022494970304758,-0.021543313608726,-0.021408819633352,-0.02098663205144,-0.020509810901131,-0.019023702471009,-0.018886087393564,-0.018739723640119,-0.018563218371704,-0.01744610641705,-0.016901964535819,-0.015737597055677,-0.015115245398499,-0.015011329715041,-0.01490831686522,-0.01471321691377,-0.014704066082059,-0.01461092580066,-0.014438912423706,-0.014173117529125,-0.013722385184909,-0.013286202663347,-0.013083249502008,-0.012370076456976,-0.012256121525491,-0.01220152954189,-0.011974222430743,-0.011730953678111,-0.011653508611607,-0.011542180090791,-0.011246147846662,-0.01121509171997,-0.011146425764757,-0.010430351637167,-0.010400116315859,-0.010363820661031,-0.010332748135793,-0.010289307037594,-0.010214055388945,-0.009123998038235,-0.009054588437119,-0.008922621949386,-0.00863689614146,-0.008627377190595,-0.008335160688962,-0.008225726563662,-0.008014807693791,-0.007830033795929,-0.007480743874798,-0.006987534600174,-0.006082833887047,-0.005108443344733,-0.0043945259487,-0.004068547148139,-0.004056744499422,-0.003932258136843,-0.003920738275934,-0.003711643644404,-0.003253942969145,-0.002938732845359,-0.002364058167866,-0.001740845557155,-0.001706638860694,-0.001493607232092,-0.000929642670667,-0.000723588319652,-0.000651096023908,-0.000407115136405,-0.000151750412256,0.000360514102346,0.0008125076205,0.001261696768208,0.001598075392741,0.001745782068555,0.001761983773867,0.00176385404844,0.002287067219997,0.002583977608041,0.002947038321649,0.003125948779926,0.003601954230342,0.003669329444394,0.004210211632231,0.004241282341812,0.004838606598222,0.005259196695278,0.005394712958512,0.005716152018998,0.005745520979105,0.006244151916441,0.006277431443008,0.00629180643632,0.006341452145487,0.006585875625817,0.006730699593953,0.006867108831871,0.006926920765286,0.007083786320345,0.007231309715251,0.007836460077933,0.008029331223673,0.008047877789025,0.008266905524803,0.008551462176534,0.008655529713479,0.008913570234672,0.009109808414259,0.009288069344839,0.009373924856012,0.009527004348714,0.009650605726431,0.009779481630216,0.009785932899812,0.009834865506333,0.009859716090185,0.010001493843748,0.010283575641002,0.010653989341186,0.010956721890687,0.011528221759694,0.011825325305054,0.011913811462871,0.012001378561667,0.012959636485778,0.013623233975225,0.013636051226599,0.013711909023028,0.014464230868162,0.014545565027191,0.01544590172161,0.016270438884019,0.016328069275395,0.0163289398519,0.01724830810307,0.017565368874886,0.018384504295601,0.018537570276765,0.018810485072031,0.019211736935688,0.019367698135116,0.019405328958307,0.019827779418084,0.02009875229213,0.020293282441949,0.020338791467675,0.02054759602326,0.020774481692277,0.020964409638549,0.021219942043821,0.021452636477171,0.021669437362338,0.021767740078823,0.021852083779092,0.022444790583506,0.022811121102747,0.022826636898226,0.024089649754241,0.024874137853445,0.024933176283471,0.025202449966997,0.025827699455891,0.025886814537976,0.025948958167712,0.026054888875697,0.026461759632617,0.02681388228252,0.026857035593157,0.027167104791521,0.028055102078254,0.028506726616058,0.028534450298026,0.029036887603686,0.03008698516978,0.030469285437896,0.030571574388609,0.031232723820284,0.031495309095002,0.03211064048744,0.033510768880711,0.034071107814156,0.034101256838084,0.034513701897125,0.034903465178378,0.034986850148737,0.035905801204883,0.036039233881749,0.036051033747065,0.036301119973675,0.03698215211072,0.037034412329232,0.037312034373806,0.037925631401787,0.038053824822622,0.038368836918606,0.038575826963115,0.038805245836416,0.039049512972094,0.039414141315165,0.039935221711919,0.039953996631094,0.040025912352534,0.040066590602892,0.041867814064641,0.043730222758929,0.044007715456773,0.04402211657695,0.046224801244642,0.046490243405544,0.046511533594137,0.049380735360799,0.049569131814962,0.050019693491479,0.050731407129425,0.053909618975122,0.053933024350625,0.05407467428704,0.054773573920382,0.055316496094078,0.05569480912706,0.056420129942627,0.057053691894873,0.057244637431286,0.057775523208997,0.058316606967604,0.059879575628524,0.060139634546388,0.060221661348568,0.061029243809417,0.061122463490992,0.061208424274151,0.061754568938803,0.062036181620534,0.062461486894532,0.063899301761217,0.064105636033852,0.064243598168751,0.06536093944066,0.065795676268663,0.066006068294641,0.067048533923457,0.068160124558617,0.069459327771045,0.070314642067638,0.07106976991784,0.071100174949561,0.072231543182124,0.072997823733677,0.073417802173528,0.073944609778083,0.074013073478014,0.074542896774372,0.075382507959084,0.076659108649154,0.080224085115224,0.081903607151747,0.08335771765952,0.083473450783315,0.083943996778105,0.084826479674205,0.085684736492997,0.085705453827743,0.086447372731017,0.086451998946279,0.092325829703238,0.092964559115019,0.094058969063154,0.095631069024163,0.099152806647037,0.099393399610832,0.099650078834012,0.100255269978864,0.101434675278627,0.101563960521336,0.102570374909497,0.106455929135734,0.117071961882639,0.150905025116288];


sub f_ZDT4 {
	
	my $x = shift;
		
	my $n = scalar(@$x);
	
	my $f1 = $x->[0];
	
	my $sum = 0;	
	for my $i(1..$n-1){$sum += ($x->[$i])**2 - 10*cos(4*3.14159265*$x->[$i])} ; # ZTD 4
	
	my $g  = 1 + 10*($n-1) + $sum; # ZDT 4
	my $f2 = $g*(1-sqrt($x->[0]/$g)); # ZDT 1 4
	
	my $out = [$f1,$f2];
	
	return $out;
}

my $bounds = [];
for (1..10){
	push @$bounds, [-5,5];
}
$bounds->[0] = [0,1];

f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> $bounds,
		'function' 		=> \&f_ZDT4,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,	
		'verboseFinal'  => 1,	
		'distrib'       => $a_Gaussian_distrib,
		'scaleDistrib' => 0.01,
		'percentMut'   => 5,
        'startPop'     => $startPop 
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0,1],
		'ylim'		=> [0,2],
		'nfun'		=> [0,1],
	}		
);
