package App::Manoc::Model::ManocDB;
#ABSTRACT:  Catalyst DBIC Schema Model for Manoc


use Moose;
extends 'Catalyst::Model::DBIC::Schema';

our $VERSION = '2.99.2'; ##TRIAL VERSION

use namespace::autoclean;

__PACKAGE__->config( schema_class => 'App::Manoc::DB', );

has 'search_engine' => (
    is      => 'ro',
    isa     => 'App::Manoc::Search::Engine',
    lazy    => 1,
    builder => '_build_search_engine',
);

sub _build_search_engine {
    my $self = shift;
    return App::Manoc::Search::Engine->new( { schema => $self->schema } );
}


sub search {
    my ( $self, $query_string, $params ) = @_;

    my $engine = $self->search_engine;

    my $q = App::Manoc::Search::Query->new( { search_string => $query_string } );

    # use params to refine query
    if ( $params->{limit} && !defined( $q->limit ) ) {
        $q->limit( ( $params->{limit} ) );
    }
    if ( $params->{type} && !defined( $q->query_type ) ) {
        $q->query_type( $params->{type} );
    }
    $q->parse;

    return $engine->search($q);
}

__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

App::Manoc::Model::ManocDB - Catalyst DBIC Schema Model for Manoc

=head1 VERSION

version 2.99.2

=head1 DESCRIPTION

L<Catalyst::Model::DBIC::Schema> Model using schema L<App::Manoc::DB>

=head1 METHODS

=head2 search( $query_string, $params )

Run query using L<App::Manoc::Search::Engine>.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
