package App::Manoc::ControllerRole::JSONView;
#ABSTRACT: Role for adding JSON support for view and view list

use Moose::Role;
our $VERSION = '2.99.3'; ##TRIAL VERSION

use namespace::autoclean;

use MooseX::MethodAttributes::Role;

requires 'serialize_objects';


sub prepare_json_object {
    my ( $self, $c, $row ) = @_;
    return $self->serialize_object( $c, $row );
}


sub prepare_json_objects {
    my ( $self, $c, $rows ) = @_;
    return $self->serialize_objects( $c, $rows );
}


sub object_view_js : Private {
    my ( $self, $c ) = @_;

    $c->stash(
        json_data    => $self->prepare_json_object( $c, $c->stash->{object} ),
        current_view => 'JSON'
    );
}


sub object_list_js : Private {
    my ( $self, $c ) = @_;

    $c->stash(
        json_data    => $self->prepare_json_objects( $c, $c->stash->{object_list} ),
        current_view => 'JSON'
    );
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::ControllerRole::JSONView - Role for adding JSON support for view and view list

=head1 VERSION

version 2.99.3

=head1 METHODS

=head2 prepare_json_object

Call serialize_object. Redefine this method for custom serialization.

=head2 prepare_json_objects

Call serialize_objects. Redefine this method for custom serialization.

=head2 object_view_js

=head2 object_list_js

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
