package WARC::Index::File::CDX::Builder;			# -*- CPerl -*-

use strict;
use warnings;

require WARC::Index::Builder;
our @ISA = qw(WARC::Index::Builder);

require WARC; *WARC::Index::File::CDX::Builder::VERSION = \$WARC::VERSION;

=head1 NAME

WARC::Index::File::CDX::Builder - build CDX WARC indexes

=head1 SYNOPSIS

  use WARC::Index;

  build WARC::Index::File::CDX into => $cdx_file, from => [@files];

  $builder = build WARC::Index::File::CDX into => $cdx_file;
  $builder->add($record);

=head1 DESCRIPTION

The C<WARC::Index::File::CDX::Builder> class provides the implementation
for building CDX indexes.

=head2 Options for C<build> method when building CDX indexes

=over

=item C<into>

Name of CDX file to write.

=item C<fields>

Array reference of CDX field letters to use, in order.  See
L<WARC::Index::File::CDX> for details about supported fields.

Default:  [qw/N b a m s k r M S V g u/]

=back

=cut

1;
__END__

=head1 AUTHOR

Jacob Bachmeyer, E<lt>jcb@cpan.orgE<gt>

=head1 SEE ALSO

L<WARC>, L<WARC::Index::Builder>, L<WARC::Index::File::CDX>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2019 by Jacob Bachmeyer

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
