#ifndef SASS_COLOR_NAMES_H
#define SASS_COLOR_NAMES_H

namespace Sass {

  /*
   * Color names are processed in order. For color names with alternate aliases
   * (i.e. gray & grey), the canonical name should be listed last, so it takes
   * precedence.
   */
  const char* color_names[] =
  {
    "aliceblue",
    "antiquewhite",
    "aqua",
    "aquamarine",
    "azure",
    "beige",
    "bisque",
    "black",
    "blanchedalmond",
    "blue",
    "blueviolet",
    "brown",
    "burlywood",
    "cadetblue",
    "chartreuse",
    "chocolate",
    "coral",
    "cornflowerblue",
    "cornsilk",
    "crimson",
    "cyan",
    "darkblue",
    "darkcyan",
    "darkgoldenrod",
    "darkgrey",
    "darkgray",
    "darkgreen",
    "darkkhaki",
    "darkmagenta",
    "darkolivegreen",
    "darkorange",
    "darkorchid",
    "darkred",
    "darksalmon",
    "darkseagreen",
    "darkslateblue",
    "darkslategrey",
    "darkslategray",
    "darkturquoise",
    "darkviolet",
    "deeppink",
    "deepskyblue",
    "dimgrey",
    "dimgray",
    "dodgerblue",
    "firebrick",
    "floralwhite",
    "forestgreen",
    "fuchsia",
    "gainsboro",
    "ghostwhite",
    "gold",
    "goldenrod",
    "grey",
    "gray",
    "green",
    "greenyellow",
    "honeydew",
    "hotpink",
    "indianred",
    "indigo",
    "ivory",
    "khaki",
    "lavender",
    "lavenderblush",
    "lawngreen",
    "lemonchiffon",
    "lightblue",
    "lightcoral",
    "lightcyan",
    "lightgoldenrodyellow",
    "lightgrey",
    "lightgray",
    "lightgreen",
    "lightpink",
    "lightsalmon",
    "lightseagreen",
    "lightskyblue",
    "lightslategrey",
    "lightslategray",
    "lightsteelblue",
    "lightyellow",
    "lime",
    "limegreen",
    "linen",
    "magenta",
    "maroon",
    "mediumaquamarine",
    "mediumblue",
    "mediumorchid",
    "mediumpurple",
    "mediumseagreen",
    "mediumslateblue",
    "mediumspringgreen",
    "mediumturquoise",
    "mediumvioletred",
    "midnightblue",
    "mintcream",
    "mistyrose",
    "moccasin",
    "navajowhite",
    "navy",
    "oldlace",
    "olive",
    "olivedrab",
    "orange",
    "orangered",
    "orchid",
    "palegoldenrod",
    "palegreen",
    "paleturquoise",
    "palevioletred",
    "papayawhip",
    "peachpuff",
    "peru",
    "pink",
    "plum",
    "powderblue",
    "purple",
    "red",
    "rosybrown",
    "royalblue",
    "saddlebrown",
    "salmon",
    "sandybrown",
    "seagreen",
    "seashell",
    "sienna",
    "silver",
    "skyblue",
    "slateblue",
    "slategrey",
    "slategray",
    "snow",
    "springgreen",
    "steelblue",
    "tan",
    "teal",
    "thistle",
    "tomato",
    "turquoise",
    "violet",
    "wheat",
    "white",
    "whitesmoke",
    "yellow",
    "yellowgreen",
    // rebeccapurple
    "rebeccapurple",
    // transparent
    "transparent",
    // sentinel value
    0
  };

  const double color_values[] =
  {
    0xf0, 0xf8, 0xff, 1,
    0xfa, 0xeb, 0xd7, 1,
    0x00, 0xff, 0xff, 1,
    0x7f, 0xff, 0xd4, 1,
    0xf0, 0xff, 0xff, 1,
    0xf5, 0xf5, 0xdc, 1,
    0xff, 0xe4, 0xc4, 1,
    0x00, 0x00, 0x00, 1,
    0xff, 0xeb, 0xcd, 1,
    0x00, 0x00, 0xff, 1,
    0x8a, 0x2b, 0xe2, 1,
    0xa5, 0x2a, 0x2a, 1,
    0xde, 0xb8, 0x87, 1,
    0x5f, 0x9e, 0xa0, 1,
    0x7f, 0xff, 0x00, 1,
    0xd2, 0x69, 0x1e, 1,
    0xff, 0x7f, 0x50, 1,
    0x64, 0x95, 0xed, 1,
    0xff, 0xf8, 0xdc, 1,
    0xdc, 0x14, 0x3c, 1,
    0x00, 0xff, 0xff, 1,
    0x00, 0x00, 0x8b, 1,
    0x00, 0x8b, 0x8b, 1,
    0xb8, 0x86, 0x0b, 1,
    0xa9, 0xa9, 0xa9, 1,
    0xa9, 0xa9, 0xa9, 1,
    0x00, 0x64, 0x00, 1,
    0xbd, 0xb7, 0x6b, 1,
    0x8b, 0x00, 0x8b, 1,
    0x55, 0x6b, 0x2f, 1,
    0xff, 0x8c, 0x00, 1,
    0x99, 0x32, 0xcc, 1,
    0x8b, 0x00, 0x00, 1,
    0xe9, 0x96, 0x7a, 1,
    0x8f, 0xbc, 0x8f, 1,
    0x48, 0x3d, 0x8b, 1,
    0x2f, 0x4f, 0x4f, 1,
    0x2f, 0x4f, 0x4f, 1,
    0x00, 0xce, 0xd1, 1,
    0x94, 0x00, 0xd3, 1,
    0xff, 0x14, 0x93, 1,
    0x00, 0xbf, 0xff, 1,
    0x69, 0x69, 0x69, 1,
    0x69, 0x69, 0x69, 1,
    0x1e, 0x90, 0xff, 1,
    0xb2, 0x22, 0x22, 1,
    0xff, 0xfa, 0xf0, 1,
    0x22, 0x8b, 0x22, 1,
    0xff, 0x00, 0xff, 1,
    0xdc, 0xdc, 0xdc, 1,
    0xf8, 0xf8, 0xff, 1,
    0xff, 0xd7, 0x00, 1,
    0xda, 0xa5, 0x20, 1,
    0x80, 0x80, 0x80, 1,
    0x80, 0x80, 0x80, 1,
    0x00, 0x80, 0x00, 1,
    0xad, 0xff, 0x2f, 1,
    0xf0, 0xff, 0xf0, 1,
    0xff, 0x69, 0xb4, 1,
    0xcd, 0x5c, 0x5c, 1,
    0x4b, 0x00, 0x82, 1,
    0xff, 0xff, 0xf0, 1,
    0xf0, 0xe6, 0x8c, 1,
    0xe6, 0xe6, 0xfa, 1,
    0xff, 0xf0, 0xf5, 1,
    0x7c, 0xfc, 0x00, 1,
    0xff, 0xfa, 0xcd, 1,
    0xad, 0xd8, 0xe6, 1,
    0xf0, 0x80, 0x80, 1,
    0xe0, 0xff, 0xff, 1,
    0xfa, 0xfa, 0xd2, 1,
    0xd3, 0xd3, 0xd3, 1,
    0xd3, 0xd3, 0xd3, 1,
    0x90, 0xee, 0x90, 1,
    0xff, 0xb6, 0xc1, 1,
    0xff, 0xa0, 0x7a, 1,
    0x20, 0xb2, 0xaa, 1,
    0x87, 0xce, 0xfa, 1,
    0x77, 0x88, 0x99, 1,
    0x77, 0x88, 0x99, 1,
    0xb0, 0xc4, 0xde, 1,
    0xff, 0xff, 0xe0, 1,
    0x00, 0xff, 0x00, 1,
    0x32, 0xcd, 0x32, 1,
    0xfa, 0xf0, 0xe6, 1,
    0xff, 0x00, 0xff, 1,
    0x80, 0x00, 0x00, 1,
    0x66, 0xcd, 0xaa, 1,
    0x00, 0x00, 0xcd, 1,
    0xba, 0x55, 0xd3, 1,
    0x93, 0x70, 0xdb, 1,
    0x3c, 0xb3, 0x71, 1,
    0x7b, 0x68, 0xee, 1,
    0x00, 0xfa, 0x9a, 1,
    0x48, 0xd1, 0xcc, 1,
    0xc7, 0x15, 0x85, 1,
    0x19, 0x19, 0x70, 1,
    0xf5, 0xff, 0xfa, 1,
    0xff, 0xe4, 0xe1, 1,
    0xff, 0xe4, 0xb5, 1,
    0xff, 0xde, 0xad, 1,
    0x00, 0x00, 0x80, 1,
    0xfd, 0xf5, 0xe6, 1,
    0x80, 0x80, 0x00, 1,
    0x6b, 0x8e, 0x23, 1,
    0xff, 0xa5, 0x00, 1,
    0xff, 0x45, 0x00, 1,
    0xda, 0x70, 0xd6, 1,
    0xee, 0xe8, 0xaa, 1,
    0x98, 0xfb, 0x98, 1,
    0xaf, 0xee, 0xee, 1,
    0xdb, 0x70, 0x93, 1,
    0xff, 0xef, 0xd5, 1,
    0xff, 0xda, 0xb9, 1,
    0xcd, 0x85, 0x3f, 1,
    0xff, 0xc0, 0xcb, 1,
    0xdd, 0xa0, 0xdd, 1,
    0xb0, 0xe0, 0xe6, 1,
    0x80, 0x00, 0x80, 1,
    0xff, 0x00, 0x00, 1,
    0xbc, 0x8f, 0x8f, 1,
    0x41, 0x69, 0xe1, 1,
    0x8b, 0x45, 0x13, 1,
    0xfa, 0x80, 0x72, 1,
    0xf4, 0xa4, 0x60, 1,
    0x2e, 0x8b, 0x57, 1,
    0xff, 0xf5, 0xee, 1,
    0xa0, 0x52, 0x2d, 1,
    0xc0, 0xc0, 0xc0, 1,
    0x87, 0xce, 0xeb, 1,
    0x6a, 0x5a, 0xcd, 1,
    0x70, 0x80, 0x90, 1,
    0x70, 0x80, 0x90, 1,
    0xff, 0xfa, 0xfa, 1,
    0x00, 0xff, 0x7f, 1,
    0x46, 0x82, 0xb4, 1,
    0xd2, 0xb4, 0x8c, 1,
    0x00, 0x80, 0x80, 1,
    0xd8, 0xbf, 0xd8, 1,
    0xff, 0x63, 0x47, 1,
    0x40, 0xe0, 0xd0, 1,
    0xee, 0x82, 0xee, 1,
    0xf5, 0xde, 0xb3, 1,
    0xff, 0xff, 0xff, 1,
    0xf5, 0xf5, 0xf5, 1,
    0xff, 0xff, 0x00, 1,
    0x9a, 0xcd, 0x32, 1,
    // rebeccapurple
    0x66, 0x33, 0x99, 1,
    // transparent
    0x00, 0x00, 0x00, 0,
    // sentinel value
    0xfff
  };

}

#endif
