/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Value;

public abstract class AbstractVirtualNode
implements VirtualNode {
    protected NodeInfo node;
    protected AbstractVirtualNode parent;
    protected AbstractVirtualNode docWrapper;

    public NodeInfo getUnderlyingNode() {
        return this.node;
    }

    public Object getRealNode() {
        Object u = this;
        while ((u = ((VirtualNode)u).getUnderlyingNode()) instanceof VirtualNode) {
        }
        return u;
    }

    public Configuration getConfiguration() {
        return this.node.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    public int getNodeKind() {
        return this.node.getNodeKind();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return this.atomize().iterate();
    }

    public Value atomize() throws XPathException {
        return this.node.atomize();
    }

    public int getTypeAnnotation() {
        return this.node.getTypeAnnotation();
    }

    public SchemaType getSchemaType() {
        return this.node.getSchemaType();
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (other instanceof AbstractVirtualNode) {
            return this.node.isSameNodeInfo(((AbstractVirtualNode)other).node);
        }
        return this.node.isSameNodeInfo(other);
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return ((Object)this.node).hashCode() ^ 0x3C3C3C3C;
    }

    public String getSystemId() {
        return this.node.getSystemId();
    }

    public void setSystemId(String uri) {
        this.node.setSystemId(uri);
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    public int getColumnNumber() {
        return this.node.getColumnNumber();
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof AbstractVirtualNode) {
            return this.node.compareOrder(((AbstractVirtualNode)other).node);
        }
        return this.node.compareOrder(other);
    }

    public final String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        return this.node.getStringValueCS();
    }

    public int getNameCode() {
        return this.node.getNameCode();
    }

    public int getFingerprint() {
        return this.node.getFingerprint();
    }

    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    public String getURI() {
        return this.node.getURI();
    }

    public String getPrefix() {
        return this.node.getPrefix();
    }

    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(axisNumber), nodeTest);
    }

    public String getAttributeValue(int fingerprint) {
        return this.node.getAttributeValue(fingerprint);
    }

    public String getAttributeValue(String uri, String local) {
        return this.node.getAttributeValue(uri, local);
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return (DocumentInfo)((Object)this.docWrapper);
    }

    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public void generateId(FastStringBuffer buffer) {
        this.node.generateId(buffer);
    }

    public long getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return this.node.getDeclaredNamespaces(buffer);
    }

    public boolean isId() {
        return this.node.isId();
    }

    public boolean isIdref() {
        return this.node.isIdref();
    }

    public boolean isNilled() {
        return false;
    }
}

