# vim:set filetype=perl:
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 03_scrifel.t'

#########################

use Test::More tests => 81;
use Carp;

BEGIN { use_ok 'Lingua::Zompist::Barakhinei', 'scrifel' }

sub form_ok {
    # croak 'usage: form_ok($verb, $is, $should)' unless @_ >= 3;
    my($verb, $is, $should) = @_;

    is($is->[0], $should->[0], "I.sg. of $verb");
    is($is->[1], $should->[1], "II.sg. of $verb");
    is($is->[2], $should->[2], "III.sg. of $verb");
    is($is->[3], $should->[3], "I.pl. of $verb");
    is($is->[4], $should->[4], "II.pl. of $verb");
    is($is->[5], $should->[5], "III.pl. of $verb");
}

form_ok('elir',  scrifel('elir',  1), [ qw( eliri  elir  elir   elir  elir  elirn  ) ]);
form_ok('rikha',  scrifel('rikha',  2), [ qw( rikhi  rikhi  rikh  rikhu  rikh  rikhn  ) ]);
form_ok('lel',   scrifel('lel',   3), [ qw( leli   leli   lel   lelu   lel   leln   ) ]);
form_ok('bshti', scrifel('bshti', 4), [ qw( bshti bsht bsht bsht bsht bshtn ) ]);
form_ok('hab',   scrifel('hab',   5), [ qw( habi   hab   hap    hab   hab   habn   ) ]);

form_ok('groch', scrifel('groch', 1), [ qw( grochi groch grok   grog  grog  grochn ) ]);
form_ok('foka',   scrifel('foka',   2), [ qw( fochi  fochi  fok   foku   fok   fochn  ) ]);
form_ok('noch',  scrifel('noch',  3), [ qw( nochi  nochi  nog   nogu   nog   nochn  ) ]);
form_ok('faichi', scrifel('faichi', 4), [ qw( faichi faich faok  faich faich faichn ) ]);
form_ok('klach', scrifel('klach', 5), [ qw( klachi klach klach  klach klach klachn ) ]);

form_ok('eza',   scrifel('eza'  ), [ qw( fuch  fuch  f  fu    fu   fn    ) ]);
form_ok('epeza', scrifel('epeza'), [ qw( zi   zi   ep zu   z   zn   ) ]);
form_ok('kedh', scrifel('kedh'), [ qw( kedhi kedhi ki kedhu kedh kedhn ) ]);

is(scrifel('tsht', 1)->[2], 'tch',  'III.sg of tsht');
is(scrifel('rhed',  1)->[2], 'rhedh', 'III.sg of rhed' );

#form_ok('foli',    scrifel('foli'   ), [ qw( ful     ful   fut   folu    folu    foln    ) ]);
#form_ok('lhib',   scrifel('lhib'  ), [ qw( lhua    lh   lhu   lhubu   lhubu   ln      ) ]);
#form_ok('nh',     scrifel('nh'    ), [ qw( nhe     ni    ni    nheza   nhezu   nh      ) ]);
#form_ok('shkriv', scrifel('shkriv'), [ qw( shkriva shkri shkri shkrivu shkrivu shkrivn ) ]);
#form_ok('shtan',  scrifel('shtan' ), [ qw( sht    sht  sht  shtana  shtanu  shtn    ) ]);
#form_ok('fli',    scrifel('fli'   ), [ qw( fl     fl   fl   flu    flu    fln    ) ]);
#form_ok('hizi',    scrifel('hizi'   ), [ qw( huz     hu    hut   hizu    hizu    hizn    ) ]);
#form_ok('oi',      scrifel('oi'     ), [ qw( oh      fi    fit   ou      ou      on      ) ]);
