#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 2;
use Test::MockModule;

use Git::Wrapper::More;

{
    my $label = 'canstatus returns true when GitWrapper can get a repo status';

    my $mgwm = Test::MockModule->new('Git::Wrapper');
    $mgwm->mock(
        'status',
        sub {
            my $self = shift;
            return "bless( {}, 'Git::Wrapper::Statuses' )";
        },
    );

    my $gwm = Git::Wrapper::More->new( dir => '/will/be/mocked' );

    my $ret = $gwm->canstatus();
    is( $ret, 1, $label );
}

{
    my $label = 'canstatus returns false for dummy repo';

    my $gwm = Git::Wrapper::More->new( dir => '/a/dummy/dir' );

    my $ret = $gwm->canstatus();
    is( $ret, 0, $label );
}

__END__
