#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 1;
use Test::Deep;
use Test::MockModule;

use Git::Wrapper::More;

my @dum_ret = (
    bless(
        {   'id'            => '379d9c7a31283b5c76a17943c441453138c65821',
            'modifications' => [],
            'attr'          => {
                'date'   => 'Mon Mar 9 15:34:04 2019 -0600',
                'author' => 'An Author <me@adomain.net>'
            },
            'message' => 'Correct exit codes, add testing

Make 2 exit codes correct - return 0 on success
 Change one stderr to warn

A module: add some tests, comments
'
        },
        'Git::Wrapper::Log'
    ),
    bless(
        {   'id'            => '62ab2a44367dd615cc0b462bad7c77273e37d71e',
            'modifications' => [],
            'attr'          => {
                'date'   => 'Mon Mar 9 15:17:28 2019 -0600',
                'author' => 'An Author <me@adomain.net>'
            },
            'message' => 'Add comment pointing to wiki
'
        },
        'Git::Wrapper::Log'
    )
);

my $mgwm = Test::MockModule->new('Git::Wrapper');
$mgwm->mock(
    'log',
    sub {
        my $self = shift;
        return @dum_ret;
    },
);

my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir' );

my @ret = $gwm->logsincecommit('7bb3fbb155453fc46af866feb58dfe3008356635');
cmp_deeply( \@ret, \@dum_ret, 'logsincecommit returns the dummy commit objects it was fed' );

exit;

__END__
