#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 4;
use Test::MockModule;
use Test::Exception;

use Git::Wrapper::More;

{
    my $label = 'Happy Path';

    my $mgw = Test::MockModule->new('Git::Wrapper');

    $mgw->mock(
        'diff',
        sub {
            my $self = shift;
            my @ret  = (
                'M  path/to/file_one.pm',
                'M  path/to/file_two.pm',
            );

            return @ret;
        },
    );

    my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir', verbose => 1 );

    my @ret = $gwm->diffbranches( 'dummy_branch', 'master' );

    like( $ret[0], qr/one/, 'finds module one' );
    like( $ret[1], qr/two/, 'finds module two' );
    unlike( $ret[0], qr/^M| /, 'only prints file name, not M or space' );
    unlike( $ret[1], qr/^M| /, 'only prints file name, not M or space' );
}

exit;

__END__
