/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDescriptor;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpegDirectory
extends Directory {
    public static final int TAG_JPEG_COMPRESSION_TYPE = -3;
    public static final int TAG_JPEG_DATA_PRECISION = 0;
    public static final int TAG_JPEG_IMAGE_HEIGHT = 1;
    public static final int TAG_JPEG_IMAGE_WIDTH = 3;
    public static final int TAG_JPEG_NUMBER_OF_COMPONENTS = 5;
    public static final int TAG_JPEG_COMPONENT_DATA_1 = 6;
    public static final int TAG_JPEG_COMPONENT_DATA_2 = 7;
    public static final int TAG_JPEG_COMPONENT_DATA_3 = 8;
    public static final int TAG_JPEG_COMPONENT_DATA_4 = 9;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();

    public JpegDirectory() {
        this.setDescriptor(new JpegDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Jpeg";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    @Nullable
    public JpegComponent getComponent(int componentNumber) {
        int tagType = 6 + componentNumber;
        return (JpegComponent)this.getObject(tagType);
    }

    public int getImageWidth() throws MetadataException {
        return this.getInt(3);
    }

    public int getImageHeight() throws MetadataException {
        return this.getInt(1);
    }

    public int getNumberOfComponents() throws MetadataException {
        return this.getInt(5);
    }

    static {
        _tagNameMap.put(-3, "Compression Type");
        _tagNameMap.put(0, "Data Precision");
        _tagNameMap.put(3, "Image Width");
        _tagNameMap.put(1, "Image Height");
        _tagNameMap.put(5, "Number of Components");
        _tagNameMap.put(6, "Component 1");
        _tagNameMap.put(7, "Component 2");
        _tagNameMap.put(8, "Component 3");
        _tagNameMap.put(9, "Component 4");
    }
}

