package Microsoft::AdCenter::V6::CustomerManagementService::CurrencyType;
# Copyright (C) 2011 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V6::CustomerManagementService::CurrencyType - Represents "CurrencyType" in Microsoft AdCenter Customer Management Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AustralianDollar
    CanadianDollar
    DanishKrone
    EURO
    JapaneseYen
    NewZealandDollar
    NorwegianKrone
    SingaporeDollar
    SouthAfricanRand
    SwissFranc
    UKPound
    USDollar

=cut

sub AustralianDollar {
    return 'AustralianDollar';
}

sub CanadianDollar {
    return 'CanadianDollar';
}

sub DanishKrone {
    return 'DanishKrone';
}

sub EURO {
    return 'EURO';
}

sub JapaneseYen {
    return 'JapaneseYen';
}

sub NewZealandDollar {
    return 'NewZealandDollar';
}

sub NorwegianKrone {
    return 'NorwegianKrone';
}

sub SingaporeDollar {
    return 'SingaporeDollar';
}

sub SouthAfricanRand {
    return 'SouthAfricanRand';
}

sub SwissFranc {
    return 'SwissFranc';
}

sub UKPound {
    return 'UKPound';
}

sub USDollar {
    return 'USDollar';
}

1;
