! { dg-do compile }
!
! Check the support by the compiler of very long symbol names in SELECT TYPE
! and TYPE IS statements.
!
! Original testcase by Harald Anlauf.

module m
  implicit none
  type t2345678901234567890123456789012345678901234567890123456789_123
     integer :: i
  end type t2345678901234567890123456789012345678901234567890123456789_123
  class(*), allocatable :: a, &
       c2345678901234567890123456789012345678901234567890123456789_123
contains
  subroutine check_type_is_intrinsic()
    select type (s2345678901234567890123456789012345678901234567890123456789_123 &
         => c2345678901234567890123456789012345678901234567890123456789_123)
    type is (integer(kind=4))
       print *, s2345678901234567890123456789012345678901234567890123456789_123
    end select
  end subroutine
  subroutine check_type_is_derived()
    select type (s2345678901234567890123456789012345678901234567890123456789_123 &
         => c2345678901234567890123456789012345678901234567890123456789_123)
    type is (t2345678901234567890123456789012345678901234567890123456789_123)
       print *, s2345678901234567890123456789012345678901234567890123456789_123%i
    end select
  end subroutine
  subroutine check_type_is_class()
    select type (s2345678901234567890123456789012345678901234567890123456789_123 &
         => c2345678901234567890123456789012345678901234567890123456789_123)
    class is (t2345678901234567890123456789012345678901234567890123456789_123)
       print *, s2345678901234567890123456789012345678901234567890123456789_123%i
    end select
  end subroutine
end module m
