//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerlockbox

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// PostClient contains the methods for the Post group.
// Don't use this type directly, use NewPostClient() instead.
type PostClient struct {
	internal *arm.Client
}

// NewPostClient creates a new instance of PostClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewPostClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*PostClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &PostClient{
		internal: cl,
	}
	return client, nil
}

// DisableLockbox - Disable Tenant for Lockbox
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-02-28-preview
//   - options - PostClientDisableLockboxOptions contains the optional parameters for the PostClient.DisableLockbox method.
func (client *PostClient) DisableLockbox(ctx context.Context, options *PostClientDisableLockboxOptions) (PostClientDisableLockboxResponse, error) {
	var err error
	const operationName = "PostClient.DisableLockbox"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.disableLockboxCreateRequest(ctx, options)
	if err != nil {
		return PostClientDisableLockboxResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PostClientDisableLockboxResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PostClientDisableLockboxResponse{}, err
	}
	return PostClientDisableLockboxResponse{}, nil
}

// disableLockboxCreateRequest creates the DisableLockbox request.
func (client *PostClient) disableLockboxCreateRequest(ctx context.Context, options *PostClientDisableLockboxOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CustomerLockbox/disableLockbox"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-02-28-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// EnableLockbox - Enable Tenant for Lockbox
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-02-28-preview
//   - options - PostClientEnableLockboxOptions contains the optional parameters for the PostClient.EnableLockbox method.
func (client *PostClient) EnableLockbox(ctx context.Context, options *PostClientEnableLockboxOptions) (PostClientEnableLockboxResponse, error) {
	var err error
	const operationName = "PostClient.EnableLockbox"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.enableLockboxCreateRequest(ctx, options)
	if err != nil {
		return PostClientEnableLockboxResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PostClientEnableLockboxResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PostClientEnableLockboxResponse{}, err
	}
	return PostClientEnableLockboxResponse{}, nil
}

// enableLockboxCreateRequest creates the EnableLockbox request.
func (client *PostClient) enableLockboxCreateRequest(ctx context.Context, options *PostClientEnableLockboxOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CustomerLockbox/enableLockbox"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-02-28-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
