
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_blas.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_dasum( HYPRE_Int *n, HYPRE_Real *dx, HYPRE_Int *incx )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dasum)( n, dx, incx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_daxpy( HYPRE_Int *n, HYPRE_Real *da, HYPRE_Real *dx, HYPRE_Int *incx, HYPRE_Real *dy, HYPRE_Int *incy )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_daxpy)( n, da, dx, incx, dy, incy );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dcopy( HYPRE_Int *n, HYPRE_Real *dx, HYPRE_Int *incx, HYPRE_Real *dy, HYPRE_Int *incy )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dcopy)( n, dx, incx, dy, incy );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_ddot( HYPRE_Int *n, HYPRE_Real *dx, HYPRE_Int *incx, HYPRE_Real *dy, HYPRE_Int *incy )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ddot)( n, dx, incx, dy, incy );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgemm( const char *transa, const char *transb, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *alpha, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb, HYPRE_Real *beta, HYPRE_Real *c, HYPRE_Int *ldc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgemm)( transa, transb, m, n, k, alpha, a, lda, b, ldb, beta, c, ldc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgemv( const char *trans, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *alpha, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *x, HYPRE_Int *incx, HYPRE_Real *beta, HYPRE_Real *y, HYPRE_Int *incy )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgemv)( trans, m, n, alpha, a, lda, x, incx, beta, y, incy );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dger( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *alpha, HYPRE_Real *x, HYPRE_Int *incx, HYPRE_Real *y, HYPRE_Int *incy, HYPRE_Real *a, HYPRE_Int *lda )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dger)( m, n, alpha, x, incx, y, incy, a, lda );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_dnrm2( HYPRE_Int *n, HYPRE_Real *dx, HYPRE_Int *incx )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dnrm2)( n, dx, incx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_drot( HYPRE_Int *n, HYPRE_Real *dx, HYPRE_Int *incx, HYPRE_Real *dy, HYPRE_Int *incy, HYPRE_Real *c, HYPRE_Real *s )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_drot)( n, dx, incx, dy, incy, c, s );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dscal( HYPRE_Int *n, HYPRE_Real *da, HYPRE_Real *dx, HYPRE_Int *incx )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dscal)( n, da, dx, incx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dswap( HYPRE_Int *n, HYPRE_Real *dx, HYPRE_Int *incx, HYPRE_Real *dy, HYPRE_Int *incy )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dswap)( n, dx, incx, dy, incy );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsymm( const char *side, const char *uplo, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *alpha, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb, HYPRE_Real *beta, HYPRE_Real *c__, HYPRE_Int *ldc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsymm)( side, uplo, m, n, alpha, a, lda, b, ldb, beta, c__, ldc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsymv( const char *uplo, HYPRE_Int *n, HYPRE_Real *alpha, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *x, HYPRE_Int *incx, HYPRE_Real *beta, HYPRE_Real *y, HYPRE_Int *incy )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsymv)( uplo, n, alpha, a, lda, x, incx, beta, y, incy );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsyr2( const char *uplo, HYPRE_Int *n, HYPRE_Real *alpha, HYPRE_Real *x, HYPRE_Int *incx, HYPRE_Real *y, HYPRE_Int *incy, HYPRE_Real *a, HYPRE_Int *lda )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsyr2)( uplo, n, alpha, x, incx, y, incy, a, lda );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsyr2k( const char *uplo, const char *trans, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *alpha, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb, HYPRE_Real *beta, HYPRE_Real *c__, HYPRE_Int *ldc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsyr2k)( uplo, trans, n, k, alpha, a, lda, b, ldb, beta, c__, ldc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsyrk( const char *uplo, const char *trans, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *alpha, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *beta, HYPRE_Real *c, HYPRE_Int *ldc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsyrk)( uplo, trans, n, k, alpha, a, lda, beta, c, ldc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dtrmm( const char *side, const char *uplo, const char *transa, const char *diag, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *alpha, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dtrmm)( side, uplo, transa, diag, m, n, alpha, a, lda, b, ldb );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dtrmv( const char *uplo, const char *trans, const char *diag, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *x, HYPRE_Int *incx )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dtrmv)( uplo, trans, diag, n, a, lda, x, incx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dtrsm( const char *side, const char *uplo, const char *transa, const char *diag, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *alpha, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dtrsm)( side, uplo, transa, diag, m, n, alpha, a, lda, b, ldb );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dtrsv( const char *uplo, const char *trans, const char *diag, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *x, HYPRE_Int *incx )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dtrsv)( uplo, trans, diag, n, a, lda, x, incx );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_idamax( HYPRE_Int *n, HYPRE_Real *dx, HYPRE_Int *incx )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_idamax)( n, dx, incx );
}


#endif

