
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_parcsr_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixToParCSRMatrix( MPI_Comm comm, HYPRE_CSRMatrix A_CSR, HYPRE_BigInt *row_partitioning, HYPRE_BigInt *col_partitioning, HYPRE_ParCSRMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CSRMatrixToParCSRMatrix_pre( precision, comm, A_CSR, row_partitioning, col_partitioning, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixToParCSRMatrix_WithNewPartitioning( MPI_Comm comm, HYPRE_CSRMatrix A_CSR, HYPRE_ParCSRMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CSRMatrixToParCSRMatrix_WithNewPartitioning_pre( precision, comm, A_CSR, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixComputeScalingTagged( HYPRE_ParCSRMatrix A, HYPRE_Int type, HYPRE_MemoryLocation memloc_tags, HYPRE_Int num_tags, HYPRE_Int *tags, HYPRE_ParVector *scaling_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixComputeScalingTagged_pre( precision, A, type, memloc_tags, num_tags, tags, scaling_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixCreate( MPI_Comm comm, HYPRE_BigInt global_num_rows, HYPRE_BigInt global_num_cols, HYPRE_BigInt *row_starts, HYPRE_BigInt *col_starts, HYPRE_Int num_cols_offd, HYPRE_Int num_nonzeros_diag, HYPRE_Int num_nonzeros_offd, HYPRE_ParCSRMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixCreate_pre( precision, comm, global_num_rows, global_num_cols, row_starts, col_starts, num_cols_offd, num_nonzeros_diag, num_nonzeros_offd, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixDestroy( HYPRE_ParCSRMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixDestroy_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixDiagScale( HYPRE_ParCSRMatrix A, HYPRE_ParVector left, HYPRE_ParVector right )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixDiagScale_pre( precision, A, left, right );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetColPartitioning( HYPRE_ParCSRMatrix matrix, HYPRE_BigInt **col_partitioning_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixGetColPartitioning_pre( precision, matrix, col_partitioning_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetComm( HYPRE_ParCSRMatrix matrix, MPI_Comm *comm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixGetComm_pre( precision, matrix, comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetDims( HYPRE_ParCSRMatrix matrix, HYPRE_BigInt *M, HYPRE_BigInt *N )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixGetDims_pre( precision, matrix, M, N );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetGlobalRowPartitioning( HYPRE_ParCSRMatrix matrix, HYPRE_Int all_procs, HYPRE_BigInt **row_partitioning_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixGetGlobalRowPartitioning_pre( precision, matrix, all_procs, row_partitioning_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetLocalRange( HYPRE_ParCSRMatrix matrix, HYPRE_BigInt *row_start, HYPRE_BigInt *row_end, HYPRE_BigInt *col_start, HYPRE_BigInt *col_end )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixGetLocalRange_pre( precision, matrix, row_start, row_end, col_start, col_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetRow( HYPRE_ParCSRMatrix matrix, HYPRE_BigInt row, HYPRE_Int *size, HYPRE_BigInt **col_ind, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixGetRow_pre( precision, matrix, row, size, col_ind, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetRowPartitioning( HYPRE_ParCSRMatrix matrix, HYPRE_BigInt **row_partitioning_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixGetRowPartitioning_pre( precision, matrix, row_partitioning_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixInitialize( HYPRE_ParCSRMatrix matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixInitialize_pre( precision, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixMatmat( HYPRE_ParCSRMatrix A, HYPRE_ParCSRMatrix B, HYPRE_ParCSRMatrix *C )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixMatmat_pre( precision, A, B, C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixMatvec( hypre_long_double alpha, HYPRE_ParCSRMatrix A, HYPRE_ParVector x, hypre_long_double beta, HYPRE_ParVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixMatvec_pre( precision, alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixMatvecT( hypre_long_double alpha, HYPRE_ParCSRMatrix A, HYPRE_ParVector x, hypre_long_double beta, HYPRE_ParVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixMatvecT_pre( precision, alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixPrint( HYPRE_ParCSRMatrix matrix, const char *file_name )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixPrint_pre( precision, matrix, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixRead( MPI_Comm comm, const char *file_name, HYPRE_ParCSRMatrix *matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixRead_pre( precision, comm, file_name, matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixRestoreRow( HYPRE_ParCSRMatrix matrix, HYPRE_BigInt row, HYPRE_Int *size, HYPRE_BigInt **col_ind, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParCSRMatrixRestoreRow_pre( precision, matrix, row, size, col_ind, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParMultiVectorCreate( MPI_Comm comm, HYPRE_BigInt global_size, HYPRE_BigInt *partitioning, HYPRE_Int number_vectors, HYPRE_ParVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParMultiVectorCreate_pre( precision, comm, global_size, partitioning, number_vectors, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorAxpy( hypre_long_double alpha, HYPRE_ParVector x, HYPRE_ParVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorAxpy_pre( precision, alpha, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_ParVector
HYPRE_ParVectorCloneShallow( HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorCloneShallow_pre( precision, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorCopy( HYPRE_ParVector x, HYPRE_ParVector y )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorCopy_pre( precision, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorCreate( MPI_Comm comm, HYPRE_BigInt global_size, HYPRE_BigInt *partitioning, HYPRE_ParVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorCreate_pre( precision, comm, global_size, partitioning, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorDestroy( HYPRE_ParVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorDestroy_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorGetValues( HYPRE_ParVector vector, HYPRE_Int num_values, HYPRE_BigInt *indices, void *values )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorGetValues_pre( precision, vector, num_values, indices, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorInitialize( HYPRE_ParVector vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorInitialize_pre( precision, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorInnerProd( HYPRE_ParVector x, HYPRE_ParVector y, void *result )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorInnerProd_pre( precision, x, y, result );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorPrint( HYPRE_ParVector vector, const char *file_name )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorPrint_pre( precision, vector, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorPrintBinaryIJ( HYPRE_ParVector vector, const char *file_name )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorPrintBinaryIJ_pre( precision, vector, file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorRead( MPI_Comm comm, const char *file_name, HYPRE_ParVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorRead_pre( precision, comm, file_name, vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorScale( hypre_long_double value, HYPRE_ParVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorScale_pre( precision, value, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorSetConstantValues( HYPRE_ParVector vector, hypre_long_double value )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorSetConstantValues_pre( precision, vector, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorSetRandomValues( HYPRE_ParVector vector, HYPRE_Int seed )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_ParVectorSetRandomValues_pre( precision, vector, seed );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorToParVector( MPI_Comm comm, HYPRE_Vector b, HYPRE_BigInt *partitioning, HYPRE_ParVector *vector )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_VectorToParVector_pre( precision, comm, b, partitioning, vector );
}


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Destroy2DSystem( HYPRE_ParCSR_System_Problem *sys_prob )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_Destroy2DSystem_pre( precision, sys_prob );
}

/*--------------------------------------------------------------------------*/

HYPRE_ParCSR_System_Problem *
HYPRE_Generate2DSystem( HYPRE_ParCSRMatrix H_L1, HYPRE_ParCSRMatrix H_L2, HYPRE_ParVector H_b1, HYPRE_ParVector H_b2, HYPRE_ParVector H_x1, HYPRE_ParVector H_x2, void *M_vals )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_Generate2DSystem_pre( precision, H_L1, H_L2, H_b1, H_b2, H_x1, H_x2, M_vals );
}


#endif

