
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_sstruct_ls.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABCreate( MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABDestroy( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABGetFinalRelativeResidualNorm( HYPRE_SStructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABGetNumIterations( HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABGetResidual( HYPRE_SStructSolver solver, void **residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetAbsoluteTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetLogging( HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetMaxIter( HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetMinIter( HYPRE_SStructSolver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetPrecond( HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetPrintLevel( HYPRE_SStructSolver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetStopCrit( HYPRE_SStructSolver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSetup( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructBiCGSTABSolve( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructBiCGSTABSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructDiagScale( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector y, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructDiagScale_pre( precision, solver, A, y, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructDiagScaleSetup( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector y, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructDiagScaleSetup_pre( precision, solver, A, y, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESCreate( MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESDestroy( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESGetFinalRelativeResidualNorm( HYPRE_SStructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESGetNumIterations( HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESGetResidual( HYPRE_SStructSolver solver, void **residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetAbsoluteTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetKDim( HYPRE_SStructSolver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetLogging( HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetMaxIter( HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetMinIter( HYPRE_SStructSolver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetModifyPC( HYPRE_SStructSolver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetModifyPC_pre( precision, solver, modify_pc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetPrecond( HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetPrintLevel( HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSetup( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructFlexGMRESSolve( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructFlexGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESCreate( MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESDestroy( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESGetFinalRelativeResidualNorm( HYPRE_SStructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESGetNumIterations( HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESGetResidual( HYPRE_SStructSolver solver, void **residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetAbsoluteTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetKDim( HYPRE_SStructSolver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetLogging( HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetMaxIter( HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetMinIter( HYPRE_SStructSolver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetPrecond( HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetPrintLevel( HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetStopCrit( HYPRE_SStructSolver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSetup( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructGMRESSolve( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESCreate( MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESDestroy( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESGetFinalRelativeResidualNorm( HYPRE_SStructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESGetNumIterations( HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESGetResidual( HYPRE_SStructSolver solver, void **residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetAbsoluteTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetAugDim( HYPRE_SStructSolver solver, HYPRE_Int aug_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetAugDim_pre( precision, solver, aug_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetKDim( HYPRE_SStructSolver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetLogging( HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetMaxIter( HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetMinIter( HYPRE_SStructSolver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetPrecond( HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetPrintLevel( HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSetup( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructLGMRESSolve( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructLGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGCreate( MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGDestroy( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGGetFinalRelativeResidualNorm( HYPRE_SStructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGGetNumIterations( HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGGetResidual( HYPRE_SStructSolver solver, void **residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetAbsoluteTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetLogging( HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetMaxIter( HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetPrecond( HYPRE_SStructSolver solver, HYPRE_PtrToSStructSolverFcn precond, HYPRE_PtrToSStructSolverFcn precond_setup, void *precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetPrintLevel( HYPRE_SStructSolver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetRelChange( HYPRE_SStructSolver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetTwoNorm( HYPRE_SStructSolver solver, HYPRE_Int two_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSetTwoNorm_pre( precision, solver, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSetup( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructPCGSolve( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructPCGSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGCreate( MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGDestroy( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGGetFinalRelativeResidualNorm( HYPRE_SStructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGGetNumIterations( HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetCoarseSolverType( HYPRE_SStructSolver solver, HYPRE_Int csolver_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetCoarseSolverType_pre( precision, solver, csolver_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetDxyz( HYPRE_SStructSolver solver, HYPRE_Int nparts, void *dxyz )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetDxyz_pre( precision, solver, nparts, dxyz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetInterpType( HYPRE_SStructSolver solver, HYPRE_Int interp_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetInterpType_pre( precision, solver, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetLogging( HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetMaxCoarseSize( HYPRE_SStructSolver solver, HYPRE_Int max_coarse_size )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetMaxCoarseSize_pre( precision, solver, max_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetMaxIter( HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetMaxLevels( HYPRE_SStructSolver solver, HYPRE_Int max_levels )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetMaxLevels_pre( precision, solver, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNonGalerkinRAP( HYPRE_SStructSolver solver, HYPRE_Int non_galerkin )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetNonGalerkinRAP_pre( precision, solver, non_galerkin );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNonZeroGuess( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetNonZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNumCoarseRelax( HYPRE_SStructSolver solver, HYPRE_Int num_coarse_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetNumCoarseRelax_pre( precision, solver, num_coarse_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNumPostRelax( HYPRE_SStructSolver solver, HYPRE_Int num_post_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetNumPostRelax_pre( precision, solver, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetNumPreRelax( HYPRE_SStructSolver solver, HYPRE_Int num_pre_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetNumPreRelax_pre( precision, solver, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetPrintFreq( HYPRE_SStructSolver solver, HYPRE_Int print_freq )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetPrintFreq_pre( precision, solver, print_freq );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetPrintLevel( HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetRelChange( HYPRE_SStructSolver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetRelaxType( HYPRE_SStructSolver solver, HYPRE_Int relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetRelaxType_pre( precision, solver, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetRelaxWeight( HYPRE_SStructSolver solver, hypre_long_double weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetRelaxWeight_pre( precision, solver, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetSkipRelax( HYPRE_SStructSolver solver, HYPRE_Int skip_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetSkipRelax_pre( precision, solver, skip_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetZeroGuess( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSetup( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSSAMGSolve( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSSAMGSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSetupInterpreter( mv_InterfaceInterpreter *i )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSetupInterpreter_pre( precision, i );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSetupMatvec( HYPRE_MatvecFunctions *mv )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSetupMatvec_pre( precision, mv );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitCreate( MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitDestroy( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitGetFinalRelativeResidualNorm( HYPRE_SStructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitGetNumIterations( HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitPrintLogging( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitPrintLogging_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetLogging( HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetMaxIter( HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetNonZeroGuess( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitSetNonZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetPrintLevel( HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetStructSolver( HYPRE_SStructSolver solver, HYPRE_Int ssolver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitSetStructSolver_pre( precision, solver, ssolver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetZeroGuess( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitSetZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSetup( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSplitSolve( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSplitSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGCreate( MPI_Comm comm, HYPRE_SStructSolver *solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGCreate_pre( precision, comm, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGDestroy( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGGetFinalRelativeResidualNorm( HYPRE_SStructSolver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGGetNumIterations( HYPRE_SStructSolver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetDxyz( HYPRE_SStructSolver solver, void *dxyz )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetDxyz_pre( precision, solver, dxyz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetJacobiWeight( HYPRE_SStructSolver solver, hypre_long_double weight )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetJacobiWeight_pre( precision, solver, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetLogging( HYPRE_SStructSolver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetMaxIter( HYPRE_SStructSolver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetNonZeroGuess( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetNonZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetNumPostRelax( HYPRE_SStructSolver solver, HYPRE_Int num_post_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetNumPostRelax_pre( precision, solver, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetNumPreRelax( HYPRE_SStructSolver solver, HYPRE_Int num_pre_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetNumPreRelax_pre( precision, solver, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetPrintLevel( HYPRE_SStructSolver solver, HYPRE_Int print_level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetPrintLevel_pre( precision, solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetRelChange( HYPRE_SStructSolver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetRelaxType( HYPRE_SStructSolver solver, HYPRE_Int relax_type )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetRelaxType_pre( precision, solver, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetSkipRelax( HYPRE_SStructSolver solver, HYPRE_Int skip_relax )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetSkipRelax_pre( precision, solver, skip_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetTol( HYPRE_SStructSolver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetZeroGuess( HYPRE_SStructSolver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetZeroGuess_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSetup( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SStructSysPFMGSolve( HYPRE_SStructSolver solver, HYPRE_SStructMatrix A, HYPRE_SStructVector b, HYPRE_SStructVector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_SStructSysPFMGSolve_pre( precision, solver, A, b, x );
}



#endif

