#include <iostream>
#include <list>
#include <random>
#include <vector>

#include "test.h"

#include "base64.h"

using namespace std;

/* randomly convert to and from base64, should be the same */
TEST_CASE("base64 random use") {
	mt19937 rng(random_device{}());
	uniform_int_distribution<uint8_t> char_dist;
	for (int i = 0; i < 100; ++i) {
		uniform_int_distribution<int> len_dist(10, 1000);
		size_t len = len_dist(rng);
		string s;
		s.reserve(len);
		for (size_t j = 0; j < len; ++j) {
			char c = static_cast<char>(char_dist(rng));
			s += c;
		}
		CHECK(Base64::decode(Base64::encode(s)) == s);
	}
}

