; APX arithmetic testcases

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro

bits 64

; adc instruction: reg = reg + r/m
; adc non-apx control group
testcase	{0x10, 0x0A},				{adc [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x11, 0x0A},			{adc [rdx],cx}		;r16 + r/m16
testcase	{0x11, 0x0A},				{adc [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x11, 0x0A},			{adc [rdx],rcx}		;r64 + r/m64

; adc explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x10, 0x0A},	{adc{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x11, 0x0A},	{adc{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x11, 0x0A},	{adc{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x11, 0x0A},	{adc{evex} [rdx],rcx}		;r64 + r/m64

; adc REX2
testcase	{0xD5, 0x44, 0x10, 0x0A},		{adc [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x11, 0x0A},		{adc [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x11, 0x0A},		{adc [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x11, 0x0A},		{adc [rdx],r25}			;er64 + r/m64

; adc implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x10, 0x0A},	{adc bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x11, 0x0A},	{adc bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x11, 0x0A},	{adc ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x11, 0x0A},	{adc rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x10, 0x0A},	{adc r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x11, 0x0A},	{adc r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x11, 0x0A},	{adc r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x11, 0x0A},	{adc r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; adc instruction: r/m = reg + r/m
; adc non-apx control group
testcase	{0x12, 0x0A},				{adc cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x13, 0x0A},			{adc cx,[rdx]}		;r16 + r/m16
testcase	{0x13, 0x0A},				{adc ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x13, 0x0A},			{adc rcx,[rdx]}		;r64 + r/m64

; adc explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x12, 0x0A},	{adc{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x13, 0x0A},	{adc{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x13, 0x0A},	{adc{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x13, 0x0A},	{adc{evex} rcx,[rdx]}		;r64 + r/m64

; adc REX2
testcase	{0xD5, 0x44, 0x12, 0x0A},		{adc r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x13, 0x0A},		{adc r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x13, 0x0A},		{adc r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x13, 0x0A},		{adc r25,[rdx]}			;er64 + r/m64

; adc implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x12, 0x0A},	{adc bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x13, 0x0A},	{adc bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x13, 0x0A},	{adc ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x13, 0x0A},	{adc rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x12, 0x0A},	{adc r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x13, 0x0A},	{adc r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x13, 0x0A},	{adc r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x13, 0x0A},	{adc r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; adc instruction: r/m = r/m + imm
; adc non-apx control group
testcase	{0x80, 0x12, 0xFF}, \
			{adc byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x12, 0xFF, 0xFF}, \
			{adc word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x12, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{adc dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x12, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{adc qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x12, 0x7F}, \
			{adc word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x12, 0x7F}, \
			{adc dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x12, 0x7F}, \
			{adc qword [rdx], byte 0x7F}			;r/m64 + imm8

; adc REX2
testcase	{0xD5, 0x11, 0x80, 0x11, 0xFF}, \
			{adc byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x11, 0xFF, 0xFF}, \
			{adc word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x11, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{adc dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x11, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{adc qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x11, 0x7F}, \
			{adc word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x11, 0x7F}, \
			{adc dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x11, 0x7F}, \
			{adc qword [r25], byte 0x7F}			;r/m64 + imm8

; adc implicit evex
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x12, 0xFF}, \
			{adc r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x12, 0xFF, 0xFF}, \
			{adc r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x12, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{adc r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x12, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{adc r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x11, 0x7F}, \
			{adc r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x11, 0x7F}, \
			{adc r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x11, 0x7F}, \
			{adc r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; add instruction
; add non-apx control group
testcase	{0x00, 0x0A},				{add [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x01, 0x0A},			{add [rdx],cx}		;r16 + r/m16
testcase	{0x01, 0x0A},				{add [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x01, 0x0A},			{add [rdx],rcx}		;r64 + r/m64

; add explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x00, 0x0A},	{add{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x01, 0x0A},	{add{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x01, 0x0A},	{add{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x01, 0x0A},	{add{evex} [rdx],rcx}		;r64 + r/m64

; add REX2
testcase	{0xD5, 0x44, 0x00, 0x0A},		{add [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x01, 0x0A},		{add [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x01, 0x0A},		{add [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x01, 0x0A},		{add [rdx],r25}			;er64 + r/m64

; add implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x00, 0x0A},	{add bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x01, 0x0A},	{add bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x01, 0x0A},	{add ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x01, 0x0A},	{add rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x00, 0x0A},	{add r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x01, 0x0A},	{add r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x01, 0x0A},	{add r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x01, 0x0A},	{add r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; add instruction: r/m = reg + r/m
; add non-apx control group
testcase	{0x02, 0x0A},				{add cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x03, 0x0A},			{add cx,[rdx]}		;r16 + r/m16
testcase	{0x03, 0x0A},				{add ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x03, 0x0A},			{add rcx,[rdx]}		;r64 + r/m64

; add explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x02, 0x0A},	{add{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x03, 0x0A},	{add{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x03, 0x0A},	{add{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x03, 0x0A},	{add{evex} rcx,[rdx]}		;r64 + r/m64

; add explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x02, 0x0A},	{add{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x03, 0x0A},	{add{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x03, 0x0A},	{add{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x03, 0x0A},	{add{nf} rcx,[rdx]}		;r64 + r/m64

; add REX2
testcase	{0xD5, 0x44, 0x02, 0x0A},		{add r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x03, 0x0A},		{add r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x03, 0x0A},		{add r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x03, 0x0A},		{add r25,[rdx]}			;er64 + r/m64

; add implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x02, 0x0A},	{add bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x03, 0x0A},	{add bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x03, 0x0A},	{add ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x03, 0x0A},	{add rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x02, 0x0A},	{add r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x03, 0x0A},	{add r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x03, 0x0A},	{add r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x03, 0x0A},	{add r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; add implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x02, 0x0A},	{add{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x03, 0x0A},	{add{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x03, 0x0A},	{add{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x03, 0x0A},	{add{nf} rcx,[rdx]}		;r64 + r/m64

; add instruction: r/m = r/m + imm
; add non-apx control group
testcase	{0x80, 0x02, 0xFF}, \
			{add byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x02, 0xFF, 0xFF}, \
			{add word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x02, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{add dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{add qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x02, 0x7F}, \
			{add word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x02, 0x7F}, \
			{add dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x02, 0x7F}, \
			{add qword [rdx], byte 0x7F}			;r/m64 + imm8

; add REX2
testcase	{0xD5, 0x11, 0x80, 0x01, 0xFF}, \
			{add byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x01, 0xFF, 0xFF}, \
			{add word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x01, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{add dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x01, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{add qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x01, 0x7F}, \
			{add word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x01, 0x7F}, \
			{add dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x01, 0x7F}, \
			{add qword [r25], byte 0x7F}			;r/m64 + imm8

; add implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x02, 0xFF}, \
			{add r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x02, 0xFF, 0xFF}, \
			{add r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{add r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{add r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x01, 0x7F}, \
			{add r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x01, 0x7F}, \
			{add r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x01, 0x7F}, \
			{add r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; add implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x02, 0xFF}, \
			{add{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x02, 0xFF, 0xFF}, \
			{add{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{add{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x02, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{add{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x01, 0x7F}, \
			{add{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x01, 0x7F}, \
			{add{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x01, 0x7F}, \
			{add{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; and instruction
; and non-apx control group
testcase	{0x20, 0x0A},				{and [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x21, 0x0A},			{and [rdx],cx}		;r16 + r/m16
testcase	{0x21, 0x0A},				{and [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x21, 0x0A},			{and [rdx],rcx}		;r64 + r/m64

; and explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x20, 0x0A},	{and{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x21, 0x0A},	{and{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x21, 0x0A},	{and{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x21, 0x0A},	{and{evex} [rdx],rcx}		;r64 + r/m64

; and REX2
testcase	{0xD5, 0x44, 0x20, 0x0A},		{and [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x21, 0x0A},		{and [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x21, 0x0A},		{and [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x21, 0x0A},		{and [rdx],r25}			;er64 + r/m64

; and implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x20, 0x0A},	{and bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x21, 0x0A},	{and bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x21, 0x0A},	{and ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x21, 0x0A},	{and rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x20, 0x0A},	{and r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x21, 0x0A},	{and r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x21, 0x0A},	{and r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x21, 0x0A},	{and r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; and instruction: r/m = reg + r/m
; and non-apx control group
testcase	{0x22, 0x0A},				{and cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x23, 0x0A},			{and cx,[rdx]}		;r16 + r/m16
testcase	{0x23, 0x0A},				{and ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x23, 0x0A},			{and rcx,[rdx]}		;r64 + r/m64

; and explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x22, 0x0A},	{and{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x23, 0x0A},	{and{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x23, 0x0A},	{and{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x23, 0x0A},	{and{evex} rcx,[rdx]}		;r64 + r/m64

; and explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x22, 0x0A},	{and{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x23, 0x0A},	{and{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x23, 0x0A},	{and{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x23, 0x0A},	{and{nf} rcx,[rdx]}		;r64 + r/m64

; and REX2
testcase	{0xD5, 0x44, 0x22, 0x0A},		{and r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x23, 0x0A},		{and r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x23, 0x0A},		{and r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x23, 0x0A},		{and r25,[rdx]}			;er64 + r/m64

; and implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x22, 0x0A},	{and bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x23, 0x0A},	{and bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x23, 0x0A},	{and ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x23, 0x0A},	{and rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x22, 0x0A},	{and r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x23, 0x0A},	{and r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x23, 0x0A},	{and r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x23, 0x0A},	{and r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; and implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x22, 0x0A},	{and{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x23, 0x0A},	{and{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x23, 0x0A},	{and{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x23, 0x0A},	{and{nf} rcx,[rdx]}		;r64 + r/m64

; and instruction: r/m = r/m + imm
; and non-apx control group
testcase	{0x80, 0x22, 0xFF}, \
			{and byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x22, 0xFF, 0xFF}, \
			{and word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x22, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{and dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{and qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x22, 0x7F}, \
			{and word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x22, 0x7F}, \
			{and dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x22, 0x7F}, \
			{and qword [rdx], byte 0x7F}			;r/m64 + imm8

; and REX2
testcase	{0xD5, 0x11, 0x80, 0x21, 0xFF}, \
			{and byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x21, 0xFF, 0xFF}, \
			{and word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x21, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{and dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x21, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{and qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x21, 0x7F}, \
			{and word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x21, 0x7F}, \
			{and dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x21, 0x7F}, \
			{and qword [r25], byte 0x7F}			;r/m64 + imm8

; and implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x22, 0xFF}, \
			{and r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x22, 0xFF, 0xFF}, \
			{and r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{and r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{and r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x21, 0x7F}, \
			{and r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x21, 0x7F}, \
			{and r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x21, 0x7F}, \
			{and r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; and implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x22, 0xFF}, \
			{and{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x22, 0xFF, 0xFF}, \
			{and{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{and{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x22, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{and{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x21, 0x7F}, \
			{and{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x21, 0x7F}, \
			{and{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x21, 0x7F}, \
			{and{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; or instruction
; or non-apx control group
testcase	{0x08, 0x0A},				{or [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x09, 0x0A},			{or [rdx],cx}		;r16 + r/m16
testcase	{0x09, 0x0A},				{or [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x09, 0x0A},			{or [rdx],rcx}		;r64 + r/m64

; or explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x08, 0x0A},	{or{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x09, 0x0A},	{or{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x09, 0x0A},	{or{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x09, 0x0A},	{or{evex} [rdx],rcx}		;r64 + r/m64

; or REX2
testcase	{0xD5, 0x44, 0x08, 0x0A},		{or [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x09, 0x0A},		{or [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x09, 0x0A},		{or [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x09, 0x0A},		{or [rdx],r25}			;er64 + r/m64

; or implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x08, 0x0A},	{or bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x09, 0x0A},	{or bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x09, 0x0A},	{or ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x09, 0x0A},	{or rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x08, 0x0A},	{or r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x09, 0x0A},	{or r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x09, 0x0A},	{or r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x09, 0x0A},	{or r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; or instruction: r/m = reg + r/m
; or non-apx control group
testcase	{0x0A, 0x0A},				{or cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x0B, 0x0A},			{or cx,[rdx]}		;r16 + r/m16
testcase	{0x0B, 0x0A},				{or ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x0B, 0x0A},			{or rcx,[rdx]}		;r64 + r/m64

; or explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x0A, 0x0A},	{or{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x0B, 0x0A},	{or{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x0B, 0x0A},	{or{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x0B, 0x0A},	{or{evex} rcx,[rdx]}		;r64 + r/m64

; or explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x0A, 0x0A},	{or{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x0B, 0x0A},	{or{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x0B, 0x0A},	{or{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x0B, 0x0A},	{or{nf} rcx,[rdx]}		;r64 + r/m64

; or REX2
testcase	{0xD5, 0x44, 0x0A, 0x0A},		{or r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x0B, 0x0A},		{or r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x0B, 0x0A},		{or r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x0B, 0x0A},		{or r25,[rdx]}			;er64 + r/m64

; or implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x0A, 0x0A},	{or bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x0B, 0x0A},	{or bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x0B, 0x0A},	{or ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x0B, 0x0A},	{or rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x0A, 0x0A},	{or r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x0B, 0x0A},	{or r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x0B, 0x0A},	{or r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x0B, 0x0A},	{or r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; or implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x0A, 0x0A},	{or{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x0B, 0x0A},	{or{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x0B, 0x0A},	{or{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x0B, 0x0A},	{or{nf} rcx,[rdx]}		;r64 + r/m64

; or instruction: r/m = r/m + imm
; or non-apx control group
testcase	{0x80, 0x0A, 0xFF}, \
			{or byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x0A, 0xFF, 0xFF}, \
			{or word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{or dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{or qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x0A, 0x7F}, \
			{or word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x0A, 0x7F}, \
			{or dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x0A, 0x7F}, \
			{or qword [rdx], byte 0x7F}			;r/m64 + imm8

; or REX2
testcase	{0xD5, 0x11, 0x80, 0x09, 0xFF}, \
			{or byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x09, 0xFF, 0xFF}, \
			{or word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x09, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{or dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x09, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{or qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x09, 0x7F}, \
			{or word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x09, 0x7F}, \
			{or dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x09, 0x7F}, \
			{or qword [r25], byte 0x7F}			;r/m64 + imm8

; or implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x0A, 0xFF}, \
			{or r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x0A, 0xFF, 0xFF}, \
			{or r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{or r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{or r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x09, 0x7F}, \
			{or r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x09, 0x7F}, \
			{or r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x09, 0x7F}, \
			{or r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; or implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x0A, 0xFF}, \
			{or{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x0A, 0xFF, 0xFF}, \
			{or{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{or{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x0A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{or{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x09, 0x7F}, \
			{or{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x09, 0x7F}, \
			{or{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x09, 0x7F}, \
			{or{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; sbb instruction
; sbb non-apx control group
testcase	{0x18, 0x0A},				{sbb [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x19, 0x0A},			{sbb [rdx],cx}		;r16 + r/m16
testcase	{0x19, 0x0A},				{sbb [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x19, 0x0A},			{sbb [rdx],rcx}		;r64 + r/m64

; sbb explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x18, 0x0A},	{sbb{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x19, 0x0A},	{sbb{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x19, 0x0A},	{sbb{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x19, 0x0A},	{sbb{evex} [rdx],rcx}		;r64 + r/m64

; sbb REX2
testcase	{0xD5, 0x44, 0x18, 0x0A},		{sbb [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x19, 0x0A},		{sbb [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x19, 0x0A},		{sbb [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x19, 0x0A},		{sbb [rdx],r25}			;er64 + r/m64

; sbb implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x18, 0x0A},	{sbb bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x19, 0x0A},	{sbb bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x19, 0x0A},	{sbb ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x19, 0x0A},	{sbb rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x18, 0x0A},	{sbb r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x19, 0x0A},	{sbb r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x19, 0x0A},	{sbb r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x19, 0x0A},	{sbb r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; sbb instruction: r/m = reg + r/m
; sbb non-apx control group
testcase	{0x1A, 0x0A},				{sbb cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x1B, 0x0A},			{sbb cx,[rdx]}		;r16 + r/m16
testcase	{0x1B, 0x0A},				{sbb ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x1B, 0x0A},			{sbb rcx,[rdx]}		;r64 + r/m64

; sbb explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x1A, 0x0A},	{sbb{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x1B, 0x0A},	{sbb{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x1B, 0x0A},	{sbb{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x1B, 0x0A},	{sbb{evex} rcx,[rdx]}		;r64 + r/m64

; sbb REX2
testcase	{0xD5, 0x44, 0x1A, 0x0A},		{sbb r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x1B, 0x0A},		{sbb r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x1B, 0x0A},		{sbb r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x1B, 0x0A},		{sbb r25,[rdx]}			;er64 + r/m64

; sbb implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x1A, 0x0A},	{sbb bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x1B, 0x0A},	{sbb bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x1B, 0x0A},	{sbb ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x1B, 0x0A},	{sbb rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x1A, 0x0A},	{sbb r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x1B, 0x0A},	{sbb r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x1B, 0x0A},	{sbb r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x1B, 0x0A},	{sbb r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; sbb instruction: r/m = r/m + imm
; sbb non-apx control group
testcase	{0x80, 0x1A, 0xFF}, \
			{sbb byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x1A, 0xFF, 0xFF}, \
			{sbb word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sbb dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sbb qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x1A, 0x7F}, \
			{sbb word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x1A, 0x7F}, \
			{sbb dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x1A, 0x7F}, \
			{sbb qword [rdx], byte 0x7F}			;r/m64 + imm8

; sbb REX2
testcase	{0xD5, 0x11, 0x80, 0x19, 0xFF}, \
			{sbb byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x19, 0xFF, 0xFF}, \
			{sbb word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x19, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sbb dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x19, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sbb qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x19, 0x7F}, \
			{sbb word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x19, 0x7F}, \
			{sbb dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x19, 0x7F}, \
			{sbb qword [r25], byte 0x7F}			;r/m64 + imm8

; sbb implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x1A, 0xFF}, \
			{sbb r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x1A, 0xFF, 0xFF}, \
			{sbb r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sbb r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x1A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sbb r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x19, 0x7F}, \
			{sbb r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x19, 0x7F}, \
			{sbb r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x19, 0x7F}, \
			{sbb r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; sub instruction
; sub non-apx control group
testcase	{0x28, 0x0A},				{sub [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x29, 0x0A},			{sub [rdx],cx}		;r16 + r/m16
testcase	{0x29, 0x0A},				{sub [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x29, 0x0A},			{sub [rdx],rcx}		;r64 + r/m64

; sub explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x28, 0x0A},	{sub{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x29, 0x0A},	{sub{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x29, 0x0A},	{sub{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x29, 0x0A},	{sub{evex} [rdx],rcx}		;r64 + r/m64

; sub REX2
testcase	{0xD5, 0x44, 0x28, 0x0A},		{sub [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x29, 0x0A},		{sub [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x29, 0x0A},		{sub [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x29, 0x0A},		{sub [rdx],r25}			;er64 + r/m64

; sub implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x28, 0x0A},	{sub bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x29, 0x0A},	{sub bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x29, 0x0A},	{sub ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x29, 0x0A},	{sub rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x28, 0x0A},	{sub r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x29, 0x0A},	{sub r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x29, 0x0A},	{sub r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x29, 0x0A},	{sub r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; sub instruction: r/m = reg + r/m
; sub non-apx control group
testcase	{0x2A, 0x0A},				{sub cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x2B, 0x0A},			{sub cx,[rdx]}		;r16 + r/m16
testcase	{0x2B, 0x0A},				{sub ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x2B, 0x0A},			{sub rcx,[rdx]}		;r64 + r/m64

; sub explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x2A, 0x0A},	{sub{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x2B, 0x0A},	{sub{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x2B, 0x0A},	{sub{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x2B, 0x0A},	{sub{evex} rcx,[rdx]}		;r64 + r/m64

; sub explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x2A, 0x0A},	{sub{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x2B, 0x0A},	{sub{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x2B, 0x0A},	{sub{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x2B, 0x0A},	{sub{nf} rcx,[rdx]}		;r64 + r/m64

; sub REX2
testcase	{0xD5, 0x44, 0x2A, 0x0A},		{sub r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x2B, 0x0A},		{sub r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x2B, 0x0A},		{sub r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x2B, 0x0A},		{sub r25,[rdx]}			;er64 + r/m64

; sub implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x2A, 0x0A},	{sub bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x2B, 0x0A},	{sub bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x2B, 0x0A},	{sub ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x2B, 0x0A},	{sub rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x2A, 0x0A},	{sub r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x2B, 0x0A},	{sub r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x2B, 0x0A},	{sub r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x2B, 0x0A},	{sub r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; sub implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x2A, 0x0A},	{sub{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x2B, 0x0A},	{sub{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x2B, 0x0A},	{sub{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x2B, 0x0A},	{sub{nf} rcx,[rdx]}		;r64 + r/m64

; sub instruction: r/m = r/m + imm
; sub non-apx control group
testcase	{0x80, 0x2A, 0xFF}, \
			{sub byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x2A, 0xFF, 0xFF}, \
			{sub word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sub dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sub qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x2A, 0x7F}, \
			{sub word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x2A, 0x7F}, \
			{sub dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x2A, 0x7F}, \
			{sub qword [rdx], byte 0x7F}			;r/m64 + imm8

; sub REX2
testcase	{0xD5, 0x11, 0x80, 0x29, 0xFF}, \
			{sub byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x29, 0xFF, 0xFF}, \
			{sub word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x29, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sub dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x29, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sub qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x29, 0x7F}, \
			{sub word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x29, 0x7F}, \
			{sub dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x29, 0x7F}, \
			{sub qword [r25], byte 0x7F}			;r/m64 + imm8

; sub implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x2A, 0xFF}, \
			{sub r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x2A, 0xFF, 0xFF}, \
			{sub r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sub r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sub r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x29, 0x7F}, \
			{sub r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x29, 0x7F}, \
			{sub r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x29, 0x7F}, \
			{sub r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; sub implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x2A, 0xFF}, \
			{sub{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x2A, 0xFF, 0xFF}, \
			{sub{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{sub{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x2A, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{sub{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x29, 0x7F}, \
			{sub{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x29, 0x7F}, \
			{sub{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x29, 0x7F}, \
			{sub{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; xor instruction
; xor non-apx control group
testcase	{0x30, 0x0A},				{xor [rdx],cl}		;r8 + r/m8
testcase	{0x66, 0x31, 0x0A},			{xor [rdx],cx}		;r16 + r/m16
testcase	{0x31, 0x0A},				{xor [rdx],ecx}		;r32 + r/m32
testcase	{0x48, 0x31, 0x0A},			{xor [rdx],rcx}		;r64 + r/m64

; xor explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x30, 0x0A},	{xor{evex} [rdx],cl}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x31, 0x0A},	{xor{evex} [rdx],cx}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x31, 0x0A},	{xor{evex} [rdx],ecx}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x31, 0x0A},	{xor{evex} [rdx],rcx}		;r64 + r/m64

; xor REX2
testcase	{0xD5, 0x44, 0x30, 0x0A},		{xor [rdx],r25b}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x31, 0x0A},		{xor [rdx],r25w}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x31, 0x0A},		{xor [rdx],r25d}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x31, 0x0A},		{xor [rdx],r25}			;er64 + r/m64

; xor implicit evex
testcase	{0x62, 0xF4, 0x64, 0x18, 0x30, 0x0A},	{xor bl,[rdx],cl}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x31, 0x0A},	{xor bx,[rdx],cx}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x31, 0x0A},	{xor ebx,[rdx],ecx}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x31, 0x0A},	{xor rbx,[rdx],rcx}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x30, 0x0A},	{xor r25b,[rdx],cl}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x31, 0x0A},	{xor r25w,[rdx],cx}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x31, 0x0A},	{xor r25d,[rdx],ecx}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x31, 0x0A},	{xor r25,[rdx],rcx}		;r64 + r/m64 - endd variant

; xor instruction: r/m = reg + r/m
; xor non-apx control group
testcase	{0x32, 0x0A},				{xor cl,[rdx]}		;r8 + r/m8
testcase	{0x66, 0x33, 0x0A},			{xor cx,[rdx]}		;r16 + r/m16
testcase	{0x33, 0x0A},				{xor ecx,[rdx]}		;r32 + r/m32
testcase	{0x48, 0x33, 0x0A},			{xor rcx,[rdx]}		;r64 + r/m64

; xor explicit evex
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x32, 0x0A},	{xor{evex} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x33, 0x0A},	{xor{evex} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x33, 0x0A},	{xor{evex} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x33, 0x0A},	{xor{evex} rcx,[rdx]}		;r64 + r/m64

; xor explicit nf
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x32, 0x0A},	{xor{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x33, 0x0A},	{xor{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x33, 0x0A},	{xor{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x33, 0x0A},	{xor{nf} rcx,[rdx]}		;r64 + r/m64

; xor REX2
testcase	{0xD5, 0x44, 0x32, 0x0A},		{xor r25b,[rdx]}		;er8 + r/m8
testcase	{0x66, 0xD5, 0x44, 0x33, 0x0A},		{xor r25w,[rdx]}		;er16 + r/m16
testcase	{0xD5, 0x44, 0x33, 0x0A},		{xor r25d,[rdx]}		;er32 + r/m32
testcase	{0xD5, 0x4C, 0x33, 0x0A},		{xor r25,[rdx]}			;er64 + r/m64

; xor implicit evex through ND
testcase	{0x62, 0xF4, 0x64, 0x18, 0x32, 0x0A},	{xor bl,cl,[rdx]}		;r8 + r/m8 - ndd variant
testcase	{0x62, 0xF4, 0x65, 0x18, 0x33, 0x0A},	{xor bx,cx,[rdx]}		;r16 + r/m16 - ndd variant
testcase	{0x62, 0xF4, 0x64, 0x18, 0x33, 0x0A},	{xor ebx,ecx,[rdx]}		;r32 + r/m32 - ndd variant
testcase	{0x62, 0xF4, 0xE4, 0x18, 0x33, 0x0A},	{xor rbx,rcx,[rdx]}		;r64 + r/m64 - ndd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x32, 0x0A},	{xor r25b,cl,[rdx]}		;r8 + r/m8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x33, 0x0A},	{xor r25w,cx,[rdx]}		;r16 + r/m16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x33, 0x0A},	{xor r25d,ecx,[rdx]}		;r32 + r/m32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x33, 0x0A},	{xor r25,rcx,[rdx]}		;r64 + r/m64 - endd variant

; xor implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x32, 0x0A},	{xor{nf} cl,[rdx]}		;r8 + r/m8
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x33, 0x0A},	{xor{nf} cx,[rdx]}		;r16 + r/m16
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x33, 0x0A},	{xor{nf} ecx,[rdx]}		;r32 + r/m32
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x33, 0x0A},	{xor{nf} rcx,[rdx]}		;r64 + r/m64

; xor instruction: r/m = r/m + imm
; xor non-apx control group
testcase	{0x80, 0x32, 0xFF}, \
			{xor byte [rdx], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0x81, 0x32, 0xFF, 0xFF}, \
			{xor word [rdx], word 0xFFFF}			;r/m16 + imm16
testcase	{0x81, 0x32, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{xor dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0x48, 0x81, 0x32, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{xor qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0x83, 0x32, 0x7F}, \
			{xor word [rdx], byte 0x7F}			;r/m16 + imm8
testcase	{0x83, 0x32, 0x7F}, \
			{xor dword [rdx], byte 0x7F}			;r/m32 + imm8
testcase	{0x48, 0x83, 0x32, 0x7F}, \
			{xor qword [rdx], byte 0x7F}			;r/m64 + imm8

; xor REX2
testcase	{0xD5, 0x11, 0x80, 0x31, 0xFF}, \
			{xor byte [r25], byte 0xFF}			;r/m8 + imm8
testcase	{0x66, 0xD5, 0x11, 0x81, 0x31, 0xFF, 0xFF}, \
			{xor word [r25], word 0xFFFF}			;r/m16 + imm16
testcase	{0xD5, 0x11, 0x81, 0x31, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{xor dword [r25], dword 0xFFFFFFFF}		;r/m32 + imm32
testcase	{0xD5, 0x19, 0x81, 0x31, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{xor qword [r25], dword 0x7FFFFFFF}		;r/m64 + signed imm32
testcase	{0x66, 0xD5, 0x11, 0x83, 0x31, 0x7F}, \
			{xor word [r25], byte 0x7F}			;r/m16 + imm8
testcase	{0xD5, 0x11, 0x83, 0x31, 0x7F}, \
			{xor dword [r25], byte 0x7F}			;r/m32 + imm8
testcase	{0xD5, 0x19, 0x83, 0x31, 0x7F}, \
			{xor qword [r25], byte 0x7F}			;r/m64 + imm8

; xor implicit evex through ND
testcase	{0x62, 0xF4, 0x34, 0x10, 0x80, 0x32, 0xFF}, \
			{xor r25b, byte [rdx], byte 0xFF}		;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x35, 0x10, 0x81, 0x32, 0xFF, 0xFF}, \
			{xor r25w, word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x34, 0x10, 0x81, 0x32, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{xor r25d, dword [rdx], dword 0xFFFFFFFF}	;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x81, 0x32, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{xor r25, qword [rdx], dword 0x7FFFFFFF}	;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x2D, 0x10, 0x83, 0x31, 0x7F}, \
			{xor r26w, word [r25], byte 0x7F}		;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x2C, 0x10, 0x83, 0x31, 0x7F}, \
			{xor r26d, dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xAC, 0x10, 0x83, 0x31, 0x7F}, \
			{xor r26, qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

; xor implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x32, 0xFF}, \
			{xor{nf} byte [rdx], byte 0xFF}			;r/m8 + imm8 - endd variant
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x32, 0xFF, 0xFF}, \
			{xor{nf} word [rdx], word 0xFFFF}		;r/m16 + imm16 - endd variant
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x32, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{xor{nf} dword [rdx], dword 0xFFFFFFFF}		;r/m32 + imm32 - endd variant
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x32, 0xFF, 0xFF, 0xFF, 0x7F}, \
			{xor{nf} qword [rdx], dword 0x7FFFFFFF}		;r/m64 + signed imm32 - endd variant
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x31, 0x7F}, \
			{xor{nf} word [r25], byte 0x7F}			;r/m16 + imm8 - endd variant
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x31, 0x7F}, \
			{xor{nf} dword [r25], byte 0x7F}		;r/m32 + imm8 - endd variant
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x31, 0x7F}, \
			{xor{nf} qword [r25], byte 0x7F}		;r/m64 + imm8 - endd variant

