% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createLocalBasiliskEnv.R
\name{createLocalBasiliskEnv}
\alias{createLocalBasiliskEnv}
\title{Create a local conda environment manually}
\usage{
createLocalBasiliskEnv(dir, ...)
}
\arguments{
\item{dir}{String containing the path to a directory in which the local environment is to be stored.}

\item{...}{Further arguments to pass to \code{\link{setupBasiliskEnv}}.}
}
\value{
String containing a path to the newly created environment, or to an existing environment if one was previously created.
This can be used in \code{\link{basiliskRun}}.
}
\description{
Manually create a local conda environment with versioning and thread safety.
This is intended for use in analysis workflows rather than package development.
}
\details{
This function is intended for end users who wish to use the \pkg{basilisk} machinery for coordinating one or more Python environments in their analysis workflows.
It can be inserted into, e.g., Rmarkdown reports to automatically provision and cache an environment on first compilation,
which will be automatically re-used in later compilations.
Some care is taken to ensure that the cached environment is refreshed when \pkg{basilisk} is updated,
and that concurrent access to the environment is done safely.
}
\examples{
tmploc <- file.path(tempdir(), "my_package_C")
tmp <- createLocalBasiliskEnv(tmploc, packages="pandas==1.4.3")
basiliskRun(env=tmp, fun=function() { 
    X <- reticulate::import("pandas"); X$`__version__` 
}, testload="pandas")

}
\author{
Aaron Lun
}
