% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/duprateExpPlot.R
\name{duprateExpPlot}
\alias{duprateExpPlot}
\title{Duplication rate ~ total read count plot}
\usage{
duprateExpPlot(DupMat, tNoAlternative = TRUE, tRPKM = TRUE,
  tRPKMval = 0.5, addLegend = TRUE, ...)
}
\arguments{
\item{DupMat}{The duplication matrix calculated by \code{analyzeDuprates}}

\item{tNoAlternative}{Display threshold of 1000 reads per kilobase}

\item{tRPKM}{Display threshold at a given RPKM level}

\item{tRPKMval}{The given RPKM level}

\item{addLegend}{Whether to add a legend to the plot}

\item{...}{Other parameters sent to smoothScatter()}
}
\value{
nothing
}
\description{
\code{duprateExpPlot} Duplication rate ~ total read count plot
}
\details{
This function makes a smooth scatter plot showing the per gene duplication
rate versus the total read count.
}
\examples{
# dm is a duplication matrix calculated by analyzeDuprates:
# R> dm <- analyzeDuprates(bamDuprm,gtf,stranded,paired,threads)
attach(dupRadar_examples)

# duprate plot
duprateExpPlot(DupMat=dm)
}

