% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadFiles.R
\name{uploadFiles}
\alias{uploadFiles}
\title{Upload files for a versioned asset}
\usage{
uploadFiles(init, directory = NULL, url = restUrl(), concurrent = 1)
}
\arguments{
\item{init}{List containing \code{file_urls} and \code{session_token}.
This is typically the return value from \code{\link{startUpload}}.}

\item{directory}{String containing the path to a directory containing the \code{files} to be uploaded.
This directory is assumed to correspond to a version of an asset.
It only has an effect if \code{files} is a character vector, as it is used to determine the MD5 checksums and sizes.
If \code{NULL}, \code{directory} is set to the current working directory.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{concurrent}{Integer specifying the number of concurrent uploads.}
}
\value{
\code{NULL} is invisibly returned on successful upload of all files.
}
\description{
Upload files in an initialized upload session for a version of an asset.
}
\examples{
tmp <- tempfile()
dir.create(tmp)
write(file=file.path(tmp, "blah.txt"), LETTERS)
dir.create(file.path(tmp, "foo"))
write(file=file.path(tmp, "foo", "bar.txt"), 1:10)

if (interactive()) {
    init <- startUpload(
        project="test-R", 
        asset="upload-files-check", 
        version="v1", 
        files=list.files(tmp, recursive=TRUE),
        directory=tmp
    )

    # Executing the upload for all files.
    uploadFiles(init, directory=tmp)

    # Cleaning up after we're done.
    abortUpload(init) 
}

}
\seealso{
\code{\link{startUpload}}, to create \code{init}.
}
\author{
Aaron Lun
}
