% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5F.R
\name{H5Fopen}
\alias{H5Fopen}
\title{Open an existing HDF5 file}
\usage{
H5Fopen(name, flags = h5default("H5F_ACC_RD"), fapl = NULL, native = FALSE)
}
\arguments{
\item{name}{The name (or path) of the HDF5 file to be opened.}

\item{flags}{Character string defining the access mode for opening the file.}

\item{fapl}{\linkS4class{H5IdComponent} object representing a file access property list.
Leaving this argument as \code{NULL} will use the default HDF5 properties.}

\item{native}{An object of class \code{logical}. If \code{TRUE}, array-like
objects are treated as stored in HDF5 row-major rather than R column-major
orientation. Using \code{native = TRUE} increases HDF5 file portability
between programming languages. A file written with \code{native = TRUE}
should also be opened for reading with \code{native = TRUE}.}
}
\description{
Open an existing HDF5 file
}
\details{
Possible values for the \code{flags} argument are \code{H5F_ACC_RDWR} and \code{H5F_ACC_RDONLY}.
Note that HDF5's "Single Write Multiple Reader (SWMR) mode is not currently supported via
\strong{rhdf5}.
}
