% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreakpointGRanges.R
\name{hasPartner}
\alias{hasPartner}
\title{Determines whether this breakend has a valid partner in this
GRanges}
\usage{
hasPartner(gr, selfPartnerSingleBreakends = FALSE)
}
\arguments{
\item{gr}{GRanges object of SV breakends}

\item{selfPartnerSingleBreakends}{treat single breakends as their own partner.}
}
\value{
True/False for each row in the breakpoint GRanges
}
\description{
Determines whether this breakend has a valid partner in this
GRanges
}
\examples{
#Subset to chromosome 6 intra-chromosomal events \code{vcf}
vcf.file <- system.file("extdata", "COLO829T.purple.sv.ann.vcf.gz",
  package = "StructuralVariantAnnotation")
vcf <- VariantAnnotation::readVcf(vcf.file)
gr <- breakpointRanges(vcf)
gr <- gr[seqnames(gr) == "6"]
# We now need to filter out inter-chromosomal events to ensure
# our GRanges doesn't contain any breakpoints whose partner
# has already been filtered out and no longer exists in the GRanges.
gr <- gr[hasPartner(gr)]
}
