% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer64.R
\name{format.integer64}
\alias{format.integer64}
\alias{sign.integer64}
\alias{abs.integer64}
\alias{sqrt.integer64}
\alias{log.integer64}
\alias{log10.integer64}
\alias{log2.integer64}
\alias{trunc.integer64}
\alias{floor.integer64}
\alias{ceiling.integer64}
\alias{signif.integer64}
\alias{scale.integer64}
\alias{round.integer64}
\alias{is.na.integer64}
\alias{is.finite.integer64}
\alias{is.infinite.integer64}
\alias{is.nan.integer64}
\alias{!.integer64}
\title{Unary operators and functions for integer64 vectors}
\usage{
\method{format}{integer64}(x, justify = "right", ...)

\method{sign}{integer64}(x)

\method{abs}{integer64}(x)

\method{sqrt}{integer64}(x)

\method{log}{integer64}(x, base = NULL)

\method{log10}{integer64}(x)

\method{log2}{integer64}(x)

\method{trunc}{integer64}(x, ...)

\method{floor}{integer64}(x)

\method{ceiling}{integer64}(x)

\method{signif}{integer64}(x, digits = 6L)

\method{scale}{integer64}(x, center = TRUE, scale = TRUE)

\method{round}{integer64}(x, digits = 0L)

\method{is.na}{integer64}(x)

\method{is.finite}{integer64}(x)

\method{is.infinite}{integer64}(x)

\method{is.nan}{integer64}(x)

\method{!}{integer64}(x)
}
\arguments{
\item{x}{an atomic vector of class 'integer64'}

\item{justify}{should it be right-justified (the default), left-justified,
centred or left alone.}

\item{...}{further arguments to the \code{\link[=NextMethod]{NextMethod()}}}

\item{base}{an atomic scalar (we save 50\% log-calls by not allowing
a vector base)}

\item{digits}{integer indicating the number of decimal places (round)
or significant digits (signif) to be used. Negative values are allowed
(see \code{\link[=round]{round()}})}

\item{center}{see \code{\link[=scale]{scale()}}}

\item{scale}{see \code{\link[=scale]{scale()}}}
}
\value{
\code{\link[=format]{format()}} returns a character vector

\code{\link[=is.na]{is.na()}} and \code{\link{!}} return a logical vector

\code{\link[=sqrt]{sqrt()}}, \code{\link[=log]{log()}}, \code{\link[=log2]{log2()}} and \code{\link[=log10]{log10()}} return a double vector

\code{\link[=sign]{sign()}}, \code{\link[=abs]{abs()}}, \code{\link[=floor]{floor()}}, \code{\link[=ceiling]{ceiling()}}, \code{\link[=trunc]{trunc()}} and
\code{\link[=round]{round()}} return a vector of class 'integer64'

\code{\link[=signif]{signif()}} is not implemented
}
\description{
Unary operators and functions for integer64 vectors.
}
\examples{
  sqrt(as.integer64(1:12))
}
\seealso{
\code{\link[=xor.integer64]{xor.integer64()}} \code{\link[=integer64]{integer64()}}
}
\keyword{classes}
\keyword{manip}
