% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediation_tidiers.R
\name{mediation_tidiers}
\alias{mediation_tidiers}
\alias{tidy.mediate.mer}
\title{Tidying methods for mediation analyses involving mixed effects models}
\usage{
\method{tidy}{mediate.mer}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{an object of class \code{mediate.mer}, as from \code{mediate} using
\code{lmer}, \code{glmer}, or \code{nlmer} models}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level for CI}

\item{\dots}{additional arguments (unused: for generic consistency)}
}
\value{
All tidying methods return a \code{data.frame} without rownames. The
  structure depends on the method chosen.

\code{tidy} returns one row for each estimated effect:
first the mediated effect in the control and treatment groups, respectively,
then the direct effect in each group.
It contains the columns
  \item{term}{term being estimated}
  \item{estimate}{estimated coefficient}
  \item{std.error}{standard error}
  \item{p.value}{P-value computed from t-statistic (may be missing/NA)}
}
\description{
These methods tidy the coefficients of \code{mediation::mediate} output
(i.e., \code{mediate.mer} objects) when \code{lme4::lmer} and
\code{lme4::glmer} models (i.e., \code{merMod} objects) provide the input.
}
\examples{
if (require("lme4") && require("mediation")) {
    ## Borrowed from \code{help(mediation::mediate)}:
    \dontrun{
        ## Varying intercept for mediator 
        mod_m <- glmer(job_dich ~ treat + econ_hard + (1 | educ), 
                       family = binomial(link = "probit"), data = jobs)
        ## Varying intercept and slope for outcome
        mod_y <- glmer(work1 ~ treat + job_dich + econ_hard + (1 + treat | occp),
                       family = binomial(link = "probit"), data = jobs)
        ## Output based on mediator group ("educ")
        mod_med <- mediate(mod_m, mod_y, treat = "treat", 
                           mediator = "job_dich", sims=50, group.out="educ")
    }
    ## Load stored objects
    load(system.file("extdata", "mediation_example.rda", package="broom.mixed"))
    ## Tidy outputs
    tidy(mod_m)
    tidy(mod_y)
    tidy(mod_med)
}
}
\seealso{
\code{\link[mediation]{mediate}}, \code{\link[broom]{tidy.mediate}}
}
