% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-arrow-fetch-arrow-chunk.R
\docType{data}
\name{spec_arrow_fetch_arrow_chunk}
\alias{spec_arrow_fetch_arrow_chunk}
\title{spec_arrow_fetch_arrow_chunk}
\value{
\code{dbFetchArrowChunk()} always returns an object coercible to a \link{data.frame} with
as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
}
\description{
spec_arrow_fetch_arrow_chunk
}
\section{Failure modes}{

An attempt to fetch from a closed result set raises an error.
}

\section{Specification}{

Fetching multi-row queries with one
or more columns returns the next chunk.
The size of the chunk is implementation-specific.
The object returned by \code{dbFetchArrowChunk()} can also be passed to
\code{\link[nanoarrow:as_nanoarrow_array]{nanoarrow::as_nanoarrow_array()}} to create a nanoarrow array object.
The chunk size is implementation-specific.
}

\seealso{
Other Arrow specifications: 
\code{\link{spec_arrow_append_table_arrow}},
\code{\link{spec_arrow_create_table_arrow}},
\code{\link{spec_arrow_fetch_arrow}},
\code{\link{spec_arrow_get_query_arrow}},
\code{\link{spec_arrow_read_table_arrow}},
\code{\link{spec_arrow_send_query_arrow}},
\code{\link{spec_arrow_write_table_arrow}},
\code{\link{spec_result_clear_result}}
}
\concept{Arrow specifications}
