% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnmf.R
\docType{class}
\name{NNMF-class}
\alias{NNMF-class}
\alias{NNMF}
\title{Non-Negative Matrix Factorization}
\description{
S4 Class implementing NNMF.
}
\details{
NNMF is a method for decomposing a matrix into a smaller
 dimension such that the constraint that the data (and the
 projection) are not negative is taken into account.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{

The method can take the following parameters:
\describe{
  \item{ndim}{The number of output dimensions.}
  \item{method}{character, which algorithm should be used. See
   \code{\link[NMF]{nmf}} for possible values. Defaults to
   "brunet"}
  \item{nrun}{integer, the number of times the computations are
   conducted. See \code{\link[NMF]{nmf}}}
  \item{seed}{integer, a value to control the random numbers used.}
  \item{options}{named list, other options to pass to  \code{\link[NMF]{nmf}}}
}
}

\section{Implementation}{


Wraps around \code{\link[NMF]{nmf}}. Note that the estimation uses random
 numbers. To create reproducible results, set the random number seed in the
 function call. Also, in many cases, the computations will be conducted
 in parallel using multiple cores. To disable this, use the option
 \code{.pbackend = NULL}.
}

\examples{
if(requireNamespace(c("NNMF", "MASS"), quietly = TRUE)) {

set.seed(4646)
dat <- loadDataSet("Iris")
emb <- embed(dat, "NNMF")

plot(emb)

# project new values:
nn_proj <- predict(emb, dat[1:7])
plot(nn_proj)

}
}
\references{
Lee, D.D., Seung, H.S., 1999. Learning the parts of objects by non-negative
matrix factorization. Nature 401, 788-791. https://doi.org/10.1038/44565
}
\seealso{
Other dimensionality reduction methods: 
\code{\link{AutoEncoder-class}},
\code{\link{DRR-class}},
\code{\link{DiffusionMaps-class}},
\code{\link{DrL-class}},
\code{\link{FastICA-class}},
\code{\link{FruchtermanReingold-class}},
\code{\link{HLLE-class}},
\code{\link{Isomap-class}},
\code{\link{KamadaKawai-class}},
\code{\link{MDS-class}},
\code{\link{PCA-class}},
\code{\link{PCA_L1-class}},
\code{\link{UMAP-class}},
\code{\link{dimRedMethod-class}},
\code{\link{dimRedMethodList}()},
\code{\link{kPCA-class}},
\code{\link{nMDS-class}},
\code{\link{tSNE-class}}
}
\concept{dimensionality reduction methods}
