% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOVenn.R
\name{GOVenn}
\alias{GOVenn}
\title{Venn diagram of differentially expressed genes.}
\usage{
GOVenn(data1, data2, data3, title, label, lfc.col, circle.col, plot = T)
}
\arguments{
\item{data1}{A data frame consisting of two columns: ID, logFC}

\item{data2}{A data frame consisting of two columns: ID, logFC}

\item{data3}{A data frame consisting of two columns: ID, logFC}

\item{title}{The title of the plot}

\item{label}{A character vector to define the legend keys}

\item{lfc.col}{A character vector determining the background colors of the 
pie segments representing up- and down- regulated genes}

\item{circle.col}{A character vector to assign clockwise colors for the 
circles}

\item{plot}{If TRUE only the venn diagram is plotted. Otherwise the function 
returns a list with two items: the actual plot and a list containing the 
overlap entries (default= TRUE)}
}
\description{
The function compares lists of differentially expressed genes 
  and illustrates possible relations.Additionally it represents the variety 
  of gene expression patterns within the intersection in small pie charts 
  with three segements. Clockwise are shown the number of commonly up- 
  regulated, commonly down- regulated and contra- regulated genes.
}
\details{
The \code{plot} argument can be used to adjust the amount of 
  information that is returned by calling the function. If you are only 
  interested in the actual plot of the venn diagram, \code{plot} should be 
  set to TRUE. Sometimes you also want to know the elements of the 
  intersections. In this case \code{plot} should be set to FALSE and the 
  function call will return a list of two items. The first item, that can be 
  accessed by $plot, contains the plotting information. Additionally, a list
  ($table) will be returned containing the elements of the various overlaps.
}
\examples{
\dontrun{
#Load the included dataset
data(EC)

#Generating the circ object
circ<-circular_dat(EC$david, EC$genelist)

#Selecting terms of interest
l1<-subset(circ,term=='heart development',c(genes,logFC))
l2<-subset(circ,term=='plasma membrane',c(genes,logFC))
l3<-subset(circ,term=='tissue morphogenesis',c(genes,logFC))

GOVenn(l1,l2,l3, label=c('heart development','plasma membrane','tissue morphogenesis'))
}
}

