\name{package.skeleton-methods}
\docType{methods}
\alias{package.skeleton-methods}
\alias{package.skeleton,ANY,ANY-method}
\alias{package.skeleton,character,CFunc-method}
\alias{package.skeleton,character,CFuncList-method}
\title{Generate the skeleton of a package}
\description{
Generate the skeleton of a package
}
\section{Methods}{
\describe{

\item{\code{signature(name = "ANY", list = "ANY")}}{
	Standard method. See \code{\link[utils]{package.skeleton}}
}

\item{\code{signature(name = "character", list = "CFunc")}}{
	Method for a single generated by \code{\link{cfunction}}
	or \code{\link{cxxfunction}}
}

\item{\code{signature(name = "character", list = "CFuncList")}}{
	Method for a set functions generated by \code{\link{cfunction}}
	or \code{\link{cxxfunction}}
}
}}
\examples{
\dontrun{

fx <- cxxfunction(signature(x = "integer", y = "numeric"),
	          "return ScalarReal( INTEGER(x)[0] * REAL(y)[0]);")
package.skeleton("foo", fx)

functions <- cxxfunction(list(ff = signature(), 
                              gg = signature(x = "integer", y = "numeric")), 
                         c("return R_NilValue ;",
                           "return ScalarReal(INTEGER(x)[0] * REAL(y)[0]);"))
package.skeleton("foobar", functions)

}
}
\keyword{methods}

