% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readConfiguration.R
\name{readConfigurationsFile}
\alias{readConfigurationsFile}
\title{readConfigurationsFile}
\usage{
readConfigurationsFile(filename, parameters, debugLevel = 0, text)
}
\arguments{
\item{filename}{(\code{character(1)}) \cr Filename from which the configurations should be read.}

\item{parameters}{(\code{list()}) \cr Data structure containing the parameter
space definition. The data structure has to similar to the one returned by the
function \code{\link{readParameters}}.}

\item{debugLevel}{(\code{integer(1)}) \cr Larger values produce more verbose output.}

\item{text}{(\code{character(1)}) \cr If \code{file} is not supplied and this is,
then parameters are read from the value of \code{text} via a text connection.}
}
\value{
A data frame containing the obtained configurations.
Each row of the data frame is a candidate configuration,
the columns correspond to the parameter names in \code{parameters}.
}
\description{
\code{readConfigurationsFile} reads a set of target algorithms configurations
from a file and puts them in \pkg{irace} format. The configurations are checked
to match the parameters description provided.
}
\seealso{
\code{\link{readParameters}} to obtain a valid parameter structure from a parameters list.
}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
