% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/props.R
\name{get.property}
\alias{get.property}
\title{Get a property value of the molecule.}
\usage{
get.property(molecule, key)
}
\arguments{
\item{molecule}{The molecule to query. Should be a `jobjRef` representing an `IAtomContainer`}

\item{key}{The property key as a character string}
}
\value{
The value of the property. If there is no property with the specified key, `NA` is returned
}
\description{
This function retrieves the value of a keyed property that has
previously been set on the molecule. Properties enable us to 
associate arbitrary pieces of data with a molecule. Such data
can be text, numeric or a Java object (represented as a `jobjRef`).
}
\examples{
mol <- parse.smiles("CC1CC(C=O)CCC1")[[1]]
set.property(mol, 'prop1', 23.45)
set.property(mol, 'prop2', 'inactive')
get.property(mol, 'prop1')
}
\seealso{
\code{\link{set.property}}, \code{\link{get.properties}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
