% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer.R
\name{step_integer}
\alias{step_integer}
\title{Convert values to predefined integers}
\usage{
step_integer(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  strict = TRUE,
  zero_based = FALSE,
  key = NULL,
  skip = FALSE,
  id = rand_id("integer")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{strict}{A logical for whether the values should be returned as
integers (as opposed to double).}

\item{zero_based}{A logical for whether the integers should start at zero and
new values be appended as the largest integer.}

\item{key}{A list that contains the information needed to
create integer variables for each variable contained in
\code{terms}. This is \code{NULL} until the step is trained by
\code{\link[=prep]{prep()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_integer()} creates a \emph{specification} of a recipe step that will convert
new data into a set of integers based on the original data values.
}
\details{
\code{step_integer} will determine the unique values of
each variable from the training set (excluding missing values),
order them, and then assign integers to each value. When baked,
each data point is translated to its corresponding integer or a
value of zero for yet unseen data (although see the \code{zero_based}
argument above). Missing values propagate.

Factor inputs are ordered by their levels. All others are
ordered by \code{sort}.

Despite the name, the new values are returned as numeric unless
\code{strict = TRUE}, which will coerce the results to integers.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{value} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{value}{list, a \emph{list column} with the conversion key}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sacramento, package = "modeldata")

sacr_tr <- Sacramento[1:100, ]
sacr_tr$sqft[1] <- NA

sacr_te <- Sacramento[101:105, ]
sacr_te$sqft[1] <- NA
sacr_te$city[1] <- "whoville"
sacr_te$city[2] <- NA

rec <- recipe(type ~ ., data = sacr_tr) \%>\%
  step_integer(all_predictors()) \%>\%
  prep(training = sacr_tr)

bake(rec, sacr_te, all_predictors())
tidy(rec, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_time}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
