% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsplit.R
\name{as.data.frame.rsplit}
\alias{as.data.frame.rsplit}
\alias{analysis}
\alias{analysis.default}
\alias{analysis.rsplit}
\alias{assessment}
\alias{assessment.default}
\alias{assessment.rsplit}
\title{Convert an \code{rsplit} object to a data frame}
\usage{
\method{as.data.frame}{rsplit}(x, row.names = NULL, optional = FALSE, data = "analysis", ...)

analysis(x, ...)

\method{analysis}{default}(x, ...)

\method{analysis}{rsplit}(x, ...)

assessment(x, ...)

\method{assessment}{default}(x, ...)

\method{assessment}{rsplit}(x, ...)
}
\arguments{
\item{x}{An \code{rsplit} object.}

\item{row.names}{\code{NULL} or a character vector giving the row names for the data frame. Missing values are not allowed.}

\item{optional}{A logical: should the column names of the data be checked for legality?}

\item{data}{Either "analysis" or "assessment" to specify which data are returned.}

\item{...}{Not currently used.}
}
\description{
The analysis or assessment code can be returned as a data
frame (as dictated by the \code{data} argument) using
\code{as.data.frame.rsplit}. \code{analysis} and
\code{assessment} are shortcuts.
}
\examples{
library(dplyr)
set.seed(104)
folds <- vfold_cv(mtcars)

model_data_1 <- folds$splits[[1]] \%>\% analysis()
holdout_data_1 <- folds$splits[[1]] \%>\% assessment()
}
