% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.utilities.R
\name{empty_env}
\alias{empty_env}
\alias{base_env}
\title{Replace an object's environment with a simple, static environment.}
\usage{
empty_env(object)

base_env(object)
}
\arguments{
\item{object}{An object with the \verb{environment()<-} method.}
}
\value{
An object of the same type as \code{object}, with updated environment.
}
\description{
Replace an object's environment with a simple, static environment.
}
\examples{
f <- y~x
environment(f) # GlobalEnv

environment(empty_env(f)) # EmptyEnv

\dontshow{
stopifnot(identical(environment(empty_env(f)), emptyenv()))
}

environment(base_env(f)) # base package environment

\dontshow{
stopifnot(identical(environment(base_env(f)), baseenv()))
}
}
