% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comm2sci.R
\name{comm2sci}
\alias{comm2sci}
\alias{comm2sci.default}
\alias{comm2sci.tsn}
\alias{comm2sci.uid}
\title{Get scientific names from common names.}
\usage{
comm2sci(...)

\method{comm2sci}{default}(
  com,
  db = "ncbi",
  itisby = "search",
  simplify = TRUE,
  commnames = NULL,
  ...
)

\method{comm2sci}{tsn}(id, db = "ncbi", itisby = "search", simplify = TRUE, ...)

\method{comm2sci}{uid}(id, db = "ncbi", itisby = "search", simplify = TRUE, ...)
}
\arguments{
\item{...}{Further arguments passed on to internal methods.}

\item{com}{One or more common names or partial names.}

\item{db}{Data source, one of \emph{"ncbi"} (default), \emph{"itis"},
\emph{"tropicos"}, \emph{"eol"}, or \emph{"worms"}. If using ncbi, we
recommend getting an API key; see \link{taxize-authentication}}

\item{itisby}{Search for common names across entire names (search, default),
at beginning of names (begin), or at end of names (end).}

\item{simplify}{(logical) If \code{TRUE}, simplify output to a vector of names.
If \code{FALSE}, return variable formats from different sources, usually a
data.frame.}

\item{commnames}{Deprecated, see \code{com}}

\item{id}{taxon identifiers, as returned by \code{\link[=get_tsn]{get_tsn()}} or \code{\link[=get_uid]{get_uid()}}}
}
\value{
If \code{simplify=TRUE}, a list of scientific names, with list
labeled by your input names. If \code{simplify=FALSE}, a data.frame with
columns that vary by data source. \code{character(0)} on no match
}
\description{
Get scientific names from common names.
}
\details{
For data sources ITIS and NCBI you can pass in common names
directly, and use \code{\link[=get_uid]{get_uid()}} or \code{\link[=get_tsn]{get_tsn()}} to get ids first, then pass in
to this fxn.

For the other data sources, you can only pass in common names directly.
}
\section{Authentication}{

See \link{taxize-authentication} for help on authentication
}

\section{HTTP version for NCBI requests}{

We hard code \code{http_version = 2L} to use HTTP/1.1 in HTTP requests to
the Entrez API. See \code{curl::curl_symbols('CURL_HTTP_VERSION')}
}

\examples{
\dontrun{
comm2sci(com='american black bear')
comm2sci(com='american black bear', simplify = FALSE)
comm2sci(com='black bear', db='itis')
comm2sci(com='american black bear', db='itis')
comm2sci(com='annual blue grass', db='tropicos')
comm2sci(com=c('annual blue grass','tree of heaven'), db='tropicos')
comm2sci('blue whale', db = "worms")
comm2sci(c('blue whale', 'dwarf surfclam'), db = "worms")

# ncbi: pass in uid's from get_uid() directly
x <- get_uid("western capercaillie", modifier = "Common Name")
comm2sci(x)
# itis: pass in tsn's from get_tsn() directly
x <- get_tsn(c("Louisiana black bear", "american crow"),
  searchtype = "common")
comm2sci(x)
}
}
\seealso{
\code{\link[=sci2comm]{sci2comm()}}
}
\author{
Scott Chamberlain
}
