% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lst.R
\name{lst}
\alias{lst}
\title{Build a list}
\usage{
lst(...)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>
A set of name-value pairs. These arguments are
processed with \code{\link[rlang:nse-defuse]{rlang::quos()}} and support unquote via \code{\link{!!}} and
unquote-splice via \code{\link{!!!}}. Use \verb{:=} to create columns that start with a dot.

Arguments are evaluated sequentially.
You can refer to previously created elements directly or using the \link{.data}
pronoun.
An existing \code{.data} pronoun, provided e.g. inside \code{\link[dplyr:mutate]{dplyr::mutate()}},
is not available.}
}
\value{
A named list.
}
\description{
\ifelse{html}{\out{<a href='https://lifecycle.r-lib.org/articles/stages.html'><img src='figures/lifecycle-questioning.svg' alt='Questioning lifecycle'></a>}}{\strong{Questioning}}

\code{lst()} constructs a list, similar to \code{\link[base:list]{base::list()}}, but with some of the
same features as \code{\link[=tibble]{tibble()}}. \code{lst()} builds components sequentially. When
defining a component, you can refer to components created earlier in the
call. \code{lst()} also generates missing names automatically.
}
\section{Life cycle}{

The \code{lst()} function is in the questioning stage.
It is essentially
\code{\link[rlang:list2]{rlang::list2()}}, but with a couple features copied from \code{\link[=tibble]{tibble()}}. It's not
clear that a function for creating lists belongs in the tibble package.
Consider using \code{\link[rlang:list2]{rlang::list2()}} instead.
}

\examples{
# the value of n can be used immediately in the definition of x
lst(n = 5, x = runif(n))

# missing names are constructed from user's input
lst(1:3, z = letters[4:6], runif(3))

a <- 1:3
b <- letters[4:6]
lst(a, b)

# pre-formed quoted expressions can be used with lst() and then
# unquoted (with !!) or unquoted and spliced (with !!!)
n1 <- 2
n2 <- 3
n_stuff <- quote(n1 + n2)
x_stuff <- quote(seq_len(n))
lst(!!!list(n = n_stuff, x = x_stuff))
lst(n = !!n_stuff, x = !!x_stuff)
lst(n = 4, x = !!x_stuff)
lst(!!!list(n = 2, x = x_stuff))
}
