% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{env_option}
\alias{env_option}
\title{Retrieve a global option from both \code{options()} and environment variables}
\usage{
env_option(name, default = NULL)
}
\arguments{
\item{name}{The option name.}

\item{default}{The default value if the option is not found in \code{\link[=options]{options()}} or
environment variables.}
}
\value{
The option value.
}
\description{
If the option exists in \code{\link[=options]{options()}}, use its value. If not, query the
environment variable with the name \code{R_NAME} where \code{NAME} is the capitalized
option name with dots substituted by underscores. For example, for an option
\code{xfun.foo}, first we try \code{getOption('xfun.foo')}; if it does not exist, we
check the environment variable \code{R_XFUN_FOO}.
}
\details{
This provides two possible ways, whichever is more convenient, for users to
set an option. For example, global options can be set in the \link{.Rprofile}
file, and environment variables can be set in the \link{.Renviron} file.
}
\examples{
xfun::env_option("xfun.test.option")  # NULL

Sys.setenv(R_XFUN_TEST_OPTION = "1234")
xfun::env_option("xfun.test.option")  # 1234

options(xfun.test.option = TRUE)
xfun::env_option("xfun.test.option")  # TRUE (from options())
options(xfun.test.option = NULL)  # reset the option
xfun::env_option("xfun.test.option")  # 1234 (from env var)

Sys.unsetenv("R_XFUN_TEST_OPTION")
xfun::env_option("xfun.test.option")  # NULL again

xfun::env_option("xfun.test.option", FALSE)  # use default
}
