# Announce: Rakudo compiler, Release #138 (2020.08)

On behalf of the Rakudo development team, I’m very happy to announce the
August 2020 release of Rakudo #138. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.08:
  + Changes:
    + Methods `name` and `usage-name` of `Parameter` now return an empty `Str`,
      when there is no name, instead of `Nil`. Method `default` returns `Code` type object,
      when no default was provided instead of `Any` type object [c11f4b18]
    + Remove redundant `(())` from `Map.new.raku` [491e1def]
    + Routine `done-testing` of `Test` module returns `Bool` now,
      indicating if the tests passed or not [337848fe]
  + Deprecations:
    + Deprecate `--nqp-lib` command line option,
      which had no effect for more than a year [9071653e]
  + Fixes:
    + Make `X::Method::NotFound` exception more user-friendly
      [b36afcb3][760034ef][eb0ca2a3][66adb771][acc5e64d][4546a603]
    + Fix false positive typechecking exceptions for some generic types
      [3d5fba7b][973b83de][8d40691d][1db17c46][1eb712d5]
    + Ensure `Routine` subtypes are composed before performing mixins with
      their instances [7f2ae26c][e3c2646e]
    + Fix mixing in a role with attributes into a NQP class [1b5f6b98][9e51d01b]
    + Make exceptions thrown by supply iterators don't claim to have
      originally been thrown within the iterator itself [fcfc60b6]
    + Fix `Baggy.pickpairs` called with a `Callable` [08f81f24]
    + Fix a rare, yet possible data race [9d6d8dd7]
  + Additions:
    + Add `set_parameterizer`, `parameterize_type`, `type_parameterized`,
      `type_parameters` and `type_parameter_at` methods for `Metamodel::Primitives` [2ab94429]
  + Internal:
    + Type `Parameter` methods [c11f4b18]
    + Fix release pipeline to not delete the GNU/Linux build [4ad4bd30]
    + Make `Rakudo::Internals::JSON` up to 4.4x as fast [b60e1636][43bd739f]
    + Do roast-related cleanup, add `quicktest` make target
      [1e20dfca][6fd09811][333ce78c][dd8cd411]
    + Rework `tools/update-passing-test-data.pl` to support backends [ea0c98cf]
    + Make `main-version.nqp` a backend-specific configuration file [80b0747a]
    + Add a `Perl6::SysConfig` class [ace5e22f]
    + Simplify binary release instructions a little [27eb5ea9]
    + Add tests to make sure profilers can be invoked [d7aa7e66]
    + Remove an outdated workaround from `Cool` implementation [a3af5833]
    + Fix incorrect method call [02a83442]


The following people contributed to this release:

Vadim Belman, Juan Julián Merelo Guervós, Will "Coke" Coleda, Patrick Böker,
Elizabeth Mattijsen, Alexander Kiryuhin, stoned, Daniel Lathrop, Timo Paulssen,
Stoned Elipot, Christian Bartolomäus, Tom Browder, rir, Ben Davies,
Daniel Green, Jonathan Worthington, Paul Cochrane, Stefan Seifert,
Daniel Sockwell, Nicholas Clark, Antonio, Tobias Boege

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#139), is tentatively scheduled for 2020-09-19.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
