# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from testrpc.idl.

use strict;

package Raritan::RPC::test::Ethernet;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "test.Ethernet:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::test::Ethernet::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

sub getDevices($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDevices', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}


sub setParameters($$$$$) {
    my ($self, $device, $speed, $duplex, $isAutoNeg) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'device'} = "$device";
    $args->{'speed'} = 1 * $speed;
    $args->{'duplex'} = 1 * $duplex;
    $args->{'isAutoNeg'} = ($isAutoNeg) ? JSON::true : JSON::false;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setParameters', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('test.Ethernet', 1, 0, 0, 'Raritan::RPC::test::Ethernet');
1;
