#! /bin/sh

# Test representation of a table with URLs

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

TMP_DB_FILE=${TMP_DB_DIR}/data.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_FILE_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/$(basename ${TMP_DB_FILE})

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_FILE} <<END
    create table data (
        id integer primary key autoincrement,
        name varchar(24) DEFAULT NULL,
        PubID varchar(20) unique NOT NULL,
        cdate date,
        ctime time
);
END
sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} <<END
    insert into description (id, dbname, dbtable, dbcolumn, coltype) values
        (1, "${TMP_DB_FILE_ABS}", "data", "PubID", "extkey"),
        (2, "${TMP_DB_FILE_ABS}", "data", "cdate", "cdate"),
        (3, "${TMP_DB_FILE_ABS}", "data", "ctime", "ctime")
;

    insert into numbers (\`column_id\`, \`range\`, \`user\`) values
        (1,"SG-TEST-0001","tester")
;
END

export REQUEST_URI='/~saulius/restful/website/data.db/data'
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

echo "==="

perl -lne 'print "$_\r"' <<EOF |
--------------------------b989696a28305e74
Content-Disposition: form-data; name="csvfile"; filename="fill.csv"
Content-Type: text/plain

id,name,PubID
1,test,test
--------------------------b989696a28305e74--
EOF
${INPUT_SCRIPT}

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from data'

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
