##
# **_Defined in the toys-core gem_**
#
# This module is the root namespace for tool definitions loaded from files.
# Whenever a toys configuration file is parsed, a module is created under this
# parent for that file's contents. Tool classes defined in that file, along
# with mixins and templates, and any other classes, modules, and constants
# defined, are located within that file's module.
#
module Toys::InputFile # rubocop:disable Style/ClassAndModuleChildren
  ##
  # @private This interface is internal and subject to change without warning.
  #
  def self.evaluate(tool_class, words, priority, remaining_words, source, loader)
    # Source available in the toys-core gem
  end
end
