# 2021-03-23 Triage Log

An overall busy but decent week for performance. While there were some performance regressions they were mostly small, and they were outnumbered by performance gains. Perhaps the most interesting news is not a compiler performance improvement but rather the introduction of no-alias optimizations at the LLVM level. This slightly hurts optimized build time performance in some cases, but it should make some workloads run faster after compilation.

Triage done by **@rylev**.
Revision range: [f24ce9b0140d9be5a336954e878d0c1522966bb8..9b6339e4b9747d473270baa42e77e1d2fff39bf4](https://perf.rust-lang.org/?start=f24ce9b0140d9be5a336954e878d0c1522966bb8&end=9b6339e4b9747d473270baa42e77e1d2fff39bf4&absolute=false&stat=instructions%3Au)

2 Regressions, 5 Improvements, 3 Mixed
1 of them in rollups

#### Regressions

Implement (but don't use) valtree and refactor in preparation of use [#82936](https://github.com/rust-lang/rust/issues/82936)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f5d8117c338a788bd24abec733fd143dfceb25a0&end=e655fb62216b6ba64a094b30f116d7988d19322d&stat=instructions:u) (up to 2.1% on `full` builds of `ctfe-stress-4-opt`)
- Purely an addition of unused code (for a future feature). It is possible that this changed some inlining behavior, but the benchmark in question is susceptible to high variance though it seemed to impact full builds and not incremental builds.
- The query impacted is `eval_to_allocation_raw` which is what ctfe stresses, so we'll [look into it](https://github.com/rust-lang/rust/pull/82936#issuecomment-805029518).

Use TrustedRandomAccess for in-place iterators where possible [#79846](https://github.com/rust-lang/rust/issues/79846)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=97663b6690689379aa0493deb494dfe14627c46b&end=35385770ae1ea86a911cc44ac43f856831e44b26&stat=instructions:u) (up to 1.5% on `full` builds of `deep-vector-debug`)
- This is a change in the standard library that seems to only impact one benchmark: `deep-vector-debug` full compilation. It looks to be impacting `typeck`, but I'm not sure why this would be. It's also possible that it's noise.
- There's also a possibility that this has some strange interaction with the performance gained in [#83360](https://github.com/rust-lang/rust/issues/83360).

#### Improvements

Add a check for ASCII characters in to_upper and to_lower [#81358](https://github.com/rust-lang/rust/issues/81358)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2c7490379d7e8854192c176039cfabf6acefe7ef&end=0ce0fedb67fa66d50aa819ef8b12f1d89eb22d7d&stat=instructions:u) (up to -2.7% on `incr-unchanged` builds of `match-stress-enum-check`)

ast/hir: Rename field-related structures [#83188](https://github.com/rust-lang/rust/issues/83188)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=04ae50179a802d1d18bb780baa85f55864f56616&end=b4adc21c4fa245994b4936df5b4f7d94ca633c5d&stat=instructions:u) (up to -1.7% on `incr-unchanged` builds of `deep-vector-check`)

Revert performance-sensitive change in #82436 [#83293](https://github.com/rust-lang/rust/issues/83293)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6bfbf0c33a86707cedd02ca985285191282a80b3&end=cd82e451a88ac8b15894af498cdc49e1fe8caa21&stat=instructions:u) (up to -10.6% on `incr-full` builds of `packed-simd-check`)

Rollup of 9 pull requests [#83360](https://github.com/rust-lang/rust/issues/83360)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=35385770ae1ea86a911cc44ac43f856831e44b26&end=142c831861ba5a995fd9de99198e7f6074b6b400&stat=instructions:u) (up to -1.5% on `full` builds of `deep-vector-debug`)

Simplify encoder and decoder [#83273](https://github.com/rust-lang/rust/issues/83273)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7f82ddb8750aef7c48173b84ec5a3d713edce263&end=d04c3aa8656f6588c87bafafb34d51239dab98bb&stat=instructions:u) (up to -1.5% on `incr-unchanged` builds of `tokio-webpush-simple-check`)


#### Mixed

feat: Update hashbrown to instantiate less llvm IR [#77566](https://github.com/rust-lang/rust/issues/77566)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=895a8e71b1a9fc42631f81b071bc855f7fb3e9a4&end=0464f638af99a7c0876e9b8f96db5bbf917e3fe2&stat=instructions:u) (up to -5.1% on `full` builds of `cargo-debug`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=895a8e71b1a9fc42631f81b071bc855f7fb3e9a4&end=0464f638af99a7c0876e9b8f96db5bbf917e3fe2&stat=instructions:u) (up to 2.6% on `incr-full` builds of `ctfe-stress-4-debug`)
- Just an update of hashbrown, so we have less visibility into what the changes actually are (without digging deeper into hashbrown itself).The reason the update is important is because hashbrown's newer versions emit less LLVM IR.
- This is largely a performance gain, but there is one regression in `ctfe` that remained. The reviewers determined that merging was more important that investigating that issue, but it will [be looked into](https://github.com/rust-lang/rust/pull/77566#issuecomment-805033514).

Replace closures_captures and upvar_capture with closure_min_captures [#82951](https://github.com/rust-lang/rust/issues/82951)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=9f4bc3ead43a57783d8abea2fa6931a6736f3490&end=cebc8fef5f4391a9ed8e4c1dc566a6c5824e2901&stat=instructions:u) (up to -3.4% on `incr-unchanged` builds of `clap-rs-check`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9f4bc3ead43a57783d8abea2fa6931a6736f3490&end=cebc8fef5f4391a9ed8e4c1dc566a6c5824e2901&stat=instructions:u) (up to 1.2% on `incr-unchanged` builds of `tuple-stress-check`)
- Perf run was done during review, but it seems that the small regressions seen then (all under 1%) have gotten slightly worse and pushed some of them over our arbitrary threshold of 1%.
- Regression is coming in incremental builds in the `encode_query_results_for` query which explains why this is impacting incremental builds. While this is minor, we [will look into it](https://github.com/rust-lang/rust/pull/82951#issuecomment-805038336).

Enable mutable noalias for LLVM >= 12 [#82834](https://github.com/rust-lang/rust/issues/82834)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f82664191d0e8764b7435b9d72eb0e366b8b1464&end=97663b6690689379aa0493deb494dfe14627c46b&stat=instructions:u) (up to -9.0% on `incr-patched: Job` builds of `regex-debug`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f82664191d0e8764b7435b9d72eb0e366b8b1464&end=97663b6690689379aa0493deb494dfe14627c46b&stat=instructions:u) (up to 3.8% on `incr-unchanged` builds of `syn-opt`)
- The negative performance impacts are almost exclusively in the optimized build benchmarks. This was deemed to be acceptable since this is largely a change which impacts optimizations. This will hopefully be taken care of in LLVM itself, and some of that compile performance will be won back.
- More discussion of this can be found [here](https://github.com/rust-lang/rust/pull/82834#issuecomment-803381467).

#### Nags requiring follow up

- [Issue](https://github.com/rust-lang/rust/pull/82964#issuecomment-800663588) from last week needs to still be addressed.
- This weeks follow-ups:
    - https://github.com/rust-lang/rust/pull/77566#issuecomment-805033514
    - https://github.com/rust-lang/rust/pull/82951#issuecomment-805038336
    - https://github.com/rust-lang/rust/pull/82936#issuecomment-805029518
