// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_test_autogen.cpp:
//   Tests for matching script-generated hashes with runtime computed hashes.

#include "compiler/translator/ImmutableString.h"
#include "gtest/gtest.h"

namespace sh
{

TEST(ImmutableStringTest, ScriptGeneratedHashesMatch)
{
    ASSERT_EQ(0x00000000u, ImmutableString("radians(00B").mangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("radians(10B").mangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("radians(20B").mangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("radians(30B").mangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("degrees(00B").mangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("degrees(10B").mangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("degrees(20B").mangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("degrees(30B").mangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("sin(00B").mangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("sin(10B").mangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("sin(20B").mangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("sin(30B").mangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("cos(00B").mangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("cos(10B").mangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("cos(20B").mangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("cos(30B").mangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("tan(00B").mangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("tan(10B").mangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("tan(20B").mangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("tan(30B").mangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("asin(00B").mangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("asin(10B").mangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("asin(20B").mangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("asin(30B").mangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("acos(00B").mangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("acos(10B").mangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("acos(20B").mangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("acos(30B").mangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("atan(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("atan(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("atan(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("atan(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("atan(00B").mangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("atan(10B").mangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("atan(20B").mangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("atan(30B").mangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("sinh(00B").mangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("sinh(10B").mangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("sinh(20B").mangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("sinh(30B").mangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("cosh(00B").mangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("cosh(10B").mangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("cosh(20B").mangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("cosh(30B").mangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("tanh(00B").mangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("tanh(10B").mangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("tanh(20B").mangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("tanh(30B").mangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("asinh(00B").mangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("asinh(10B").mangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("asinh(20B").mangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("asinh(30B").mangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("acosh(00B").mangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("acosh(10B").mangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("acosh(20B").mangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("acosh(30B").mangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("atanh(00B").mangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("atanh(10B").mangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("atanh(20B").mangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("atanh(30B").mangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("pow(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("pow(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("pow(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("pow(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("exp(00B").mangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("exp(10B").mangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("exp(20B").mangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("exp(30B").mangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("log(00B").mangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("log(10B").mangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("log(20B").mangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("log(30B").mangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("exp2(00B").mangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("exp2(10B").mangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("exp2(20B").mangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("exp2(30B").mangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("log2(00B").mangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("log2(10B").mangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("log2(20B").mangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("log2(30B").mangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("sqrt(00B").mangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("sqrt(10B").mangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("sqrt(20B").mangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("sqrt(30B").mangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("inversesqrt(00B").mangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("inversesqrt(10B").mangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("inversesqrt(20B").mangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("inversesqrt(30B").mangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("abs(00B").mangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("abs(10B").mangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("abs(20B").mangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("abs(30B").mangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("abs(00C").mangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("abs(10C").mangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("abs(20C").mangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("abs(30C").mangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("sign(00B").mangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("sign(10B").mangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("sign(20B").mangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("sign(30B").mangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("sign(00C").mangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("sign(10C").mangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("sign(20C").mangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("sign(30C").mangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("floor(00B").mangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("floor(10B").mangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("floor(20B").mangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("floor(30B").mangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("trunc(00B").mangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("trunc(10B").mangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("trunc(20B").mangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("trunc(30B").mangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("round(00B").mangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("round(10B").mangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("round(20B").mangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("round(30B").mangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("roundEven(00B").mangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("roundEven(10B").mangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("roundEven(20B").mangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("roundEven(30B").mangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("ceil(00B").mangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("ceil(10B").mangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("ceil(20B").mangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("ceil(30B").mangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("fract(00B").mangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("fract(10B").mangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("fract(20B").mangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("fract(30B").mangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("mod(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("mod(10B00B").mangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("mod(20B00B").mangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("mod(30B00B").mangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("mod(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("mod(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("mod(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("min(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("min(10B00B").mangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("min(20B00B").mangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("min(30B00B").mangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("min(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("min(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("min(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("min(00C00C").mangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("min(10C10C").mangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("min(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("min(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("min(10C00C").mangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("min(20C00C").mangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("min(30C00C").mangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("min(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("min(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("min(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("min(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("min(10D00D").mangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("min(20D00D").mangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("min(30D00D").mangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("max(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("max(10B00B").mangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("max(20B00B").mangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("max(30B00B").mangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("max(10B10B").mangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("max(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("max(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("max(00C00C").mangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("max(10C10C").mangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("max(20C20C").mangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("max(30C30C").mangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("max(10C00C").mangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("max(20C00C").mangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("max(30C00C").mangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("max(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("max(10D10D").mangledNameHash());
    ASSERT_EQ(0x000000acu, ImmutableString("max(20D20D").mangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("max(30D30D").mangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("max(10D00D").mangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("max(20D00D").mangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("max(30D00D").mangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("clamp(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000b2u, ImmutableString("clamp(10B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("clamp(20B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000b4u, ImmutableString("clamp(30B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000b5u, ImmutableString("clamp(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000000b6u, ImmutableString("clamp(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000000b7u, ImmutableString("clamp(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000000b8u, ImmutableString("clamp(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x000000b9u, ImmutableString("clamp(10C00C00C").mangledNameHash());
    ASSERT_EQ(0x000000bau, ImmutableString("clamp(20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000000bbu, ImmutableString("clamp(30C00C00C").mangledNameHash());
    ASSERT_EQ(0x000000bcu, ImmutableString("clamp(10C10C10C").mangledNameHash());
    ASSERT_EQ(0x000000bdu, ImmutableString("clamp(20C20C20C").mangledNameHash());
    ASSERT_EQ(0x000000beu, ImmutableString("clamp(30C30C30C").mangledNameHash());
    ASSERT_EQ(0x000000bfu, ImmutableString("clamp(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000c0u, ImmutableString("clamp(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000c1u, ImmutableString("clamp(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000c2u, ImmutableString("clamp(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000c3u, ImmutableString("clamp(10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000000c4u, ImmutableString("clamp(20D20D20D").mangledNameHash());
    ASSERT_EQ(0x000000c5u, ImmutableString("clamp(30D30D30D").mangledNameHash());
    ASSERT_EQ(0x000000c6u, ImmutableString("mix(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000c7u, ImmutableString("mix(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x000000c8u, ImmutableString("mix(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x000000c9u, ImmutableString("mix(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x000000cau, ImmutableString("mix(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000000cbu, ImmutableString("mix(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000000ccu, ImmutableString("mix(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000000cdu, ImmutableString("mix(00B00B00E").mangledNameHash());
    ASSERT_EQ(0x000000ceu, ImmutableString("mix(10B10B10E").mangledNameHash());
    ASSERT_EQ(0x000000cfu, ImmutableString("mix(20B20B20E").mangledNameHash());
    ASSERT_EQ(0x000000d0u, ImmutableString("mix(30B30B30E").mangledNameHash());
    ASSERT_EQ(0x000000d1u, ImmutableString("mix(00C00C00E").mangledNameHash());
    ASSERT_EQ(0x000000d2u, ImmutableString("mix(10C10C10E").mangledNameHash());
    ASSERT_EQ(0x000000d3u, ImmutableString("mix(20C20C20E").mangledNameHash());
    ASSERT_EQ(0x000000d4u, ImmutableString("mix(30C30C30E").mangledNameHash());
    ASSERT_EQ(0x000000d5u, ImmutableString("mix(00D00D00E").mangledNameHash());
    ASSERT_EQ(0x000000d6u, ImmutableString("mix(10D10D10E").mangledNameHash());
    ASSERT_EQ(0x000000d7u, ImmutableString("mix(20D20D20E").mangledNameHash());
    ASSERT_EQ(0x000000d8u, ImmutableString("mix(30D30D30E").mangledNameHash());
    ASSERT_EQ(0x000000d9u, ImmutableString("mix(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000000dau, ImmutableString("mix(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000000dbu, ImmutableString("mix(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x000000dcu, ImmutableString("mix(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000000ddu, ImmutableString("step(00B00B").mangledNameHash());
    ASSERT_EQ(0x000000deu, ImmutableString("step(10B10B").mangledNameHash());
    ASSERT_EQ(0x000000dfu, ImmutableString("step(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000e0u, ImmutableString("step(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000e1u, ImmutableString("step(00B10B").mangledNameHash());
    ASSERT_EQ(0x000000e2u, ImmutableString("step(00B20B").mangledNameHash());
    ASSERT_EQ(0x000000e3u, ImmutableString("step(00B30B").mangledNameHash());
    ASSERT_EQ(0x000000e4u, ImmutableString("smoothstep(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000e5u, ImmutableString("smoothstep(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000000e6u, ImmutableString("smoothstep(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000000e7u, ImmutableString("smoothstep(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000000e8u, ImmutableString("smoothstep(00B00B10B").mangledNameHash());
    ASSERT_EQ(0x000000e9u, ImmutableString("smoothstep(00B00B20B").mangledNameHash());
    ASSERT_EQ(0x000000eau, ImmutableString("smoothstep(00B00B30B").mangledNameHash());
    ASSERT_EQ(0x000000ebu, ImmutableString("modf(00B00B").mangledNameHash());
    ASSERT_EQ(0x000000ecu, ImmutableString("modf(10B10B").mangledNameHash());
    ASSERT_EQ(0x000000edu, ImmutableString("modf(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000eeu, ImmutableString("modf(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000efu, ImmutableString("isnan(00B").mangledNameHash());
    ASSERT_EQ(0x000000f0u, ImmutableString("isnan(10B").mangledNameHash());
    ASSERT_EQ(0x000000f1u, ImmutableString("isnan(20B").mangledNameHash());
    ASSERT_EQ(0x000000f2u, ImmutableString("isnan(30B").mangledNameHash());
    ASSERT_EQ(0x000000f3u, ImmutableString("isinf(00B").mangledNameHash());
    ASSERT_EQ(0x000000f4u, ImmutableString("isinf(10B").mangledNameHash());
    ASSERT_EQ(0x000000f5u, ImmutableString("isinf(20B").mangledNameHash());
    ASSERT_EQ(0x000000f6u, ImmutableString("isinf(30B").mangledNameHash());
    ASSERT_EQ(0x000000f7u, ImmutableString("floatBitsToInt(00B").mangledNameHash());
    ASSERT_EQ(0x000000f8u, ImmutableString("floatBitsToInt(10B").mangledNameHash());
    ASSERT_EQ(0x000000f9u, ImmutableString("floatBitsToInt(20B").mangledNameHash());
    ASSERT_EQ(0x000000fau, ImmutableString("floatBitsToInt(30B").mangledNameHash());
    ASSERT_EQ(0x000000fbu, ImmutableString("floatBitsToUint(00B").mangledNameHash());
    ASSERT_EQ(0x000000fcu, ImmutableString("floatBitsToUint(10B").mangledNameHash());
    ASSERT_EQ(0x000000fdu, ImmutableString("floatBitsToUint(20B").mangledNameHash());
    ASSERT_EQ(0x000000feu, ImmutableString("floatBitsToUint(30B").mangledNameHash());
    ASSERT_EQ(0x000000ffu, ImmutableString("intBitsToFloat(00C").mangledNameHash());
    ASSERT_EQ(0x00000100u, ImmutableString("intBitsToFloat(10C").mangledNameHash());
    ASSERT_EQ(0x00000101u, ImmutableString("intBitsToFloat(20C").mangledNameHash());
    ASSERT_EQ(0x00000102u, ImmutableString("intBitsToFloat(30C").mangledNameHash());
    ASSERT_EQ(0x00000103u, ImmutableString("uintBitsToFloat(00D").mangledNameHash());
    ASSERT_EQ(0x00000104u, ImmutableString("uintBitsToFloat(10D").mangledNameHash());
    ASSERT_EQ(0x00000105u, ImmutableString("uintBitsToFloat(20D").mangledNameHash());
    ASSERT_EQ(0x00000106u, ImmutableString("uintBitsToFloat(30D").mangledNameHash());
    ASSERT_EQ(0x00000107u, ImmutableString("fma(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000108u, ImmutableString("fma(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000109u, ImmutableString("fma(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000010au, ImmutableString("fma(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x0000010bu, ImmutableString("frexp(00B00C").mangledNameHash());
    ASSERT_EQ(0x0000010cu, ImmutableString("frexp(10B10C").mangledNameHash());
    ASSERT_EQ(0x0000010du, ImmutableString("frexp(20B20C").mangledNameHash());
    ASSERT_EQ(0x0000010eu, ImmutableString("frexp(30B30C").mangledNameHash());
    ASSERT_EQ(0x0000010fu, ImmutableString("ldexp(00B00C").mangledNameHash());
    ASSERT_EQ(0x00000110u, ImmutableString("ldexp(10B10C").mangledNameHash());
    ASSERT_EQ(0x00000111u, ImmutableString("ldexp(20B20C").mangledNameHash());
    ASSERT_EQ(0x00000112u, ImmutableString("ldexp(30B30C").mangledNameHash());
    ASSERT_EQ(0x00000113u, ImmutableString("packSnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000114u, ImmutableString("packHalf2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000115u, ImmutableString("unpackSnorm2x16(00D").mangledNameHash());
    ASSERT_EQ(0x00000116u, ImmutableString("unpackHalf2x16(00D").mangledNameHash());
    ASSERT_EQ(0x00000117u, ImmutableString("packUnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000118u, ImmutableString("unpackUnorm2x16(00D").mangledNameHash());
    ASSERT_EQ(0x00000119u, ImmutableString("packUnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x0000011au, ImmutableString("packSnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x0000011bu, ImmutableString("unpackUnorm4x8(00D").mangledNameHash());
    ASSERT_EQ(0x0000011cu, ImmutableString("unpackSnorm4x8(00D").mangledNameHash());
    ASSERT_EQ(0x0000011du, ImmutableString("length(00B").mangledNameHash());
    ASSERT_EQ(0x0000011eu, ImmutableString("length(10B").mangledNameHash());
    ASSERT_EQ(0x0000011fu, ImmutableString("length(20B").mangledNameHash());
    ASSERT_EQ(0x00000120u, ImmutableString("length(30B").mangledNameHash());
    ASSERT_EQ(0x00000121u, ImmutableString("distance(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000122u, ImmutableString("distance(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000123u, ImmutableString("distance(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000124u, ImmutableString("distance(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000125u, ImmutableString("dot(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000126u, ImmutableString("dot(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000127u, ImmutableString("dot(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000128u, ImmutableString("dot(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000129u, ImmutableString("cross(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000012au, ImmutableString("normalize(00B").mangledNameHash());
    ASSERT_EQ(0x0000012bu, ImmutableString("normalize(10B").mangledNameHash());
    ASSERT_EQ(0x0000012cu, ImmutableString("normalize(20B").mangledNameHash());
    ASSERT_EQ(0x0000012du, ImmutableString("normalize(30B").mangledNameHash());
    ASSERT_EQ(0x0000012eu, ImmutableString("faceforward(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000012fu, ImmutableString("faceforward(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000130u, ImmutableString("faceforward(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000131u, ImmutableString("faceforward(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000132u, ImmutableString("reflect(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000133u, ImmutableString("reflect(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000134u, ImmutableString("reflect(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000135u, ImmutableString("reflect(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000136u, ImmutableString("refract(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000137u, ImmutableString("refract(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x00000138u, ImmutableString("refract(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x00000139u, ImmutableString("refract(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x0000013au, ImmutableString("matrixCompMult(50B50B").mangledNameHash());
    ASSERT_EQ(0x0000013bu, ImmutableString("matrixCompMult(A0BA0B").mangledNameHash());
    ASSERT_EQ(0x0000013cu, ImmutableString("matrixCompMult(F0BF0B").mangledNameHash());
    ASSERT_EQ(0x0000013du, ImmutableString("matrixCompMult(90B90B").mangledNameHash());
    ASSERT_EQ(0x0000013eu, ImmutableString("matrixCompMult(60B60B").mangledNameHash());
    ASSERT_EQ(0x0000013fu, ImmutableString("matrixCompMult(D0BD0B").mangledNameHash());
    ASSERT_EQ(0x00000140u, ImmutableString("matrixCompMult(70B70B").mangledNameHash());
    ASSERT_EQ(0x00000141u, ImmutableString("matrixCompMult(E0BE0B").mangledNameHash());
    ASSERT_EQ(0x00000142u, ImmutableString("matrixCompMult(B0BB0B").mangledNameHash());
    ASSERT_EQ(0x00000143u, ImmutableString("outerProduct(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000144u, ImmutableString("outerProduct(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000145u, ImmutableString("outerProduct(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000146u, ImmutableString("outerProduct(20B10B").mangledNameHash());
    ASSERT_EQ(0x00000147u, ImmutableString("outerProduct(10B20B").mangledNameHash());
    ASSERT_EQ(0x00000148u, ImmutableString("outerProduct(30B10B").mangledNameHash());
    ASSERT_EQ(0x00000149u, ImmutableString("outerProduct(10B30B").mangledNameHash());
    ASSERT_EQ(0x0000014au, ImmutableString("outerProduct(30B20B").mangledNameHash());
    ASSERT_EQ(0x0000014bu, ImmutableString("outerProduct(20B30B").mangledNameHash());
    ASSERT_EQ(0x0000014cu, ImmutableString("transpose(50B").mangledNameHash());
    ASSERT_EQ(0x0000014du, ImmutableString("transpose(A0B").mangledNameHash());
    ASSERT_EQ(0x0000014eu, ImmutableString("transpose(F0B").mangledNameHash());
    ASSERT_EQ(0x0000014fu, ImmutableString("transpose(60B").mangledNameHash());
    ASSERT_EQ(0x00000150u, ImmutableString("transpose(90B").mangledNameHash());
    ASSERT_EQ(0x00000151u, ImmutableString("transpose(70B").mangledNameHash());
    ASSERT_EQ(0x00000152u, ImmutableString("transpose(D0B").mangledNameHash());
    ASSERT_EQ(0x00000153u, ImmutableString("transpose(B0B").mangledNameHash());
    ASSERT_EQ(0x00000154u, ImmutableString("transpose(E0B").mangledNameHash());
    ASSERT_EQ(0x00000155u, ImmutableString("determinant(50B").mangledNameHash());
    ASSERT_EQ(0x00000156u, ImmutableString("determinant(A0B").mangledNameHash());
    ASSERT_EQ(0x00000157u, ImmutableString("determinant(F0B").mangledNameHash());
    ASSERT_EQ(0x00000158u, ImmutableString("inverse(50B").mangledNameHash());
    ASSERT_EQ(0x00000159u, ImmutableString("inverse(A0B").mangledNameHash());
    ASSERT_EQ(0x0000015au, ImmutableString("inverse(F0B").mangledNameHash());
    ASSERT_EQ(0x0000015bu, ImmutableString("lessThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000015cu, ImmutableString("lessThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000015du, ImmutableString("lessThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000015eu, ImmutableString("lessThan(10C10C").mangledNameHash());
    ASSERT_EQ(0x0000015fu, ImmutableString("lessThan(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000160u, ImmutableString("lessThan(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000161u, ImmutableString("lessThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000162u, ImmutableString("lessThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000163u, ImmutableString("lessThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000164u, ImmutableString("lessThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000165u, ImmutableString("lessThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000166u, ImmutableString("lessThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000167u, ImmutableString("lessThanEqual(10C10C").mangledNameHash());
    ASSERT_EQ(0x00000168u, ImmutableString("lessThanEqual(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000169u, ImmutableString("lessThanEqual(30C30C").mangledNameHash());
    ASSERT_EQ(0x0000016au, ImmutableString("lessThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000016bu, ImmutableString("lessThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000016cu, ImmutableString("lessThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000016du, ImmutableString("greaterThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000016eu, ImmutableString("greaterThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000016fu, ImmutableString("greaterThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000170u, ImmutableString("greaterThan(10C10C").mangledNameHash());
    ASSERT_EQ(0x00000171u, ImmutableString("greaterThan(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000172u, ImmutableString("greaterThan(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000173u, ImmutableString("greaterThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000174u, ImmutableString("greaterThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000175u, ImmutableString("greaterThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000176u, ImmutableString("greaterThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000177u, ImmutableString("greaterThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000178u, ImmutableString("greaterThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000179u, ImmutableString("greaterThanEqual(10C10C").mangledNameHash());
    ASSERT_EQ(0x0000017au, ImmutableString("greaterThanEqual(20C20C").mangledNameHash());
    ASSERT_EQ(0x0000017bu, ImmutableString("greaterThanEqual(30C30C").mangledNameHash());
    ASSERT_EQ(0x0000017cu, ImmutableString("greaterThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000017du, ImmutableString("greaterThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000017eu, ImmutableString("greaterThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000017fu, ImmutableString("equal(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000180u, ImmutableString("equal(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000181u, ImmutableString("equal(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000182u, ImmutableString("equal(10C10C").mangledNameHash());
    ASSERT_EQ(0x00000183u, ImmutableString("equal(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000184u, ImmutableString("equal(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000185u, ImmutableString("equal(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000186u, ImmutableString("equal(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000187u, ImmutableString("equal(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000188u, ImmutableString("equal(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000189u, ImmutableString("equal(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000018au, ImmutableString("equal(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000018bu, ImmutableString("notEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000018cu, ImmutableString("notEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000018du, ImmutableString("notEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000018eu, ImmutableString("notEqual(10C10C").mangledNameHash());
    ASSERT_EQ(0x0000018fu, ImmutableString("notEqual(20C20C").mangledNameHash());
    ASSERT_EQ(0x00000190u, ImmutableString("notEqual(30C30C").mangledNameHash());
    ASSERT_EQ(0x00000191u, ImmutableString("notEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000192u, ImmutableString("notEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000193u, ImmutableString("notEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000194u, ImmutableString("notEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000195u, ImmutableString("notEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000196u, ImmutableString("notEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000197u, ImmutableString("any(10E").mangledNameHash());
    ASSERT_EQ(0x00000198u, ImmutableString("any(20E").mangledNameHash());
    ASSERT_EQ(0x00000199u, ImmutableString("any(30E").mangledNameHash());
    ASSERT_EQ(0x0000019au, ImmutableString("all(10E").mangledNameHash());
    ASSERT_EQ(0x0000019bu, ImmutableString("all(20E").mangledNameHash());
    ASSERT_EQ(0x0000019cu, ImmutableString("all(30E").mangledNameHash());
    ASSERT_EQ(0x0000019du, ImmutableString("not(10E").mangledNameHash());
    ASSERT_EQ(0x0000019eu, ImmutableString("not(20E").mangledNameHash());
    ASSERT_EQ(0x0000019fu, ImmutableString("not(30E").mangledNameHash());
    ASSERT_EQ(0x000001a0u, ImmutableString("bitfieldExtract(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a1u, ImmutableString("bitfieldExtract(10C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a2u, ImmutableString("bitfieldExtract(20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a3u, ImmutableString("bitfieldExtract(30C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a4u, ImmutableString("bitfieldExtract(00D00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a5u, ImmutableString("bitfieldExtract(10D00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a6u, ImmutableString("bitfieldExtract(20D00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a7u, ImmutableString("bitfieldExtract(30D00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a8u, ImmutableString("bitfieldInsert(00C00C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001a9u, ImmutableString("bitfieldInsert(10C10C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001aau, ImmutableString("bitfieldInsert(20C20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001abu, ImmutableString("bitfieldInsert(30C30C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001acu, ImmutableString("bitfieldInsert(00D00D00C00C").mangledNameHash());
    ASSERT_EQ(0x000001adu, ImmutableString("bitfieldInsert(10D10D00C00C").mangledNameHash());
    ASSERT_EQ(0x000001aeu, ImmutableString("bitfieldInsert(20D20D00C00C").mangledNameHash());
    ASSERT_EQ(0x000001afu, ImmutableString("bitfieldInsert(30D30D00C00C").mangledNameHash());
    ASSERT_EQ(0x000001b0u, ImmutableString("bitfieldReverse(00C").mangledNameHash());
    ASSERT_EQ(0x000001b1u, ImmutableString("bitfieldReverse(10C").mangledNameHash());
    ASSERT_EQ(0x000001b2u, ImmutableString("bitfieldReverse(20C").mangledNameHash());
    ASSERT_EQ(0x000001b3u, ImmutableString("bitfieldReverse(30C").mangledNameHash());
    ASSERT_EQ(0x000001b4u, ImmutableString("bitfieldReverse(00D").mangledNameHash());
    ASSERT_EQ(0x000001b5u, ImmutableString("bitfieldReverse(10D").mangledNameHash());
    ASSERT_EQ(0x000001b6u, ImmutableString("bitfieldReverse(20D").mangledNameHash());
    ASSERT_EQ(0x000001b7u, ImmutableString("bitfieldReverse(30D").mangledNameHash());
    ASSERT_EQ(0x000001b8u, ImmutableString("bitCount(00C").mangledNameHash());
    ASSERT_EQ(0x000001b9u, ImmutableString("bitCount(10C").mangledNameHash());
    ASSERT_EQ(0x000001bau, ImmutableString("bitCount(20C").mangledNameHash());
    ASSERT_EQ(0x000001bbu, ImmutableString("bitCount(30C").mangledNameHash());
    ASSERT_EQ(0x000001bcu, ImmutableString("bitCount(00D").mangledNameHash());
    ASSERT_EQ(0x000001bdu, ImmutableString("bitCount(10D").mangledNameHash());
    ASSERT_EQ(0x000001beu, ImmutableString("bitCount(20D").mangledNameHash());
    ASSERT_EQ(0x000001bfu, ImmutableString("bitCount(30D").mangledNameHash());
    ASSERT_EQ(0x000001c0u, ImmutableString("findLSB(00C").mangledNameHash());
    ASSERT_EQ(0x000001c1u, ImmutableString("findLSB(10C").mangledNameHash());
    ASSERT_EQ(0x000001c2u, ImmutableString("findLSB(20C").mangledNameHash());
    ASSERT_EQ(0x000001c3u, ImmutableString("findLSB(30C").mangledNameHash());
    ASSERT_EQ(0x000001c4u, ImmutableString("findLSB(00D").mangledNameHash());
    ASSERT_EQ(0x000001c5u, ImmutableString("findLSB(10D").mangledNameHash());
    ASSERT_EQ(0x000001c6u, ImmutableString("findLSB(20D").mangledNameHash());
    ASSERT_EQ(0x000001c7u, ImmutableString("findLSB(30D").mangledNameHash());
    ASSERT_EQ(0x000001c8u, ImmutableString("findMSB(00C").mangledNameHash());
    ASSERT_EQ(0x000001c9u, ImmutableString("findMSB(10C").mangledNameHash());
    ASSERT_EQ(0x000001cau, ImmutableString("findMSB(20C").mangledNameHash());
    ASSERT_EQ(0x000001cbu, ImmutableString("findMSB(30C").mangledNameHash());
    ASSERT_EQ(0x000001ccu, ImmutableString("findMSB(00D").mangledNameHash());
    ASSERT_EQ(0x000001cdu, ImmutableString("findMSB(10D").mangledNameHash());
    ASSERT_EQ(0x000001ceu, ImmutableString("findMSB(20D").mangledNameHash());
    ASSERT_EQ(0x000001cfu, ImmutableString("findMSB(30D").mangledNameHash());
    ASSERT_EQ(0x000001d0u, ImmutableString("uaddCarry(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001d1u, ImmutableString("uaddCarry(10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000001d2u, ImmutableString("uaddCarry(20D20D20D").mangledNameHash());
    ASSERT_EQ(0x000001d3u, ImmutableString("uaddCarry(30D30D30D").mangledNameHash());
    ASSERT_EQ(0x000001d4u, ImmutableString("usubBorrow(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001d5u, ImmutableString("usubBorrow(10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000001d6u, ImmutableString("usubBorrow(20D20D20D").mangledNameHash());
    ASSERT_EQ(0x000001d7u, ImmutableString("usubBorrow(30D30D30D").mangledNameHash());
    ASSERT_EQ(0x000001d8u, ImmutableString("umulExtended(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001d9u, ImmutableString("umulExtended(10D10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000001dau, ImmutableString("umulExtended(20D20D20D20D").mangledNameHash());
    ASSERT_EQ(0x000001dbu, ImmutableString("umulExtended(30D30D30D30D").mangledNameHash());
    ASSERT_EQ(0x000001dcu, ImmutableString("imulExtended(00C00C00C00C").mangledNameHash());
    ASSERT_EQ(0x000001ddu, ImmutableString("imulExtended(10C10C10C10C").mangledNameHash());
    ASSERT_EQ(0x000001deu, ImmutableString("imulExtended(20C20C20C20C").mangledNameHash());
    ASSERT_EQ(0x000001dfu, ImmutableString("imulExtended(30C30C30C30C").mangledNameHash());
    ASSERT_EQ(0x000001e0u, ImmutableString("texture2D(00H10B").mangledNameHash());
    ASSERT_EQ(0x000001e1u, ImmutableString("texture2DProj(00H20B").mangledNameHash());
    ASSERT_EQ(0x000001e2u, ImmutableString("texture2DProj(00H30B").mangledNameHash());
    ASSERT_EQ(0x000001e3u, ImmutableString("textureCube(00J20B").mangledNameHash());
    ASSERT_EQ(0x000001e4u, ImmutableString("texture3D(00I20B").mangledNameHash());
    ASSERT_EQ(0x000001e5u, ImmutableString("texture3DProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x000001e6u, ImmutableString("shadow2DEXT(00c20B").mangledNameHash());
    ASSERT_EQ(0x000001e7u, ImmutableString("shadow2DProjEXT(00c30B").mangledNameHash());
    ASSERT_EQ(0x000001e8u, ImmutableString("texture2D(00L10B").mangledNameHash());
    ASSERT_EQ(0x000001e9u, ImmutableString("texture2DProj(00L20B").mangledNameHash());
    ASSERT_EQ(0x000001eau, ImmutableString("texture2DProj(00L30B").mangledNameHash());
    ASSERT_EQ(0x000001ebu, ImmutableString("texture2DRect(00N10B").mangledNameHash());
    ASSERT_EQ(0x000001ecu, ImmutableString("texture2DRectProj(00N20B").mangledNameHash());
    ASSERT_EQ(0x000001edu, ImmutableString("texture2DRectProj(00N30B").mangledNameHash());
    ASSERT_EQ(0x000001eeu, ImmutableString("texture2DGradEXT(00H10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001efu, ImmutableString("texture2DProjGradEXT(00H20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001f0u, ImmutableString("texture2DProjGradEXT(00H30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001f1u, ImmutableString("textureCubeGradEXT(00J20B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001f2u, ImmutableString("textureVideoWEBGL(00o10B").mangledNameHash());
    ASSERT_EQ(0x000001f3u, ImmutableString("texture2D(00H10B00B").mangledNameHash());
    ASSERT_EQ(0x000001f4u, ImmutableString("texture2DProj(00H20B00B").mangledNameHash());
    ASSERT_EQ(0x000001f5u, ImmutableString("texture2DProj(00H30B00B").mangledNameHash());
    ASSERT_EQ(0x000001f6u, ImmutableString("textureCube(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x000001f7u, ImmutableString("texture3D(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000001f8u, ImmutableString("texture3DProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000001f9u, ImmutableString("texture3DLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000001fau, ImmutableString("texture3DProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000001fbu, ImmutableString("texture2DLod(00H10B00B").mangledNameHash());
    ASSERT_EQ(0x000001fcu, ImmutableString("texture2DProjLod(00H20B00B").mangledNameHash());
    ASSERT_EQ(0x000001fdu, ImmutableString("texture2DProjLod(00H30B00B").mangledNameHash());
    ASSERT_EQ(0x000001feu, ImmutableString("textureCubeLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x000001ffu, ImmutableString("texture2DLodEXT(00H10B00B").mangledNameHash());
    ASSERT_EQ(0x00000200u, ImmutableString("texture2DProjLodEXT(00H20B00B").mangledNameHash());
    ASSERT_EQ(0x00000201u, ImmutableString("texture2DProjLodEXT(00H30B00B").mangledNameHash());
    ASSERT_EQ(0x00000202u, ImmutableString("textureCubeLodEXT(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000203u, ImmutableString("texture(00H10B").mangledNameHash());
    ASSERT_EQ(0x00000204u, ImmutableString("texture(00Q10B").mangledNameHash());
    ASSERT_EQ(0x00000205u, ImmutableString("texture(00W10B").mangledNameHash());
    ASSERT_EQ(0x00000206u, ImmutableString("texture(00I20B").mangledNameHash());
    ASSERT_EQ(0x00000207u, ImmutableString("texture(00R20B").mangledNameHash());
    ASSERT_EQ(0x00000208u, ImmutableString("texture(00X20B").mangledNameHash());
    ASSERT_EQ(0x00000209u, ImmutableString("texture(00J20B").mangledNameHash());
    ASSERT_EQ(0x0000020au, ImmutableString("texture(00S20B").mangledNameHash());
    ASSERT_EQ(0x0000020bu, ImmutableString("texture(00Y20B").mangledNameHash());
    ASSERT_EQ(0x0000020cu, ImmutableString("texture(00K20B").mangledNameHash());
    ASSERT_EQ(0x0000020du, ImmutableString("texture(00T20B").mangledNameHash());
    ASSERT_EQ(0x0000020eu, ImmutableString("texture(00Z20B").mangledNameHash());
    ASSERT_EQ(0x0000020fu, ImmutableString("texture(00c20B").mangledNameHash());
    ASSERT_EQ(0x00000210u, ImmutableString("texture(00d30B").mangledNameHash());
    ASSERT_EQ(0x00000211u, ImmutableString("texture(00e30B").mangledNameHash());
    ASSERT_EQ(0x00000212u, ImmutableString("texture(00g30B").mangledNameHash());
    ASSERT_EQ(0x00000213u, ImmutableString("texture(00k30B").mangledNameHash());
    ASSERT_EQ(0x00000214u, ImmutableString("texture(00n30B").mangledNameHash());
    ASSERT_EQ(0x00000215u, ImmutableString("texture(00h30B00B").mangledNameHash());
    ASSERT_EQ(0x00000216u, ImmutableString("texture(00L10B").mangledNameHash());
    ASSERT_EQ(0x00000217u, ImmutableString("texture(00M10B").mangledNameHash());
    ASSERT_EQ(0x00000218u, ImmutableString("texture(00N10B").mangledNameHash());
    ASSERT_EQ(0x00000219u, ImmutableString("texture(00o10B").mangledNameHash());
    ASSERT_EQ(0x0000021au, ImmutableString("textureProj(00H20B").mangledNameHash());
    ASSERT_EQ(0x0000021bu, ImmutableString("textureProj(00Q20B").mangledNameHash());
    ASSERT_EQ(0x0000021cu, ImmutableString("textureProj(00W20B").mangledNameHash());
    ASSERT_EQ(0x0000021du, ImmutableString("textureProj(00H30B").mangledNameHash());
    ASSERT_EQ(0x0000021eu, ImmutableString("textureProj(00Q30B").mangledNameHash());
    ASSERT_EQ(0x0000021fu, ImmutableString("textureProj(00W30B").mangledNameHash());
    ASSERT_EQ(0x00000220u, ImmutableString("textureProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x00000221u, ImmutableString("textureProj(00R30B").mangledNameHash());
    ASSERT_EQ(0x00000222u, ImmutableString("textureProj(00X30B").mangledNameHash());
    ASSERT_EQ(0x00000223u, ImmutableString("textureProj(00c30B").mangledNameHash());
    ASSERT_EQ(0x00000224u, ImmutableString("textureProj(00L20B").mangledNameHash());
    ASSERT_EQ(0x00000225u, ImmutableString("textureProj(00L30B").mangledNameHash());
    ASSERT_EQ(0x00000226u, ImmutableString("textureProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x00000227u, ImmutableString("textureProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x00000228u, ImmutableString("textureProj(00N20B").mangledNameHash());
    ASSERT_EQ(0x00000229u, ImmutableString("textureProj(00N30B").mangledNameHash());
    ASSERT_EQ(0x0000022au, ImmutableString("textureLod(00H10B00B").mangledNameHash());
    ASSERT_EQ(0x0000022bu, ImmutableString("textureLod(00Q10B00B").mangledNameHash());
    ASSERT_EQ(0x0000022cu, ImmutableString("textureLod(00W10B00B").mangledNameHash());
    ASSERT_EQ(0x0000022du, ImmutableString("textureLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x0000022eu, ImmutableString("textureLod(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x0000022fu, ImmutableString("textureLod(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x00000230u, ImmutableString("textureLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000231u, ImmutableString("textureLod(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x00000232u, ImmutableString("textureLod(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x00000233u, ImmutableString("textureLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x00000234u, ImmutableString("textureLod(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x00000235u, ImmutableString("textureLod(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x00000236u, ImmutableString("textureLod(00c20B00B").mangledNameHash());
    ASSERT_EQ(0x00000237u, ImmutableString("textureLod(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x00000238u, ImmutableString("textureLod(00e30B00B").mangledNameHash());
    ASSERT_EQ(0x00000239u, ImmutableString("textureLod(00h30B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000023au, ImmutableString("textureLod(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x0000023bu, ImmutableString("textureLod(00k30B00B").mangledNameHash());
    ASSERT_EQ(0x0000023cu, ImmutableString("textureLod(00n30B00B").mangledNameHash());
    ASSERT_EQ(0x0000023du, ImmutableString("textureSize(00H00C").mangledNameHash());
    ASSERT_EQ(0x0000023eu, ImmutableString("textureSize(00Q00C").mangledNameHash());
    ASSERT_EQ(0x0000023fu, ImmutableString("textureSize(00W00C").mangledNameHash());
    ASSERT_EQ(0x00000240u, ImmutableString("textureSize(00I00C").mangledNameHash());
    ASSERT_EQ(0x00000241u, ImmutableString("textureSize(00R00C").mangledNameHash());
    ASSERT_EQ(0x00000242u, ImmutableString("textureSize(00X00C").mangledNameHash());
    ASSERT_EQ(0x00000243u, ImmutableString("textureSize(00J00C").mangledNameHash());
    ASSERT_EQ(0x00000244u, ImmutableString("textureSize(00S00C").mangledNameHash());
    ASSERT_EQ(0x00000245u, ImmutableString("textureSize(00Y00C").mangledNameHash());
    ASSERT_EQ(0x00000246u, ImmutableString("textureSize(00K00C").mangledNameHash());
    ASSERT_EQ(0x00000247u, ImmutableString("textureSize(00T00C").mangledNameHash());
    ASSERT_EQ(0x00000248u, ImmutableString("textureSize(00Z00C").mangledNameHash());
    ASSERT_EQ(0x00000249u, ImmutableString("textureSize(00c00C").mangledNameHash());
    ASSERT_EQ(0x0000024au, ImmutableString("textureSize(00d00C").mangledNameHash());
    ASSERT_EQ(0x0000024bu, ImmutableString("textureSize(00e00C").mangledNameHash());
    ASSERT_EQ(0x0000024cu, ImmutableString("textureSize(00g00C").mangledNameHash());
    ASSERT_EQ(0x0000024du, ImmutableString("textureSize(00k00C").mangledNameHash());
    ASSERT_EQ(0x0000024eu, ImmutableString("textureSize(00n00C").mangledNameHash());
    ASSERT_EQ(0x0000024fu, ImmutableString("textureSize(00h00C").mangledNameHash());
    ASSERT_EQ(0x00000250u, ImmutableString("textureSize(00f").mangledNameHash());
    ASSERT_EQ(0x00000251u, ImmutableString("textureSize(00j").mangledNameHash());
    ASSERT_EQ(0x00000252u, ImmutableString("textureSize(00m").mangledNameHash());
    ASSERT_EQ(0x00000253u, ImmutableString("textureSize(00O").mangledNameHash());
    ASSERT_EQ(0x00000254u, ImmutableString("textureSize(00U").mangledNameHash());
    ASSERT_EQ(0x00000255u, ImmutableString("textureSize(00a").mangledNameHash());
    ASSERT_EQ(0x00000256u, ImmutableString("textureSize(00P").mangledNameHash());
    ASSERT_EQ(0x00000257u, ImmutableString("textureSize(00V").mangledNameHash());
    ASSERT_EQ(0x00000258u, ImmutableString("textureSize(00b").mangledNameHash());
    ASSERT_EQ(0x00000259u, ImmutableString("textureSize(00L00C").mangledNameHash());
    ASSERT_EQ(0x0000025au, ImmutableString("textureSize(00M00C").mangledNameHash());
    ASSERT_EQ(0x0000025bu, ImmutableString("textureProjLod(00H20B00B").mangledNameHash());
    ASSERT_EQ(0x0000025cu, ImmutableString("textureProjLod(00Q20B00B").mangledNameHash());
    ASSERT_EQ(0x0000025du, ImmutableString("textureProjLod(00W20B00B").mangledNameHash());
    ASSERT_EQ(0x0000025eu, ImmutableString("textureProjLod(00H30B00B").mangledNameHash());
    ASSERT_EQ(0x0000025fu, ImmutableString("textureProjLod(00Q30B00B").mangledNameHash());
    ASSERT_EQ(0x00000260u, ImmutableString("textureProjLod(00W30B00B").mangledNameHash());
    ASSERT_EQ(0x00000261u, ImmutableString("textureProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000262u, ImmutableString("textureProjLod(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x00000263u, ImmutableString("textureProjLod(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x00000264u, ImmutableString("textureProjLod(00c30B00B").mangledNameHash());
    ASSERT_EQ(0x00000265u, ImmutableString("texelFetch(00H10C00C").mangledNameHash());
    ASSERT_EQ(0x00000266u, ImmutableString("texelFetch(00Q10C00C").mangledNameHash());
    ASSERT_EQ(0x00000267u, ImmutableString("texelFetch(00W10C00C").mangledNameHash());
    ASSERT_EQ(0x00000268u, ImmutableString("texelFetch(00I20C00C").mangledNameHash());
    ASSERT_EQ(0x00000269u, ImmutableString("texelFetch(00R20C00C").mangledNameHash());
    ASSERT_EQ(0x0000026au, ImmutableString("texelFetch(00X20C00C").mangledNameHash());
    ASSERT_EQ(0x0000026bu, ImmutableString("texelFetch(00K20C00C").mangledNameHash());
    ASSERT_EQ(0x0000026cu, ImmutableString("texelFetch(00T20C00C").mangledNameHash());
    ASSERT_EQ(0x0000026du, ImmutableString("texelFetch(00Z20C00C").mangledNameHash());
    ASSERT_EQ(0x0000026eu, ImmutableString("texelFetch(00f00C").mangledNameHash());
    ASSERT_EQ(0x0000026fu, ImmutableString("texelFetch(00j00C").mangledNameHash());
    ASSERT_EQ(0x00000270u, ImmutableString("texelFetch(00m00C").mangledNameHash());
    ASSERT_EQ(0x00000271u, ImmutableString("texelFetch(00O10C00C").mangledNameHash());
    ASSERT_EQ(0x00000272u, ImmutableString("texelFetch(00U10C00C").mangledNameHash());
    ASSERT_EQ(0x00000273u, ImmutableString("texelFetch(00a10C00C").mangledNameHash());
    ASSERT_EQ(0x00000274u, ImmutableString("texelFetch(00P20C00C").mangledNameHash());
    ASSERT_EQ(0x00000275u, ImmutableString("texelFetch(00V20C00C").mangledNameHash());
    ASSERT_EQ(0x00000276u, ImmutableString("texelFetch(00b20C00C").mangledNameHash());
    ASSERT_EQ(0x00000277u, ImmutableString("texelFetch(00L10C00C").mangledNameHash());
    ASSERT_EQ(0x00000278u, ImmutableString("texelFetch(00M10C00C").mangledNameHash());
    ASSERT_EQ(0x00000279u, ImmutableString("textureGrad(00H10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000027au, ImmutableString("textureGrad(00Q10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000027bu, ImmutableString("textureGrad(00W10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000027cu, ImmutableString("textureGrad(00I20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000027du, ImmutableString("textureGrad(00R20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000027eu, ImmutableString("textureGrad(00X20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000027fu, ImmutableString("textureGrad(00J20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000280u, ImmutableString("textureGrad(00S20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000281u, ImmutableString("textureGrad(00Y20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000282u, ImmutableString("textureGrad(00c20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000283u, ImmutableString("textureGrad(00d30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000284u, ImmutableString("textureGrad(00K20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000285u, ImmutableString("textureGrad(00T20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000286u, ImmutableString("textureGrad(00Z20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000287u, ImmutableString("textureGrad(00e30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000288u, ImmutableString("textureGrad(00g30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000289u, ImmutableString("textureGrad(00k30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000028au, ImmutableString("textureGrad(00n30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000028bu, ImmutableString("textureProjGrad(00H20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000028cu, ImmutableString("textureProjGrad(00Q20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000028du, ImmutableString("textureProjGrad(00W20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000028eu, ImmutableString("textureProjGrad(00H30B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000028fu, ImmutableString("textureProjGrad(00Q30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000290u, ImmutableString("textureProjGrad(00W30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000291u, ImmutableString("textureProjGrad(00I30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000292u, ImmutableString("textureProjGrad(00R30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000293u, ImmutableString("textureProjGrad(00X30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000294u, ImmutableString("textureProjGrad(00c30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000295u, ImmutableString("texture(00H10B00B").mangledNameHash());
    ASSERT_EQ(0x00000296u, ImmutableString("texture(00Q10B00B").mangledNameHash());
    ASSERT_EQ(0x00000297u, ImmutableString("texture(00W10B00B").mangledNameHash());
    ASSERT_EQ(0x00000298u, ImmutableString("texture(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x00000299u, ImmutableString("texture(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029au, ImmutableString("texture(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029bu, ImmutableString("texture(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029cu, ImmutableString("texture(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029du, ImmutableString("texture(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029eu, ImmutableString("texture(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029fu, ImmutableString("texture(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a0u, ImmutableString("texture(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a1u, ImmutableString("textureProj(00H20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a2u, ImmutableString("textureProj(00Q20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a3u, ImmutableString("textureProj(00W20B00B").mangledNameHash());
    ASSERT_EQ(0x000002a4u, ImmutableString("textureProj(00H30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a5u, ImmutableString("textureProj(00Q30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a6u, ImmutableString("textureProj(00W30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a7u, ImmutableString("textureProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a8u, ImmutableString("textureProj(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x000002a9u, ImmutableString("textureProj(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x000002aau, ImmutableString("texture(00c20B00B").mangledNameHash());
    ASSERT_EQ(0x000002abu, ImmutableString("texture(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x000002acu, ImmutableString("textureProj(00c30B00B").mangledNameHash());
    ASSERT_EQ(0x000002adu, ImmutableString("texture(00e30B00B").mangledNameHash());
    ASSERT_EQ(0x000002aeu, ImmutableString("texture(00g30B00B").mangledNameHash());
    ASSERT_EQ(0x000002afu, ImmutableString("texture(00k30B00B").mangledNameHash());
    ASSERT_EQ(0x000002b0u, ImmutableString("texture(00n30B00B").mangledNameHash());
    ASSERT_EQ(0x000002b1u, ImmutableString("texture(00h30B00B00B").mangledNameHash());
    ASSERT_EQ(0x000002b2u, ImmutableString("texture(00L10B00B").mangledNameHash());
    ASSERT_EQ(0x000002b3u, ImmutableString("textureProj(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x000002b4u, ImmutableString("textureProj(00L30B00B").mangledNameHash());
    ASSERT_EQ(0x000002b5u, ImmutableString("texture(00M10B00B").mangledNameHash());
    ASSERT_EQ(0x000002b6u, ImmutableString("textureProj(00M20B00B").mangledNameHash());
    ASSERT_EQ(0x000002b7u, ImmutableString("textureProj(00M30B00B").mangledNameHash());
    ASSERT_EQ(0x000002b8u, ImmutableString("textureOffset(00H10B10C").mangledNameHash());
    ASSERT_EQ(0x000002b9u, ImmutableString("textureOffset(00Q10B10C").mangledNameHash());
    ASSERT_EQ(0x000002bau, ImmutableString("textureOffset(00W10B10C").mangledNameHash());
    ASSERT_EQ(0x000002bbu, ImmutableString("textureOffset(00I20B20C").mangledNameHash());
    ASSERT_EQ(0x000002bcu, ImmutableString("textureOffset(00R20B20C").mangledNameHash());
    ASSERT_EQ(0x000002bdu, ImmutableString("textureOffset(00X20B20C").mangledNameHash());
    ASSERT_EQ(0x000002beu, ImmutableString("textureOffset(00c20B10C").mangledNameHash());
    ASSERT_EQ(0x000002bfu, ImmutableString("textureOffset(00K20B10C").mangledNameHash());
    ASSERT_EQ(0x000002c0u, ImmutableString("textureOffset(00T20B10C").mangledNameHash());
    ASSERT_EQ(0x000002c1u, ImmutableString("textureOffset(00Z20B10C").mangledNameHash());
    ASSERT_EQ(0x000002c2u, ImmutableString("textureOffset(00e30B10C").mangledNameHash());
    ASSERT_EQ(0x000002c3u, ImmutableString("textureProjOffset(00H20B10C").mangledNameHash());
    ASSERT_EQ(0x000002c4u, ImmutableString("textureProjOffset(00Q20B10C").mangledNameHash());
    ASSERT_EQ(0x000002c5u, ImmutableString("textureProjOffset(00W20B10C").mangledNameHash());
    ASSERT_EQ(0x000002c6u, ImmutableString("textureProjOffset(00H30B10C").mangledNameHash());
    ASSERT_EQ(0x000002c7u, ImmutableString("textureProjOffset(00Q30B10C").mangledNameHash());
    ASSERT_EQ(0x000002c8u, ImmutableString("textureProjOffset(00W30B10C").mangledNameHash());
    ASSERT_EQ(0x000002c9u, ImmutableString("textureProjOffset(00I30B20C").mangledNameHash());
    ASSERT_EQ(0x000002cau, ImmutableString("textureProjOffset(00R30B20C").mangledNameHash());
    ASSERT_EQ(0x000002cbu, ImmutableString("textureProjOffset(00X30B20C").mangledNameHash());
    ASSERT_EQ(0x000002ccu, ImmutableString("textureProjOffset(00c30B10C").mangledNameHash());
    ASSERT_EQ(0x000002cdu, ImmutableString("textureLodOffset(00H10B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002ceu, ImmutableString("textureLodOffset(00Q10B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002cfu, ImmutableString("textureLodOffset(00W10B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002d0u, ImmutableString("textureLodOffset(00I20B00B20C").mangledNameHash());
    ASSERT_EQ(0x000002d1u, ImmutableString("textureLodOffset(00R20B00B20C").mangledNameHash());
    ASSERT_EQ(0x000002d2u, ImmutableString("textureLodOffset(00X20B00B20C").mangledNameHash());
    ASSERT_EQ(0x000002d3u, ImmutableString("textureLodOffset(00c20B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002d4u, ImmutableString("textureLodOffset(00K20B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002d5u, ImmutableString("textureLodOffset(00T20B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002d6u, ImmutableString("textureLodOffset(00Z20B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002d7u, ImmutableString("textureLodOffset(00e30B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002d8u, ImmutableString("textureProjLodOffset(00H20B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002d9u, ImmutableString("textureProjLodOffset(00Q20B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002dau, ImmutableString("textureProjLodOffset(00W20B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002dbu, ImmutableString("textureProjLodOffset(00H30B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002dcu, ImmutableString("textureProjLodOffset(00Q30B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002ddu, ImmutableString("textureProjLodOffset(00W30B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002deu, ImmutableString("textureProjLodOffset(00I30B00B20C").mangledNameHash());
    ASSERT_EQ(0x000002dfu, ImmutableString("textureProjLodOffset(00R30B00B20C").mangledNameHash());
    ASSERT_EQ(0x000002e0u, ImmutableString("textureProjLodOffset(00X30B00B20C").mangledNameHash());
    ASSERT_EQ(0x000002e1u, ImmutableString("textureProjLodOffset(00c30B00B10C").mangledNameHash());
    ASSERT_EQ(0x000002e2u, ImmutableString("texelFetchOffset(00H10C00C10C").mangledNameHash());
    ASSERT_EQ(0x000002e3u, ImmutableString("texelFetchOffset(00Q10C00C10C").mangledNameHash());
    ASSERT_EQ(0x000002e4u, ImmutableString("texelFetchOffset(00W10C00C10C").mangledNameHash());
    ASSERT_EQ(0x000002e5u, ImmutableString("texelFetchOffset(00I20C00C20C").mangledNameHash());
    ASSERT_EQ(0x000002e6u, ImmutableString("texelFetchOffset(00R20C00C20C").mangledNameHash());
    ASSERT_EQ(0x000002e7u, ImmutableString("texelFetchOffset(00X20C00C20C").mangledNameHash());
    ASSERT_EQ(0x000002e8u, ImmutableString("texelFetchOffset(00K20C00C10C").mangledNameHash());
    ASSERT_EQ(0x000002e9u, ImmutableString("texelFetchOffset(00T20C00C10C").mangledNameHash());
    ASSERT_EQ(0x000002eau, ImmutableString("texelFetchOffset(00Z20C00C10C").mangledNameHash());
    ASSERT_EQ(0x000002ebu, ImmutableString("textureGradOffset(00H10B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002ecu, ImmutableString("textureGradOffset(00Q10B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002edu, ImmutableString("textureGradOffset(00W10B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002eeu, ImmutableString("textureGradOffset(00I20B20B20B20C").mangledNameHash());
    ASSERT_EQ(0x000002efu, ImmutableString("textureGradOffset(00R20B20B20B20C").mangledNameHash());
    ASSERT_EQ(0x000002f0u, ImmutableString("textureGradOffset(00X20B20B20B20C").mangledNameHash());
    ASSERT_EQ(0x000002f1u, ImmutableString("textureGradOffset(00c20B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002f2u, ImmutableString("textureGradOffset(00K20B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002f3u, ImmutableString("textureGradOffset(00T20B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002f4u, ImmutableString("textureGradOffset(00Z20B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002f5u, ImmutableString("textureGradOffset(00e30B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002f6u,
              ImmutableString("textureProjGradOffset(00H20B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002f7u,
              ImmutableString("textureProjGradOffset(00Q20B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002f8u,
              ImmutableString("textureProjGradOffset(00W20B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002f9u,
              ImmutableString("textureProjGradOffset(00H30B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002fau,
              ImmutableString("textureProjGradOffset(00Q30B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002fbu,
              ImmutableString("textureProjGradOffset(00W30B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x000002fcu,
              ImmutableString("textureProjGradOffset(00I30B20B20B20C").mangledNameHash());
    ASSERT_EQ(0x000002fdu,
              ImmutableString("textureProjGradOffset(00R30B20B20B20C").mangledNameHash());
    ASSERT_EQ(0x000002feu,
              ImmutableString("textureProjGradOffset(00X30B20B20B20C").mangledNameHash());
    ASSERT_EQ(0x000002ffu,
              ImmutableString("textureProjGradOffset(00c30B10B10B10C").mangledNameHash());
    ASSERT_EQ(0x00000300u, ImmutableString("textureOffset(00H10B10C00B").mangledNameHash());
    ASSERT_EQ(0x00000301u, ImmutableString("textureOffset(00Q10B10C00B").mangledNameHash());
    ASSERT_EQ(0x00000302u, ImmutableString("textureOffset(00W10B10C00B").mangledNameHash());
    ASSERT_EQ(0x00000303u, ImmutableString("textureOffset(00I20B20C00B").mangledNameHash());
    ASSERT_EQ(0x00000304u, ImmutableString("textureOffset(00R20B20C00B").mangledNameHash());
    ASSERT_EQ(0x00000305u, ImmutableString("textureOffset(00X20B20C00B").mangledNameHash());
    ASSERT_EQ(0x00000306u, ImmutableString("textureOffset(00c20B10C00B").mangledNameHash());
    ASSERT_EQ(0x00000307u, ImmutableString("textureOffset(00K20B10C00B").mangledNameHash());
    ASSERT_EQ(0x00000308u, ImmutableString("textureOffset(00T20B10C00B").mangledNameHash());
    ASSERT_EQ(0x00000309u, ImmutableString("textureOffset(00Z20B10C00B").mangledNameHash());
    ASSERT_EQ(0x0000030au, ImmutableString("textureOffset(00e30B10C00B").mangledNameHash());
    ASSERT_EQ(0x0000030bu, ImmutableString("textureProjOffset(00H20B10C00B").mangledNameHash());
    ASSERT_EQ(0x0000030cu, ImmutableString("textureProjOffset(00Q20B10C00B").mangledNameHash());
    ASSERT_EQ(0x0000030du, ImmutableString("textureProjOffset(00W20B10C00B").mangledNameHash());
    ASSERT_EQ(0x0000030eu, ImmutableString("textureProjOffset(00H30B10C00B").mangledNameHash());
    ASSERT_EQ(0x0000030fu, ImmutableString("textureProjOffset(00Q30B10C00B").mangledNameHash());
    ASSERT_EQ(0x00000310u, ImmutableString("textureProjOffset(00W30B10C00B").mangledNameHash());
    ASSERT_EQ(0x00000311u, ImmutableString("textureProjOffset(00I30B20C00B").mangledNameHash());
    ASSERT_EQ(0x00000312u, ImmutableString("textureProjOffset(00R30B20C00B").mangledNameHash());
    ASSERT_EQ(0x00000313u, ImmutableString("textureProjOffset(00X30B20C00B").mangledNameHash());
    ASSERT_EQ(0x00000314u, ImmutableString("textureProjOffset(00c30B10C00B").mangledNameHash());
    ASSERT_EQ(0x00000315u, ImmutableString("textureGather(00H10B").mangledNameHash());
    ASSERT_EQ(0x00000316u, ImmutableString("textureGather(00Q10B").mangledNameHash());
    ASSERT_EQ(0x00000317u, ImmutableString("textureGather(00W10B").mangledNameHash());
    ASSERT_EQ(0x00000318u, ImmutableString("textureGather(00K20B").mangledNameHash());
    ASSERT_EQ(0x00000319u, ImmutableString("textureGather(00T20B").mangledNameHash());
    ASSERT_EQ(0x0000031au, ImmutableString("textureGather(00Z20B").mangledNameHash());
    ASSERT_EQ(0x0000031bu, ImmutableString("textureGather(00J20B").mangledNameHash());
    ASSERT_EQ(0x0000031cu, ImmutableString("textureGather(00S20B").mangledNameHash());
    ASSERT_EQ(0x0000031du, ImmutableString("textureGather(00Y20B").mangledNameHash());
    ASSERT_EQ(0x0000031eu, ImmutableString("textureGather(00g30B").mangledNameHash());
    ASSERT_EQ(0x0000031fu, ImmutableString("textureGather(00k30B").mangledNameHash());
    ASSERT_EQ(0x00000320u, ImmutableString("textureGather(00n30B").mangledNameHash());
    ASSERT_EQ(0x00000321u, ImmutableString("textureGather(00H10B00C").mangledNameHash());
    ASSERT_EQ(0x00000322u, ImmutableString("textureGather(00Q10B00C").mangledNameHash());
    ASSERT_EQ(0x00000323u, ImmutableString("textureGather(00W10B00C").mangledNameHash());
    ASSERT_EQ(0x00000324u, ImmutableString("textureGather(00K20B00C").mangledNameHash());
    ASSERT_EQ(0x00000325u, ImmutableString("textureGather(00T20B00C").mangledNameHash());
    ASSERT_EQ(0x00000326u, ImmutableString("textureGather(00Z20B00C").mangledNameHash());
    ASSERT_EQ(0x00000327u, ImmutableString("textureGather(00J20B00C").mangledNameHash());
    ASSERT_EQ(0x00000328u, ImmutableString("textureGather(00S20B00C").mangledNameHash());
    ASSERT_EQ(0x00000329u, ImmutableString("textureGather(00Y20B00C").mangledNameHash());
    ASSERT_EQ(0x0000032au, ImmutableString("textureGather(00g30B00C").mangledNameHash());
    ASSERT_EQ(0x0000032bu, ImmutableString("textureGather(00k30B00C").mangledNameHash());
    ASSERT_EQ(0x0000032cu, ImmutableString("textureGather(00n30B00C").mangledNameHash());
    ASSERT_EQ(0x0000032du, ImmutableString("textureGather(00h30B00B").mangledNameHash());
    ASSERT_EQ(0x0000032eu, ImmutableString("textureGather(00c10B00B").mangledNameHash());
    ASSERT_EQ(0x0000032fu, ImmutableString("textureGather(00e20B00B").mangledNameHash());
    ASSERT_EQ(0x00000330u, ImmutableString("textureGather(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x00000331u, ImmutableString("textureGatherOffset(00H10B10C").mangledNameHash());
    ASSERT_EQ(0x00000332u, ImmutableString("textureGatherOffset(00Q10B10C").mangledNameHash());
    ASSERT_EQ(0x00000333u, ImmutableString("textureGatherOffset(00W10B10C").mangledNameHash());
    ASSERT_EQ(0x00000334u, ImmutableString("textureGatherOffset(00K20B10C").mangledNameHash());
    ASSERT_EQ(0x00000335u, ImmutableString("textureGatherOffset(00T20B10C").mangledNameHash());
    ASSERT_EQ(0x00000336u, ImmutableString("textureGatherOffset(00Z20B10C").mangledNameHash());
    ASSERT_EQ(0x00000337u, ImmutableString("textureGatherOffset(00H10B10C00C").mangledNameHash());
    ASSERT_EQ(0x00000338u, ImmutableString("textureGatherOffset(00Q10B10C00C").mangledNameHash());
    ASSERT_EQ(0x00000339u, ImmutableString("textureGatherOffset(00W10B10C00C").mangledNameHash());
    ASSERT_EQ(0x0000033au, ImmutableString("textureGatherOffset(00K20B10C00C").mangledNameHash());
    ASSERT_EQ(0x0000033bu, ImmutableString("textureGatherOffset(00T20B10C00C").mangledNameHash());
    ASSERT_EQ(0x0000033cu, ImmutableString("textureGatherOffset(00Z20B10C00C").mangledNameHash());
    ASSERT_EQ(0x0000033du, ImmutableString("textureGatherOffset(00c10B00B10C").mangledNameHash());
    ASSERT_EQ(0x0000033eu, ImmutableString("textureGatherOffset(00e20B00B10C").mangledNameHash());
    ASSERT_EQ(0x0000033fu, ImmutableString("textureGatherOffsets(00H10B10Cx4").mangledNameHash());
    ASSERT_EQ(0x00000340u, ImmutableString("textureGatherOffsets(00Q10B10Cx4").mangledNameHash());
    ASSERT_EQ(0x00000341u, ImmutableString("textureGatherOffsets(00W10B10Cx4").mangledNameHash());
    ASSERT_EQ(0x00000342u, ImmutableString("textureGatherOffsets(00K20B10Cx4").mangledNameHash());
    ASSERT_EQ(0x00000343u, ImmutableString("textureGatherOffsets(00T20B10Cx4").mangledNameHash());
    ASSERT_EQ(0x00000344u, ImmutableString("textureGatherOffsets(00Z20B10Cx4").mangledNameHash());
    ASSERT_EQ(0x00000345u,
              ImmutableString("textureGatherOffsets(00H10B10Cx400C").mangledNameHash());
    ASSERT_EQ(0x00000346u,
              ImmutableString("textureGatherOffsets(00Q10B10Cx400C").mangledNameHash());
    ASSERT_EQ(0x00000347u,
              ImmutableString("textureGatherOffsets(00W10B10Cx400C").mangledNameHash());
    ASSERT_EQ(0x00000348u,
              ImmutableString("textureGatherOffsets(00K20B10Cx400C").mangledNameHash());
    ASSERT_EQ(0x00000349u,
              ImmutableString("textureGatherOffsets(00T20B10Cx400C").mangledNameHash());
    ASSERT_EQ(0x0000034au,
              ImmutableString("textureGatherOffsets(00Z20B10Cx400C").mangledNameHash());
    ASSERT_EQ(0x0000034bu,
              ImmutableString("textureGatherOffsets(00c10B00B10Cx4").mangledNameHash());
    ASSERT_EQ(0x0000034cu,
              ImmutableString("textureGatherOffsets(00e20B00B10Cx4").mangledNameHash());
    ASSERT_EQ(0x0000034du, ImmutableString("textureQueryLOD(00H10B").mangledNameHash());
    ASSERT_EQ(0x0000034eu, ImmutableString("textureQueryLOD(00Q10B").mangledNameHash());
    ASSERT_EQ(0x0000034fu, ImmutableString("textureQueryLOD(00W10B").mangledNameHash());
    ASSERT_EQ(0x00000350u, ImmutableString("textureQueryLOD(00I20B").mangledNameHash());
    ASSERT_EQ(0x00000351u, ImmutableString("textureQueryLOD(00R20B").mangledNameHash());
    ASSERT_EQ(0x00000352u, ImmutableString("textureQueryLOD(00X20B").mangledNameHash());
    ASSERT_EQ(0x00000353u, ImmutableString("textureQueryLOD(00J20B").mangledNameHash());
    ASSERT_EQ(0x00000354u, ImmutableString("textureQueryLOD(00S20B").mangledNameHash());
    ASSERT_EQ(0x00000355u, ImmutableString("textureQueryLOD(00Y20B").mangledNameHash());
    ASSERT_EQ(0x00000356u, ImmutableString("textureQueryLOD(00K10B").mangledNameHash());
    ASSERT_EQ(0x00000357u, ImmutableString("textureQueryLOD(00T10B").mangledNameHash());
    ASSERT_EQ(0x00000358u, ImmutableString("textureQueryLOD(00Z10B").mangledNameHash());
    ASSERT_EQ(0x00000359u, ImmutableString("textureQueryLOD(00c10B").mangledNameHash());
    ASSERT_EQ(0x0000035au, ImmutableString("textureQueryLOD(00d20B").mangledNameHash());
    ASSERT_EQ(0x0000035bu, ImmutableString("textureQueryLOD(00e10B").mangledNameHash());
    ASSERT_EQ(0x0000035cu, ImmutableString("textureQueryLOD(00g20B").mangledNameHash());
    ASSERT_EQ(0x0000035du, ImmutableString("textureQueryLOD(00k20B").mangledNameHash());
    ASSERT_EQ(0x0000035eu, ImmutableString("textureQueryLOD(00n20B").mangledNameHash());
    ASSERT_EQ(0x0000035fu, ImmutableString("textureQueryLOD(00h20B").mangledNameHash());
    ASSERT_EQ(0x00000360u, ImmutableString("rgb_2_yuv(20B00G").mangledNameHash());
    ASSERT_EQ(0x00000361u, ImmutableString("yuv_2_rgb(20B00G").mangledNameHash());
    ASSERT_EQ(0x00000362u, ImmutableString("dFdx(00B").mangledNameHash());
    ASSERT_EQ(0x00000363u, ImmutableString("dFdx(10B").mangledNameHash());
    ASSERT_EQ(0x00000364u, ImmutableString("dFdx(20B").mangledNameHash());
    ASSERT_EQ(0x00000365u, ImmutableString("dFdx(30B").mangledNameHash());
    ASSERT_EQ(0x00000366u, ImmutableString("dFdy(00B").mangledNameHash());
    ASSERT_EQ(0x00000367u, ImmutableString("dFdy(10B").mangledNameHash());
    ASSERT_EQ(0x00000368u, ImmutableString("dFdy(20B").mangledNameHash());
    ASSERT_EQ(0x00000369u, ImmutableString("dFdy(30B").mangledNameHash());
    ASSERT_EQ(0x0000036au, ImmutableString("fwidth(00B").mangledNameHash());
    ASSERT_EQ(0x0000036bu, ImmutableString("fwidth(10B").mangledNameHash());
    ASSERT_EQ(0x0000036cu, ImmutableString("fwidth(20B").mangledNameHash());
    ASSERT_EQ(0x0000036du, ImmutableString("fwidth(30B").mangledNameHash());
    ASSERT_EQ(0x0000036eu, ImmutableString("interpolateAtCentroid(00B").mangledNameHash());
    ASSERT_EQ(0x0000036fu, ImmutableString("interpolateAtCentroid(10B").mangledNameHash());
    ASSERT_EQ(0x00000370u, ImmutableString("interpolateAtCentroid(20B").mangledNameHash());
    ASSERT_EQ(0x00000371u, ImmutableString("interpolateAtCentroid(30B").mangledNameHash());
    ASSERT_EQ(0x00000372u, ImmutableString("interpolateAtSample(00B00C").mangledNameHash());
    ASSERT_EQ(0x00000373u, ImmutableString("interpolateAtSample(10B00C").mangledNameHash());
    ASSERT_EQ(0x00000374u, ImmutableString("interpolateAtSample(20B00C").mangledNameHash());
    ASSERT_EQ(0x00000375u, ImmutableString("interpolateAtSample(30B00C").mangledNameHash());
    ASSERT_EQ(0x00000376u, ImmutableString("interpolateAtOffset(00B10B").mangledNameHash());
    ASSERT_EQ(0x00000377u, ImmutableString("interpolateAtOffset(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000378u, ImmutableString("interpolateAtOffset(20B10B").mangledNameHash());
    ASSERT_EQ(0x00000379u, ImmutableString("interpolateAtOffset(30B10B").mangledNameHash());
    ASSERT_EQ(0x0000037au, ImmutableString("atomicCounter(00F").mangledNameHash());
    ASSERT_EQ(0x0000037bu, ImmutableString("atomicCounterIncrement(00F").mangledNameHash());
    ASSERT_EQ(0x0000037cu, ImmutableString("atomicCounterDecrement(00F").mangledNameHash());
    ASSERT_EQ(0x0000037du, ImmutableString("atomicAdd(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000037eu, ImmutableString("atomicAdd(00C00C").mangledNameHash());
    ASSERT_EQ(0x0000037fu, ImmutableString("atomicMin(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000380u, ImmutableString("atomicMin(00C00C").mangledNameHash());
    ASSERT_EQ(0x00000381u, ImmutableString("atomicMax(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000382u, ImmutableString("atomicMax(00C00C").mangledNameHash());
    ASSERT_EQ(0x00000383u, ImmutableString("atomicAnd(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000384u, ImmutableString("atomicAnd(00C00C").mangledNameHash());
    ASSERT_EQ(0x00000385u, ImmutableString("atomicOr(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000386u, ImmutableString("atomicOr(00C00C").mangledNameHash());
    ASSERT_EQ(0x00000387u, ImmutableString("atomicXor(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000388u, ImmutableString("atomicXor(00C00C").mangledNameHash());
    ASSERT_EQ(0x00000389u, ImmutableString("atomicExchange(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000038au, ImmutableString("atomicExchange(00C00C").mangledNameHash());
    ASSERT_EQ(0x0000038bu, ImmutableString("atomicCompSwap(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000038cu, ImmutableString("atomicCompSwap(00C00C00C").mangledNameHash());
    ASSERT_EQ(0x0000038du, ImmutableString("imageSize(00p").mangledNameHash());
    ASSERT_EQ(0x0000038eu, ImmutableString("imageSize(00y").mangledNameHash());
    ASSERT_EQ(0x0000038fu, ImmutableString("imageSize(01H").mangledNameHash());
    ASSERT_EQ(0x00000390u, ImmutableString("imageSize(00q").mangledNameHash());
    ASSERT_EQ(0x00000391u, ImmutableString("imageSize(00z").mangledNameHash());
    ASSERT_EQ(0x00000392u, ImmutableString("imageSize(01I").mangledNameHash());
    ASSERT_EQ(0x00000393u, ImmutableString("imageSize(00r").mangledNameHash());
    ASSERT_EQ(0x00000394u, ImmutableString("imageSize(01A").mangledNameHash());
    ASSERT_EQ(0x00000395u, ImmutableString("imageSize(01J").mangledNameHash());
    ASSERT_EQ(0x00000396u, ImmutableString("imageSize(00s").mangledNameHash());
    ASSERT_EQ(0x00000397u, ImmutableString("imageSize(01B").mangledNameHash());
    ASSERT_EQ(0x00000398u, ImmutableString("imageSize(01K").mangledNameHash());
    ASSERT_EQ(0x00000399u, ImmutableString("imageSize(00v").mangledNameHash());
    ASSERT_EQ(0x0000039au, ImmutableString("imageSize(01E").mangledNameHash());
    ASSERT_EQ(0x0000039bu, ImmutableString("imageSize(01N").mangledNameHash());
    ASSERT_EQ(0x0000039cu, ImmutableString("imageSize(00x").mangledNameHash());
    ASSERT_EQ(0x0000039du, ImmutableString("imageSize(01G").mangledNameHash());
    ASSERT_EQ(0x0000039eu, ImmutableString("imageSize(01P").mangledNameHash());
    ASSERT_EQ(0x0000039fu, ImmutableString("imageStore(00p10C30B").mangledNameHash());
    ASSERT_EQ(0x000003a0u, ImmutableString("imageStore(00y10C30C").mangledNameHash());
    ASSERT_EQ(0x000003a1u, ImmutableString("imageStore(01H10C30D").mangledNameHash());
    ASSERT_EQ(0x000003a2u, ImmutableString("imageStore(00q20C30B").mangledNameHash());
    ASSERT_EQ(0x000003a3u, ImmutableString("imageStore(00z20C30C").mangledNameHash());
    ASSERT_EQ(0x000003a4u, ImmutableString("imageStore(01I20C30D").mangledNameHash());
    ASSERT_EQ(0x000003a5u, ImmutableString("imageStore(00r20C30B").mangledNameHash());
    ASSERT_EQ(0x000003a6u, ImmutableString("imageStore(01A20C30C").mangledNameHash());
    ASSERT_EQ(0x000003a7u, ImmutableString("imageStore(01J20C30D").mangledNameHash());
    ASSERT_EQ(0x000003a8u, ImmutableString("imageStore(00s20C30B").mangledNameHash());
    ASSERT_EQ(0x000003a9u, ImmutableString("imageStore(01B20C30C").mangledNameHash());
    ASSERT_EQ(0x000003aau, ImmutableString("imageStore(01K20C30D").mangledNameHash());
    ASSERT_EQ(0x000003abu, ImmutableString("imageStore(00v20C30B").mangledNameHash());
    ASSERT_EQ(0x000003acu, ImmutableString("imageStore(01E20C30C").mangledNameHash());
    ASSERT_EQ(0x000003adu, ImmutableString("imageStore(01N20C30D").mangledNameHash());
    ASSERT_EQ(0x000003aeu, ImmutableString("imageStore(00x00C30B").mangledNameHash());
    ASSERT_EQ(0x000003afu, ImmutableString("imageStore(01G00C30C").mangledNameHash());
    ASSERT_EQ(0x000003b0u, ImmutableString("imageStore(01P00C30D").mangledNameHash());
    ASSERT_EQ(0x000003b1u, ImmutableString("imageLoad(00p10C").mangledNameHash());
    ASSERT_EQ(0x000003b2u, ImmutableString("imageLoad(00y10C").mangledNameHash());
    ASSERT_EQ(0x000003b3u, ImmutableString("imageLoad(01H10C").mangledNameHash());
    ASSERT_EQ(0x000003b4u, ImmutableString("imageLoad(00q20C").mangledNameHash());
    ASSERT_EQ(0x000003b5u, ImmutableString("imageLoad(00z20C").mangledNameHash());
    ASSERT_EQ(0x000003b6u, ImmutableString("imageLoad(01I20C").mangledNameHash());
    ASSERT_EQ(0x000003b7u, ImmutableString("imageLoad(00r20C").mangledNameHash());
    ASSERT_EQ(0x000003b8u, ImmutableString("imageLoad(01A20C").mangledNameHash());
    ASSERT_EQ(0x000003b9u, ImmutableString("imageLoad(01J20C").mangledNameHash());
    ASSERT_EQ(0x000003bau, ImmutableString("imageLoad(00s20C").mangledNameHash());
    ASSERT_EQ(0x000003bbu, ImmutableString("imageLoad(01B20C").mangledNameHash());
    ASSERT_EQ(0x000003bcu, ImmutableString("imageLoad(01K20C").mangledNameHash());
    ASSERT_EQ(0x000003bdu, ImmutableString("imageLoad(00v20C").mangledNameHash());
    ASSERT_EQ(0x000003beu, ImmutableString("imageLoad(01E20C").mangledNameHash());
    ASSERT_EQ(0x000003bfu, ImmutableString("imageLoad(01N20C").mangledNameHash());
    ASSERT_EQ(0x000003c0u, ImmutableString("imageLoad(00x00C").mangledNameHash());
    ASSERT_EQ(0x000003c1u, ImmutableString("imageLoad(01G00C").mangledNameHash());
    ASSERT_EQ(0x000003c2u, ImmutableString("imageLoad(01P00C").mangledNameHash());
    ASSERT_EQ(0x000003c3u, ImmutableString("imageAtomicAdd(00p10C00D").mangledNameHash());
    ASSERT_EQ(0x000003c4u, ImmutableString("imageAtomicAdd(00y10C00D").mangledNameHash());
    ASSERT_EQ(0x000003c5u, ImmutableString("imageAtomicAdd(01H10C00D").mangledNameHash());
    ASSERT_EQ(0x000003c6u, ImmutableString("imageAtomicAdd(00q20C00D").mangledNameHash());
    ASSERT_EQ(0x000003c7u, ImmutableString("imageAtomicAdd(00z20C00D").mangledNameHash());
    ASSERT_EQ(0x000003c8u, ImmutableString("imageAtomicAdd(01I20C00D").mangledNameHash());
    ASSERT_EQ(0x000003c9u, ImmutableString("imageAtomicAdd(00s20C00D").mangledNameHash());
    ASSERT_EQ(0x000003cau, ImmutableString("imageAtomicAdd(01B20C00D").mangledNameHash());
    ASSERT_EQ(0x000003cbu, ImmutableString("imageAtomicAdd(01K20C00D").mangledNameHash());
    ASSERT_EQ(0x000003ccu, ImmutableString("imageAtomicAdd(00x00C00D").mangledNameHash());
    ASSERT_EQ(0x000003cdu, ImmutableString("imageAtomicAdd(01G00C00D").mangledNameHash());
    ASSERT_EQ(0x000003ceu, ImmutableString("imageAtomicAdd(01P00C00D").mangledNameHash());
    ASSERT_EQ(0x000003cfu, ImmutableString("imageAtomicAdd(00r20C00D").mangledNameHash());
    ASSERT_EQ(0x000003d0u, ImmutableString("imageAtomicAdd(01A20C00D").mangledNameHash());
    ASSERT_EQ(0x000003d1u, ImmutableString("imageAtomicAdd(01J20C00D").mangledNameHash());
    ASSERT_EQ(0x000003d2u, ImmutableString("imageAtomicAdd(00v20C00D").mangledNameHash());
    ASSERT_EQ(0x000003d3u, ImmutableString("imageAtomicAdd(01E20C00D").mangledNameHash());
    ASSERT_EQ(0x000003d4u, ImmutableString("imageAtomicAdd(01N20C00D").mangledNameHash());
    ASSERT_EQ(0x000003d5u, ImmutableString("imageAtomicAdd(00p10C00C").mangledNameHash());
    ASSERT_EQ(0x000003d6u, ImmutableString("imageAtomicAdd(00y10C00C").mangledNameHash());
    ASSERT_EQ(0x000003d7u, ImmutableString("imageAtomicAdd(01H10C00C").mangledNameHash());
    ASSERT_EQ(0x000003d8u, ImmutableString("imageAtomicAdd(00q20C00C").mangledNameHash());
    ASSERT_EQ(0x000003d9u, ImmutableString("imageAtomicAdd(00z20C00C").mangledNameHash());
    ASSERT_EQ(0x000003dau, ImmutableString("imageAtomicAdd(01I20C00C").mangledNameHash());
    ASSERT_EQ(0x000003dbu, ImmutableString("imageAtomicAdd(00s20C00C").mangledNameHash());
    ASSERT_EQ(0x000003dcu, ImmutableString("imageAtomicAdd(01B20C00C").mangledNameHash());
    ASSERT_EQ(0x000003ddu, ImmutableString("imageAtomicAdd(01K20C00C").mangledNameHash());
    ASSERT_EQ(0x000003deu, ImmutableString("imageAtomicAdd(00x00C00C").mangledNameHash());
    ASSERT_EQ(0x000003dfu, ImmutableString("imageAtomicAdd(01G00C00C").mangledNameHash());
    ASSERT_EQ(0x000003e0u, ImmutableString("imageAtomicAdd(01P00C00C").mangledNameHash());
    ASSERT_EQ(0x000003e1u, ImmutableString("imageAtomicAdd(00r20C00C").mangledNameHash());
    ASSERT_EQ(0x000003e2u, ImmutableString("imageAtomicAdd(01A20C00C").mangledNameHash());
    ASSERT_EQ(0x000003e3u, ImmutableString("imageAtomicAdd(01J20C00C").mangledNameHash());
    ASSERT_EQ(0x000003e4u, ImmutableString("imageAtomicAdd(00v20C00C").mangledNameHash());
    ASSERT_EQ(0x000003e5u, ImmutableString("imageAtomicAdd(01E20C00C").mangledNameHash());
    ASSERT_EQ(0x000003e6u, ImmutableString("imageAtomicAdd(01N20C00C").mangledNameHash());
    ASSERT_EQ(0x000003e7u, ImmutableString("imageAtomicMin(00p10C00D").mangledNameHash());
    ASSERT_EQ(0x000003e8u, ImmutableString("imageAtomicMin(00y10C00D").mangledNameHash());
    ASSERT_EQ(0x000003e9u, ImmutableString("imageAtomicMin(01H10C00D").mangledNameHash());
    ASSERT_EQ(0x000003eau, ImmutableString("imageAtomicMin(00q20C00D").mangledNameHash());
    ASSERT_EQ(0x000003ebu, ImmutableString("imageAtomicMin(00z20C00D").mangledNameHash());
    ASSERT_EQ(0x000003ecu, ImmutableString("imageAtomicMin(01I20C00D").mangledNameHash());
    ASSERT_EQ(0x000003edu, ImmutableString("imageAtomicMin(00s20C00D").mangledNameHash());
    ASSERT_EQ(0x000003eeu, ImmutableString("imageAtomicMin(01B20C00D").mangledNameHash());
    ASSERT_EQ(0x000003efu, ImmutableString("imageAtomicMin(01K20C00D").mangledNameHash());
    ASSERT_EQ(0x000003f0u, ImmutableString("imageAtomicMin(00x00C00D").mangledNameHash());
    ASSERT_EQ(0x000003f1u, ImmutableString("imageAtomicMin(01G00C00D").mangledNameHash());
    ASSERT_EQ(0x000003f2u, ImmutableString("imageAtomicMin(01P00C00D").mangledNameHash());
    ASSERT_EQ(0x000003f3u, ImmutableString("imageAtomicMin(00r20C00D").mangledNameHash());
    ASSERT_EQ(0x000003f4u, ImmutableString("imageAtomicMin(01A20C00D").mangledNameHash());
    ASSERT_EQ(0x000003f5u, ImmutableString("imageAtomicMin(01J20C00D").mangledNameHash());
    ASSERT_EQ(0x000003f6u, ImmutableString("imageAtomicMin(00v20C00D").mangledNameHash());
    ASSERT_EQ(0x000003f7u, ImmutableString("imageAtomicMin(01E20C00D").mangledNameHash());
    ASSERT_EQ(0x000003f8u, ImmutableString("imageAtomicMin(01N20C00D").mangledNameHash());
    ASSERT_EQ(0x000003f9u, ImmutableString("imageAtomicMin(00p10C00C").mangledNameHash());
    ASSERT_EQ(0x000003fau, ImmutableString("imageAtomicMin(00y10C00C").mangledNameHash());
    ASSERT_EQ(0x000003fbu, ImmutableString("imageAtomicMin(01H10C00C").mangledNameHash());
    ASSERT_EQ(0x000003fcu, ImmutableString("imageAtomicMin(00q20C00C").mangledNameHash());
    ASSERT_EQ(0x000003fdu, ImmutableString("imageAtomicMin(00z20C00C").mangledNameHash());
    ASSERT_EQ(0x000003feu, ImmutableString("imageAtomicMin(01I20C00C").mangledNameHash());
    ASSERT_EQ(0x000003ffu, ImmutableString("imageAtomicMin(00s20C00C").mangledNameHash());
    ASSERT_EQ(0x00000400u, ImmutableString("imageAtomicMin(01B20C00C").mangledNameHash());
    ASSERT_EQ(0x00000401u, ImmutableString("imageAtomicMin(01K20C00C").mangledNameHash());
    ASSERT_EQ(0x00000402u, ImmutableString("imageAtomicMin(00x00C00C").mangledNameHash());
    ASSERT_EQ(0x00000403u, ImmutableString("imageAtomicMin(01G00C00C").mangledNameHash());
    ASSERT_EQ(0x00000404u, ImmutableString("imageAtomicMin(01P00C00C").mangledNameHash());
    ASSERT_EQ(0x00000405u, ImmutableString("imageAtomicMin(00r20C00C").mangledNameHash());
    ASSERT_EQ(0x00000406u, ImmutableString("imageAtomicMin(01A20C00C").mangledNameHash());
    ASSERT_EQ(0x00000407u, ImmutableString("imageAtomicMin(01J20C00C").mangledNameHash());
    ASSERT_EQ(0x00000408u, ImmutableString("imageAtomicMin(00v20C00C").mangledNameHash());
    ASSERT_EQ(0x00000409u, ImmutableString("imageAtomicMin(01E20C00C").mangledNameHash());
    ASSERT_EQ(0x0000040au, ImmutableString("imageAtomicMin(01N20C00C").mangledNameHash());
    ASSERT_EQ(0x0000040bu, ImmutableString("imageAtomicMax(00p10C00D").mangledNameHash());
    ASSERT_EQ(0x0000040cu, ImmutableString("imageAtomicMax(00y10C00D").mangledNameHash());
    ASSERT_EQ(0x0000040du, ImmutableString("imageAtomicMax(01H10C00D").mangledNameHash());
    ASSERT_EQ(0x0000040eu, ImmutableString("imageAtomicMax(00q20C00D").mangledNameHash());
    ASSERT_EQ(0x0000040fu, ImmutableString("imageAtomicMax(00z20C00D").mangledNameHash());
    ASSERT_EQ(0x00000410u, ImmutableString("imageAtomicMax(01I20C00D").mangledNameHash());
    ASSERT_EQ(0x00000411u, ImmutableString("imageAtomicMax(00s20C00D").mangledNameHash());
    ASSERT_EQ(0x00000412u, ImmutableString("imageAtomicMax(01B20C00D").mangledNameHash());
    ASSERT_EQ(0x00000413u, ImmutableString("imageAtomicMax(01K20C00D").mangledNameHash());
    ASSERT_EQ(0x00000414u, ImmutableString("imageAtomicMax(00x00C00D").mangledNameHash());
    ASSERT_EQ(0x00000415u, ImmutableString("imageAtomicMax(01G00C00D").mangledNameHash());
    ASSERT_EQ(0x00000416u, ImmutableString("imageAtomicMax(01P00C00D").mangledNameHash());
    ASSERT_EQ(0x00000417u, ImmutableString("imageAtomicMax(00r20C00D").mangledNameHash());
    ASSERT_EQ(0x00000418u, ImmutableString("imageAtomicMax(01A20C00D").mangledNameHash());
    ASSERT_EQ(0x00000419u, ImmutableString("imageAtomicMax(01J20C00D").mangledNameHash());
    ASSERT_EQ(0x0000041au, ImmutableString("imageAtomicMax(00v20C00D").mangledNameHash());
    ASSERT_EQ(0x0000041bu, ImmutableString("imageAtomicMax(01E20C00D").mangledNameHash());
    ASSERT_EQ(0x0000041cu, ImmutableString("imageAtomicMax(01N20C00D").mangledNameHash());
    ASSERT_EQ(0x0000041du, ImmutableString("imageAtomicMax(00p10C00C").mangledNameHash());
    ASSERT_EQ(0x0000041eu, ImmutableString("imageAtomicMax(00y10C00C").mangledNameHash());
    ASSERT_EQ(0x0000041fu, ImmutableString("imageAtomicMax(01H10C00C").mangledNameHash());
    ASSERT_EQ(0x00000420u, ImmutableString("imageAtomicMax(00q20C00C").mangledNameHash());
    ASSERT_EQ(0x00000421u, ImmutableString("imageAtomicMax(00z20C00C").mangledNameHash());
    ASSERT_EQ(0x00000422u, ImmutableString("imageAtomicMax(01I20C00C").mangledNameHash());
    ASSERT_EQ(0x00000423u, ImmutableString("imageAtomicMax(00s20C00C").mangledNameHash());
    ASSERT_EQ(0x00000424u, ImmutableString("imageAtomicMax(01B20C00C").mangledNameHash());
    ASSERT_EQ(0x00000425u, ImmutableString("imageAtomicMax(01K20C00C").mangledNameHash());
    ASSERT_EQ(0x00000426u, ImmutableString("imageAtomicMax(00x00C00C").mangledNameHash());
    ASSERT_EQ(0x00000427u, ImmutableString("imageAtomicMax(01G00C00C").mangledNameHash());
    ASSERT_EQ(0x00000428u, ImmutableString("imageAtomicMax(01P00C00C").mangledNameHash());
    ASSERT_EQ(0x00000429u, ImmutableString("imageAtomicMax(00r20C00C").mangledNameHash());
    ASSERT_EQ(0x0000042au, ImmutableString("imageAtomicMax(01A20C00C").mangledNameHash());
    ASSERT_EQ(0x0000042bu, ImmutableString("imageAtomicMax(01J20C00C").mangledNameHash());
    ASSERT_EQ(0x0000042cu, ImmutableString("imageAtomicMax(00v20C00C").mangledNameHash());
    ASSERT_EQ(0x0000042du, ImmutableString("imageAtomicMax(01E20C00C").mangledNameHash());
    ASSERT_EQ(0x0000042eu, ImmutableString("imageAtomicMax(01N20C00C").mangledNameHash());
    ASSERT_EQ(0x0000042fu, ImmutableString("imageAtomicAnd(00p10C00D").mangledNameHash());
    ASSERT_EQ(0x00000430u, ImmutableString("imageAtomicAnd(00y10C00D").mangledNameHash());
    ASSERT_EQ(0x00000431u, ImmutableString("imageAtomicAnd(01H10C00D").mangledNameHash());
    ASSERT_EQ(0x00000432u, ImmutableString("imageAtomicAnd(00q20C00D").mangledNameHash());
    ASSERT_EQ(0x00000433u, ImmutableString("imageAtomicAnd(00z20C00D").mangledNameHash());
    ASSERT_EQ(0x00000434u, ImmutableString("imageAtomicAnd(01I20C00D").mangledNameHash());
    ASSERT_EQ(0x00000435u, ImmutableString("imageAtomicAnd(00s20C00D").mangledNameHash());
    ASSERT_EQ(0x00000436u, ImmutableString("imageAtomicAnd(01B20C00D").mangledNameHash());
    ASSERT_EQ(0x00000437u, ImmutableString("imageAtomicAnd(01K20C00D").mangledNameHash());
    ASSERT_EQ(0x00000438u, ImmutableString("imageAtomicAnd(00x00C00D").mangledNameHash());
    ASSERT_EQ(0x00000439u, ImmutableString("imageAtomicAnd(01G00C00D").mangledNameHash());
    ASSERT_EQ(0x0000043au, ImmutableString("imageAtomicAnd(01P00C00D").mangledNameHash());
    ASSERT_EQ(0x0000043bu, ImmutableString("imageAtomicAnd(00r20C00D").mangledNameHash());
    ASSERT_EQ(0x0000043cu, ImmutableString("imageAtomicAnd(01A20C00D").mangledNameHash());
    ASSERT_EQ(0x0000043du, ImmutableString("imageAtomicAnd(01J20C00D").mangledNameHash());
    ASSERT_EQ(0x0000043eu, ImmutableString("imageAtomicAnd(00v20C00D").mangledNameHash());
    ASSERT_EQ(0x0000043fu, ImmutableString("imageAtomicAnd(01E20C00D").mangledNameHash());
    ASSERT_EQ(0x00000440u, ImmutableString("imageAtomicAnd(01N20C00D").mangledNameHash());
    ASSERT_EQ(0x00000441u, ImmutableString("imageAtomicAnd(00p10C00C").mangledNameHash());
    ASSERT_EQ(0x00000442u, ImmutableString("imageAtomicAnd(00y10C00C").mangledNameHash());
    ASSERT_EQ(0x00000443u, ImmutableString("imageAtomicAnd(01H10C00C").mangledNameHash());
    ASSERT_EQ(0x00000444u, ImmutableString("imageAtomicAnd(00q20C00C").mangledNameHash());
    ASSERT_EQ(0x00000445u, ImmutableString("imageAtomicAnd(00z20C00C").mangledNameHash());
    ASSERT_EQ(0x00000446u, ImmutableString("imageAtomicAnd(01I20C00C").mangledNameHash());
    ASSERT_EQ(0x00000447u, ImmutableString("imageAtomicAnd(00s20C00C").mangledNameHash());
    ASSERT_EQ(0x00000448u, ImmutableString("imageAtomicAnd(01B20C00C").mangledNameHash());
    ASSERT_EQ(0x00000449u, ImmutableString("imageAtomicAnd(01K20C00C").mangledNameHash());
    ASSERT_EQ(0x0000044au, ImmutableString("imageAtomicAnd(00x00C00C").mangledNameHash());
    ASSERT_EQ(0x0000044bu, ImmutableString("imageAtomicAnd(01G00C00C").mangledNameHash());
    ASSERT_EQ(0x0000044cu, ImmutableString("imageAtomicAnd(01P00C00C").mangledNameHash());
    ASSERT_EQ(0x0000044du, ImmutableString("imageAtomicAnd(00r20C00C").mangledNameHash());
    ASSERT_EQ(0x0000044eu, ImmutableString("imageAtomicAnd(01A20C00C").mangledNameHash());
    ASSERT_EQ(0x0000044fu, ImmutableString("imageAtomicAnd(01J20C00C").mangledNameHash());
    ASSERT_EQ(0x00000450u, ImmutableString("imageAtomicAnd(00v20C00C").mangledNameHash());
    ASSERT_EQ(0x00000451u, ImmutableString("imageAtomicAnd(01E20C00C").mangledNameHash());
    ASSERT_EQ(0x00000452u, ImmutableString("imageAtomicAnd(01N20C00C").mangledNameHash());
    ASSERT_EQ(0x00000453u, ImmutableString("imageAtomicOr(00p10C00D").mangledNameHash());
    ASSERT_EQ(0x00000454u, ImmutableString("imageAtomicOr(00y10C00D").mangledNameHash());
    ASSERT_EQ(0x00000455u, ImmutableString("imageAtomicOr(01H10C00D").mangledNameHash());
    ASSERT_EQ(0x00000456u, ImmutableString("imageAtomicOr(00q20C00D").mangledNameHash());
    ASSERT_EQ(0x00000457u, ImmutableString("imageAtomicOr(00z20C00D").mangledNameHash());
    ASSERT_EQ(0x00000458u, ImmutableString("imageAtomicOr(01I20C00D").mangledNameHash());
    ASSERT_EQ(0x00000459u, ImmutableString("imageAtomicOr(00s20C00D").mangledNameHash());
    ASSERT_EQ(0x0000045au, ImmutableString("imageAtomicOr(01B20C00D").mangledNameHash());
    ASSERT_EQ(0x0000045bu, ImmutableString("imageAtomicOr(01K20C00D").mangledNameHash());
    ASSERT_EQ(0x0000045cu, ImmutableString("imageAtomicOr(00x00C00D").mangledNameHash());
    ASSERT_EQ(0x0000045du, ImmutableString("imageAtomicOr(01G00C00D").mangledNameHash());
    ASSERT_EQ(0x0000045eu, ImmutableString("imageAtomicOr(01P00C00D").mangledNameHash());
    ASSERT_EQ(0x0000045fu, ImmutableString("imageAtomicOr(00r20C00D").mangledNameHash());
    ASSERT_EQ(0x00000460u, ImmutableString("imageAtomicOr(01A20C00D").mangledNameHash());
    ASSERT_EQ(0x00000461u, ImmutableString("imageAtomicOr(01J20C00D").mangledNameHash());
    ASSERT_EQ(0x00000462u, ImmutableString("imageAtomicOr(00v20C00D").mangledNameHash());
    ASSERT_EQ(0x00000463u, ImmutableString("imageAtomicOr(01E20C00D").mangledNameHash());
    ASSERT_EQ(0x00000464u, ImmutableString("imageAtomicOr(01N20C00D").mangledNameHash());
    ASSERT_EQ(0x00000465u, ImmutableString("imageAtomicOr(00p10C00C").mangledNameHash());
    ASSERT_EQ(0x00000466u, ImmutableString("imageAtomicOr(00y10C00C").mangledNameHash());
    ASSERT_EQ(0x00000467u, ImmutableString("imageAtomicOr(01H10C00C").mangledNameHash());
    ASSERT_EQ(0x00000468u, ImmutableString("imageAtomicOr(00q20C00C").mangledNameHash());
    ASSERT_EQ(0x00000469u, ImmutableString("imageAtomicOr(00z20C00C").mangledNameHash());
    ASSERT_EQ(0x0000046au, ImmutableString("imageAtomicOr(01I20C00C").mangledNameHash());
    ASSERT_EQ(0x0000046bu, ImmutableString("imageAtomicOr(00s20C00C").mangledNameHash());
    ASSERT_EQ(0x0000046cu, ImmutableString("imageAtomicOr(01B20C00C").mangledNameHash());
    ASSERT_EQ(0x0000046du, ImmutableString("imageAtomicOr(01K20C00C").mangledNameHash());
    ASSERT_EQ(0x0000046eu, ImmutableString("imageAtomicOr(00x00C00C").mangledNameHash());
    ASSERT_EQ(0x0000046fu, ImmutableString("imageAtomicOr(01G00C00C").mangledNameHash());
    ASSERT_EQ(0x00000470u, ImmutableString("imageAtomicOr(01P00C00C").mangledNameHash());
    ASSERT_EQ(0x00000471u, ImmutableString("imageAtomicOr(00r20C00C").mangledNameHash());
    ASSERT_EQ(0x00000472u, ImmutableString("imageAtomicOr(01A20C00C").mangledNameHash());
    ASSERT_EQ(0x00000473u, ImmutableString("imageAtomicOr(01J20C00C").mangledNameHash());
    ASSERT_EQ(0x00000474u, ImmutableString("imageAtomicOr(00v20C00C").mangledNameHash());
    ASSERT_EQ(0x00000475u, ImmutableString("imageAtomicOr(01E20C00C").mangledNameHash());
    ASSERT_EQ(0x00000476u, ImmutableString("imageAtomicOr(01N20C00C").mangledNameHash());
    ASSERT_EQ(0x00000477u, ImmutableString("imageAtomicXor(00p10C00D").mangledNameHash());
    ASSERT_EQ(0x00000478u, ImmutableString("imageAtomicXor(00y10C00D").mangledNameHash());
    ASSERT_EQ(0x00000479u, ImmutableString("imageAtomicXor(01H10C00D").mangledNameHash());
    ASSERT_EQ(0x0000047au, ImmutableString("imageAtomicXor(00q20C00D").mangledNameHash());
    ASSERT_EQ(0x0000047bu, ImmutableString("imageAtomicXor(00z20C00D").mangledNameHash());
    ASSERT_EQ(0x0000047cu, ImmutableString("imageAtomicXor(01I20C00D").mangledNameHash());
    ASSERT_EQ(0x0000047du, ImmutableString("imageAtomicXor(00s20C00D").mangledNameHash());
    ASSERT_EQ(0x0000047eu, ImmutableString("imageAtomicXor(01B20C00D").mangledNameHash());
    ASSERT_EQ(0x0000047fu, ImmutableString("imageAtomicXor(01K20C00D").mangledNameHash());
    ASSERT_EQ(0x00000480u, ImmutableString("imageAtomicXor(00x00C00D").mangledNameHash());
    ASSERT_EQ(0x00000481u, ImmutableString("imageAtomicXor(01G00C00D").mangledNameHash());
    ASSERT_EQ(0x00000482u, ImmutableString("imageAtomicXor(01P00C00D").mangledNameHash());
    ASSERT_EQ(0x00000483u, ImmutableString("imageAtomicXor(00r20C00D").mangledNameHash());
    ASSERT_EQ(0x00000484u, ImmutableString("imageAtomicXor(01A20C00D").mangledNameHash());
    ASSERT_EQ(0x00000485u, ImmutableString("imageAtomicXor(01J20C00D").mangledNameHash());
    ASSERT_EQ(0x00000486u, ImmutableString("imageAtomicXor(00v20C00D").mangledNameHash());
    ASSERT_EQ(0x00000487u, ImmutableString("imageAtomicXor(01E20C00D").mangledNameHash());
    ASSERT_EQ(0x00000488u, ImmutableString("imageAtomicXor(01N20C00D").mangledNameHash());
    ASSERT_EQ(0x00000489u, ImmutableString("imageAtomicXor(00p10C00C").mangledNameHash());
    ASSERT_EQ(0x0000048au, ImmutableString("imageAtomicXor(00y10C00C").mangledNameHash());
    ASSERT_EQ(0x0000048bu, ImmutableString("imageAtomicXor(01H10C00C").mangledNameHash());
    ASSERT_EQ(0x0000048cu, ImmutableString("imageAtomicXor(00q20C00C").mangledNameHash());
    ASSERT_EQ(0x0000048du, ImmutableString("imageAtomicXor(00z20C00C").mangledNameHash());
    ASSERT_EQ(0x0000048eu, ImmutableString("imageAtomicXor(01I20C00C").mangledNameHash());
    ASSERT_EQ(0x0000048fu, ImmutableString("imageAtomicXor(00s20C00C").mangledNameHash());
    ASSERT_EQ(0x00000490u, ImmutableString("imageAtomicXor(01B20C00C").mangledNameHash());
    ASSERT_EQ(0x00000491u, ImmutableString("imageAtomicXor(01K20C00C").mangledNameHash());
    ASSERT_EQ(0x00000492u, ImmutableString("imageAtomicXor(00x00C00C").mangledNameHash());
    ASSERT_EQ(0x00000493u, ImmutableString("imageAtomicXor(01G00C00C").mangledNameHash());
    ASSERT_EQ(0x00000494u, ImmutableString("imageAtomicXor(01P00C00C").mangledNameHash());
    ASSERT_EQ(0x00000495u, ImmutableString("imageAtomicXor(00r20C00C").mangledNameHash());
    ASSERT_EQ(0x00000496u, ImmutableString("imageAtomicXor(01A20C00C").mangledNameHash());
    ASSERT_EQ(0x00000497u, ImmutableString("imageAtomicXor(01J20C00C").mangledNameHash());
    ASSERT_EQ(0x00000498u, ImmutableString("imageAtomicXor(00v20C00C").mangledNameHash());
    ASSERT_EQ(0x00000499u, ImmutableString("imageAtomicXor(01E20C00C").mangledNameHash());
    ASSERT_EQ(0x0000049au, ImmutableString("imageAtomicXor(01N20C00C").mangledNameHash());
    ASSERT_EQ(0x0000049bu, ImmutableString("imageAtomicExchange(00p10C00D").mangledNameHash());
    ASSERT_EQ(0x0000049cu, ImmutableString("imageAtomicExchange(00y10C00D").mangledNameHash());
    ASSERT_EQ(0x0000049du, ImmutableString("imageAtomicExchange(01H10C00D").mangledNameHash());
    ASSERT_EQ(0x0000049eu, ImmutableString("imageAtomicExchange(00q20C00D").mangledNameHash());
    ASSERT_EQ(0x0000049fu, ImmutableString("imageAtomicExchange(00z20C00D").mangledNameHash());
    ASSERT_EQ(0x000004a0u, ImmutableString("imageAtomicExchange(01I20C00D").mangledNameHash());
    ASSERT_EQ(0x000004a1u, ImmutableString("imageAtomicExchange(00s20C00D").mangledNameHash());
    ASSERT_EQ(0x000004a2u, ImmutableString("imageAtomicExchange(01B20C00D").mangledNameHash());
    ASSERT_EQ(0x000004a3u, ImmutableString("imageAtomicExchange(01K20C00D").mangledNameHash());
    ASSERT_EQ(0x000004a4u, ImmutableString("imageAtomicExchange(00x00C00D").mangledNameHash());
    ASSERT_EQ(0x000004a5u, ImmutableString("imageAtomicExchange(01G00C00D").mangledNameHash());
    ASSERT_EQ(0x000004a6u, ImmutableString("imageAtomicExchange(01P00C00D").mangledNameHash());
    ASSERT_EQ(0x000004a7u, ImmutableString("imageAtomicExchange(00r20C00D").mangledNameHash());
    ASSERT_EQ(0x000004a8u, ImmutableString("imageAtomicExchange(01A20C00D").mangledNameHash());
    ASSERT_EQ(0x000004a9u, ImmutableString("imageAtomicExchange(01J20C00D").mangledNameHash());
    ASSERT_EQ(0x000004aau, ImmutableString("imageAtomicExchange(00v20C00D").mangledNameHash());
    ASSERT_EQ(0x000004abu, ImmutableString("imageAtomicExchange(01E20C00D").mangledNameHash());
    ASSERT_EQ(0x000004acu, ImmutableString("imageAtomicExchange(01N20C00D").mangledNameHash());
    ASSERT_EQ(0x000004adu, ImmutableString("imageAtomicExchange(00p10C00C").mangledNameHash());
    ASSERT_EQ(0x000004aeu, ImmutableString("imageAtomicExchange(00y10C00C").mangledNameHash());
    ASSERT_EQ(0x000004afu, ImmutableString("imageAtomicExchange(01H10C00C").mangledNameHash());
    ASSERT_EQ(0x000004b0u, ImmutableString("imageAtomicExchange(00q20C00C").mangledNameHash());
    ASSERT_EQ(0x000004b1u, ImmutableString("imageAtomicExchange(00z20C00C").mangledNameHash());
    ASSERT_EQ(0x000004b2u, ImmutableString("imageAtomicExchange(01I20C00C").mangledNameHash());
    ASSERT_EQ(0x000004b3u, ImmutableString("imageAtomicExchange(00s20C00C").mangledNameHash());
    ASSERT_EQ(0x000004b4u, ImmutableString("imageAtomicExchange(01B20C00C").mangledNameHash());
    ASSERT_EQ(0x000004b5u, ImmutableString("imageAtomicExchange(01K20C00C").mangledNameHash());
    ASSERT_EQ(0x000004b6u, ImmutableString("imageAtomicExchange(00x00C00C").mangledNameHash());
    ASSERT_EQ(0x000004b7u, ImmutableString("imageAtomicExchange(01G00C00C").mangledNameHash());
    ASSERT_EQ(0x000004b8u, ImmutableString("imageAtomicExchange(01P00C00C").mangledNameHash());
    ASSERT_EQ(0x000004b9u, ImmutableString("imageAtomicExchange(00r20C00C").mangledNameHash());
    ASSERT_EQ(0x000004bau, ImmutableString("imageAtomicExchange(01A20C00C").mangledNameHash());
    ASSERT_EQ(0x000004bbu, ImmutableString("imageAtomicExchange(01J20C00C").mangledNameHash());
    ASSERT_EQ(0x000004bcu, ImmutableString("imageAtomicExchange(00v20C00C").mangledNameHash());
    ASSERT_EQ(0x000004bdu, ImmutableString("imageAtomicExchange(01E20C00C").mangledNameHash());
    ASSERT_EQ(0x000004beu, ImmutableString("imageAtomicExchange(01N20C00C").mangledNameHash());
    ASSERT_EQ(0x000004bfu, ImmutableString("imageAtomicExchange(00p10C00B").mangledNameHash());
    ASSERT_EQ(0x000004c0u, ImmutableString("imageAtomicExchange(00y10C00B").mangledNameHash());
    ASSERT_EQ(0x000004c1u, ImmutableString("imageAtomicExchange(01H10C00B").mangledNameHash());
    ASSERT_EQ(0x000004c2u, ImmutableString("imageAtomicExchange(00q20C00B").mangledNameHash());
    ASSERT_EQ(0x000004c3u, ImmutableString("imageAtomicExchange(00z20C00B").mangledNameHash());
    ASSERT_EQ(0x000004c4u, ImmutableString("imageAtomicExchange(01I20C00B").mangledNameHash());
    ASSERT_EQ(0x000004c5u, ImmutableString("imageAtomicExchange(00s20C00B").mangledNameHash());
    ASSERT_EQ(0x000004c6u, ImmutableString("imageAtomicExchange(01B20C00B").mangledNameHash());
    ASSERT_EQ(0x000004c7u, ImmutableString("imageAtomicExchange(01K20C00B").mangledNameHash());
    ASSERT_EQ(0x000004c8u, ImmutableString("imageAtomicExchange(00x00C00B").mangledNameHash());
    ASSERT_EQ(0x000004c9u, ImmutableString("imageAtomicExchange(01G00C00B").mangledNameHash());
    ASSERT_EQ(0x000004cau, ImmutableString("imageAtomicExchange(01P00C00B").mangledNameHash());
    ASSERT_EQ(0x000004cbu, ImmutableString("imageAtomicExchange(00r20C00B").mangledNameHash());
    ASSERT_EQ(0x000004ccu, ImmutableString("imageAtomicExchange(01A20C00B").mangledNameHash());
    ASSERT_EQ(0x000004cdu, ImmutableString("imageAtomicExchange(01J20C00B").mangledNameHash());
    ASSERT_EQ(0x000004ceu, ImmutableString("imageAtomicExchange(00v20C00B").mangledNameHash());
    ASSERT_EQ(0x000004cfu, ImmutableString("imageAtomicExchange(01E20C00B").mangledNameHash());
    ASSERT_EQ(0x000004d0u, ImmutableString("imageAtomicExchange(01N20C00B").mangledNameHash());
    ASSERT_EQ(0x000004d1u, ImmutableString("imageAtomicCompSwap(00p10C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d2u, ImmutableString("imageAtomicCompSwap(00y10C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d3u, ImmutableString("imageAtomicCompSwap(01H10C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d4u, ImmutableString("imageAtomicCompSwap(00q20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d5u, ImmutableString("imageAtomicCompSwap(00z20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d6u, ImmutableString("imageAtomicCompSwap(01I20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d7u, ImmutableString("imageAtomicCompSwap(00s20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d8u, ImmutableString("imageAtomicCompSwap(01B20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004d9u, ImmutableString("imageAtomicCompSwap(01K20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004dau, ImmutableString("imageAtomicCompSwap(00x00C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004dbu, ImmutableString("imageAtomicCompSwap(01G00C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004dcu, ImmutableString("imageAtomicCompSwap(01P00C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004ddu, ImmutableString("imageAtomicCompSwap(00r20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004deu, ImmutableString("imageAtomicCompSwap(01A20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004dfu, ImmutableString("imageAtomicCompSwap(01J20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004e0u, ImmutableString("imageAtomicCompSwap(00v20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004e1u, ImmutableString("imageAtomicCompSwap(01E20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004e2u, ImmutableString("imageAtomicCompSwap(01N20C00D00D").mangledNameHash());
    ASSERT_EQ(0x000004e3u, ImmutableString("imageAtomicCompSwap(00p10C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004e4u, ImmutableString("imageAtomicCompSwap(00y10C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004e5u, ImmutableString("imageAtomicCompSwap(01H10C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004e6u, ImmutableString("imageAtomicCompSwap(00q20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004e7u, ImmutableString("imageAtomicCompSwap(00z20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004e8u, ImmutableString("imageAtomicCompSwap(01I20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004e9u, ImmutableString("imageAtomicCompSwap(00s20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004eau, ImmutableString("imageAtomicCompSwap(01B20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004ebu, ImmutableString("imageAtomicCompSwap(01K20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004ecu, ImmutableString("imageAtomicCompSwap(00x00C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004edu, ImmutableString("imageAtomicCompSwap(01G00C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004eeu, ImmutableString("imageAtomicCompSwap(01P00C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004efu, ImmutableString("imageAtomicCompSwap(00r20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004f0u, ImmutableString("imageAtomicCompSwap(01A20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004f1u, ImmutableString("imageAtomicCompSwap(01J20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004f2u, ImmutableString("imageAtomicCompSwap(00v20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004f3u, ImmutableString("imageAtomicCompSwap(01E20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004f4u, ImmutableString("imageAtomicCompSwap(01N20C00C00C").mangledNameHash());
    ASSERT_EQ(0x000004f5u, ImmutableString("pixelLocalLoadANGLE(01Q").mangledNameHash());
    ASSERT_EQ(0x000004f6u, ImmutableString("pixelLocalLoadANGLE(01R").mangledNameHash());
    ASSERT_EQ(0x000004f7u, ImmutableString("pixelLocalLoadANGLE(01S").mangledNameHash());
    ASSERT_EQ(0x000004f8u, ImmutableString("pixelLocalStoreANGLE(01Q30B").mangledNameHash());
    ASSERT_EQ(0x000004f9u, ImmutableString("pixelLocalStoreANGLE(01R30C").mangledNameHash());
    ASSERT_EQ(0x000004fau, ImmutableString("pixelLocalStoreANGLE(01S30D").mangledNameHash());
    ASSERT_EQ(0x000004fbu, ImmutableString("beginInvocationInterlockNV(").mangledNameHash());
    ASSERT_EQ(0x000004fcu, ImmutableString("endInvocationInterlockNV(").mangledNameHash());
    ASSERT_EQ(0x000004fdu, ImmutableString("beginFragmentShaderOrderingINTEL(").mangledNameHash());
    ASSERT_EQ(0x000004feu, ImmutableString("beginInvocationInterlockARB(").mangledNameHash());
    ASSERT_EQ(0x000004ffu, ImmutableString("endInvocationInterlockARB(").mangledNameHash());
    ASSERT_EQ(0x00000500u, ImmutableString("memoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x00000501u, ImmutableString("memoryBarrierAtomicCounter(").mangledNameHash());
    ASSERT_EQ(0x00000502u, ImmutableString("memoryBarrierBuffer(").mangledNameHash());
    ASSERT_EQ(0x00000503u, ImmutableString("memoryBarrierImage(").mangledNameHash());
    ASSERT_EQ(0x00000504u, ImmutableString("barrier(").mangledNameHash());
    ASSERT_EQ(0x00000505u, ImmutableString("memoryBarrierShared(").mangledNameHash());
    ASSERT_EQ(0x00000506u, ImmutableString("groupMemoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x00000507u, ImmutableString("EmitVertex(").mangledNameHash());
    ASSERT_EQ(0x00000508u, ImmutableString("EndPrimitive(").mangledNameHash());
    ASSERT_EQ(0x00000509u, ImmutableString("subpassLoad(01T").mangledNameHash());
    ASSERT_EQ(0x0000050au, ImmutableString("subpassLoad(01U").mangledNameHash());
    ASSERT_EQ(0x0000050bu, ImmutableString("subpassLoad(01V").mangledNameHash());
    ASSERT_EQ(0x0000050cu, ImmutableString("numSamples(").mangledNameHash());
    ASSERT_EQ(0x0000050du, ImmutableString("samplePosition(00D").mangledNameHash());
    ASSERT_EQ(0x0000050eu, ImmutableString("interpolateAtCenter(00B").mangledNameHash());
    ASSERT_EQ(0x0000050fu, ImmutableString("interpolateAtCenter(10B").mangledNameHash());
    ASSERT_EQ(0x00000510u, ImmutableString("interpolateAtCenter(20B").mangledNameHash());
    ASSERT_EQ(0x00000511u, ImmutableString("interpolateAtCenter(30B").mangledNameHash());
    ASSERT_EQ(0x00000512u, ImmutableString("loopForwardProgress(").mangledNameHash());
    ASSERT_EQ(0x00000513u, ImmutableString("saturate(00B").mangledNameHash());
    ASSERT_EQ(0x00000514u, ImmutableString("saturate(10B").mangledNameHash());
    ASSERT_EQ(0x00000515u, ImmutableString("saturate(20B").mangledNameHash());
    ASSERT_EQ(0x00000516u, ImmutableString("saturate(30B").mangledNameHash());
    ASSERT_EQ(0x00000517u, ImmutableString("gl_DepthRangeParameters").mangledNameHash());
    ASSERT_EQ(0x00000518u, ImmutableString("gl_DepthRange").mangledNameHash());
    ASSERT_EQ(0x00000519u, ImmutableString("gl_NumSamples").mangledNameHash());
    ASSERT_EQ(0x0000051au, ImmutableString("gl_MaxVertexAttribs").mangledNameHash());
    ASSERT_EQ(0x0000051bu, ImmutableString("gl_MaxVertexUniformVectors").mangledNameHash());
    ASSERT_EQ(0x0000051cu, ImmutableString("gl_MaxVertexTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000051du, ImmutableString("gl_MaxCombinedTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000051eu, ImmutableString("gl_MaxTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000051fu, ImmutableString("gl_MaxFragmentUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000520u, ImmutableString("gl_MaxVaryingVectors").mangledNameHash());
    ASSERT_EQ(0x00000521u, ImmutableString("gl_MaxDrawBuffers").mangledNameHash());
    ASSERT_EQ(0x00000522u, ImmutableString("gl_MaxDualSourceDrawBuffersEXT").mangledNameHash());
    ASSERT_EQ(0x00000523u, ImmutableString("gl_MaxVertexOutputVectors").mangledNameHash());
    ASSERT_EQ(0x00000524u, ImmutableString("gl_MaxFragmentInputVectors").mangledNameHash());
    ASSERT_EQ(0x00000525u, ImmutableString("gl_MinProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x00000526u, ImmutableString("gl_MaxProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x00000527u, ImmutableString("gl_MaxImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000528u, ImmutableString("gl_MaxVertexImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000529u, ImmutableString("gl_MaxFragmentImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000052au, ImmutableString("gl_MaxComputeImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000052bu, ImmutableString("gl_MaxCombinedImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000052cu,
              ImmutableString("gl_MaxCombinedShaderOutputResources").mangledNameHash());
    ASSERT_EQ(0x0000052du, ImmutableString("gl_MaxComputeWorkGroupCount").mangledNameHash());
    ASSERT_EQ(0x0000052eu, ImmutableString("gl_MaxComputeWorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x0000052fu, ImmutableString("gl_MaxComputeUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000530u, ImmutableString("gl_MaxComputeTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000531u, ImmutableString("gl_MaxComputeAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000532u, ImmutableString("gl_MaxComputeAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000533u, ImmutableString("gl_MaxVertexAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000534u, ImmutableString("gl_MaxFragmentAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000535u, ImmutableString("gl_MaxCombinedAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000536u, ImmutableString("gl_MaxAtomicCounterBindings").mangledNameHash());
    ASSERT_EQ(0x00000537u, ImmutableString("gl_MaxVertexAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000538u, ImmutableString("gl_MaxFragmentAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000539u, ImmutableString("gl_MaxCombinedAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000053au, ImmutableString("gl_MaxAtomicCounterBufferSize").mangledNameHash());
    ASSERT_EQ(0x0000053bu,
              ImmutableString("gl_ShadingRateFlag2VerticalPixelsEXT").mangledNameHash());
    ASSERT_EQ(0x0000053cu,
              ImmutableString("gl_ShadingRateFlag4VerticalPixelsEXT").mangledNameHash());
    ASSERT_EQ(0x0000053du,
              ImmutableString("gl_ShadingRateFlag2HorizontalPixelsEXT").mangledNameHash());
    ASSERT_EQ(0x0000053eu,
              ImmutableString("gl_ShadingRateFlag4HorizontalPixelsEXT").mangledNameHash());
    ASSERT_EQ(0x0000053fu, ImmutableString("gl_MaxGeometryInputComponents").mangledNameHash());
    ASSERT_EQ(0x00000540u, ImmutableString("gl_MaxGeometryOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000541u, ImmutableString("gl_MaxGeometryImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000542u, ImmutableString("gl_MaxGeometryTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000543u, ImmutableString("gl_MaxGeometryOutputVertices").mangledNameHash());
    ASSERT_EQ(0x00000544u,
              ImmutableString("gl_MaxGeometryTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000545u, ImmutableString("gl_MaxGeometryUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000546u, ImmutableString("gl_MaxGeometryAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000547u, ImmutableString("gl_MaxGeometryAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000548u, ImmutableString("gl_MaxTessControlInputComponents").mangledNameHash());
    ASSERT_EQ(0x00000549u, ImmutableString("gl_MaxTessControlOutputComponents").mangledNameHash());
    ASSERT_EQ(0x0000054au, ImmutableString("gl_MaxTessControlTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000054bu, ImmutableString("gl_MaxTessControlUniformComponents").mangledNameHash());
    ASSERT_EQ(0x0000054cu,
              ImmutableString("gl_MaxTessControlTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x0000054du, ImmutableString("gl_MaxTessControlImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000054eu, ImmutableString("gl_MaxTessControlAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x0000054fu,
              ImmutableString("gl_MaxTessControlAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000550u, ImmutableString("gl_MaxTessPatchComponents").mangledNameHash());
    ASSERT_EQ(0x00000551u, ImmutableString("gl_MaxPatchVertices").mangledNameHash());
    ASSERT_EQ(0x00000552u, ImmutableString("gl_MaxTessGenLevel").mangledNameHash());
    ASSERT_EQ(0x00000553u,
              ImmutableString("gl_MaxTessEvaluationInputComponents").mangledNameHash());
    ASSERT_EQ(0x00000554u,
              ImmutableString("gl_MaxTessEvaluationOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000555u,
              ImmutableString("gl_MaxTessEvaluationTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000556u,
              ImmutableString("gl_MaxTessEvaluationUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000557u, ImmutableString("gl_MaxTessEvaluationImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000558u, ImmutableString("gl_MaxTessEvaluationAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000559u,
              ImmutableString("gl_MaxTessEvaluationAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x0000055au, ImmutableString("gl_MaxSamples").mangledNameHash());
    ASSERT_EQ(0x0000055bu, ImmutableString("gl_MaxClipDistances").mangledNameHash());
    ASSERT_EQ(0x0000055cu, ImmutableString("gl_MaxCullDistances").mangledNameHash());
    ASSERT_EQ(0x0000055du, ImmutableString("gl_MaxCombinedClipAndCullDistances").mangledNameHash());
    ASSERT_EQ(0x0000055eu, ImmutableString("gl_FragCoord").mangledNameHash());
    ASSERT_EQ(0x0000055fu, ImmutableString("gl_FrontFacing").mangledNameHash());
    ASSERT_EQ(0x00000560u, ImmutableString("gl_PointCoord").mangledNameHash());
    ASSERT_EQ(0x00000561u, ImmutableString("gl_FragColor").mangledNameHash());
    ASSERT_EQ(0x00000562u, ImmutableString("gl_FragData").mangledNameHash());
    ASSERT_EQ(0x00000563u, ImmutableString("gl_FragDepth").mangledNameHash());
    ASSERT_EQ(0x00000564u, ImmutableString("gl_HelperInvocation").mangledNameHash());
    ASSERT_EQ(0x00000565u, ImmutableString("gl_SecondaryFragColorEXT").mangledNameHash());
    ASSERT_EQ(0x00000566u, ImmutableString("gl_SecondaryFragDataEXT").mangledNameHash());
    ASSERT_EQ(0x00000567u, ImmutableString("gl_FragDepthEXT").mangledNameHash());
    ASSERT_EQ(0x00000568u, ImmutableString("gl_LastFragData").mangledNameHash());
    ASSERT_EQ(0x00000569u, ImmutableString("gl_LastFragColor").mangledNameHash());
    ASSERT_EQ(0x0000056au, ImmutableString("gl_LastFragColorARM").mangledNameHash());
    ASSERT_EQ(0x0000056bu, ImmutableString("gl_LastFragDepthARM").mangledNameHash());
    ASSERT_EQ(0x0000056cu, ImmutableString("gl_LastFragStencilARM").mangledNameHash());
    ASSERT_EQ(0x0000056du, ImmutableString("gl_PrimitiveID").mangledNameHash());
    ASSERT_EQ(0x0000056eu, ImmutableString("gl_Layer").mangledNameHash());
    ASSERT_EQ(0x0000056fu, ImmutableString("gl_ShadingRateEXT").mangledNameHash());
    ASSERT_EQ(0x00000570u, ImmutableString("gl_SampleID").mangledNameHash());
    ASSERT_EQ(0x00000571u, ImmutableString("gl_SamplePosition").mangledNameHash());
    ASSERT_EQ(0x00000572u, ImmutableString("gl_SampleMaskIn").mangledNameHash());
    ASSERT_EQ(0x00000573u, ImmutableString("gl_SampleMask").mangledNameHash());
    ASSERT_EQ(0x00000574u, ImmutableString("gl_Position").mangledNameHash());
    ASSERT_EQ(0x00000575u, ImmutableString("gl_PointSize").mangledNameHash());
    ASSERT_EQ(0x00000576u, ImmutableString("gl_InstanceID").mangledNameHash());
    ASSERT_EQ(0x00000577u, ImmutableString("gl_InstanceIndex").mangledNameHash());
    ASSERT_EQ(0x00000578u, ImmutableString("gl_VertexID").mangledNameHash());
    ASSERT_EQ(0x00000579u, ImmutableString("gl_VertexIndex").mangledNameHash());
    ASSERT_EQ(0x0000057au, ImmutableString("gl_DrawID").mangledNameHash());
    ASSERT_EQ(0x0000057bu, ImmutableString("gl_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x0000057cu, ImmutableString("gl_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x0000057du, ImmutableString("angle_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x0000057eu, ImmutableString("angle_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x0000057fu, ImmutableString("gl_ClipDistance").mangledNameHash());
    ASSERT_EQ(0x00000580u, ImmutableString("gl_PrimitiveShadingRateEXT").mangledNameHash());
    ASSERT_EQ(0x00000581u, ImmutableString("gl_NumWorkGroups").mangledNameHash());
    ASSERT_EQ(0x00000582u, ImmutableString("gl_WorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x00000583u, ImmutableString("gl_WorkGroupID").mangledNameHash());
    ASSERT_EQ(0x00000584u, ImmutableString("gl_LocalInvocationID").mangledNameHash());
    ASSERT_EQ(0x00000585u, ImmutableString("gl_GlobalInvocationID").mangledNameHash());
    ASSERT_EQ(0x00000586u, ImmutableString("gl_LocalInvocationIndex").mangledNameHash());
    ASSERT_EQ(0x00000587u, ImmutableString("gl_PrimitiveIDIn").mangledNameHash());
    ASSERT_EQ(0x00000588u, ImmutableString("gl_InvocationID").mangledNameHash());
    ASSERT_EQ(0x00000589u, ImmutableString("gl_PerVertex").mangledNameHash());
    ASSERT_EQ(0x0000058au, ImmutableString("gl_in").mangledNameHash());
    ASSERT_EQ(0x0000058bu, ImmutableString("gl_PatchVerticesIn").mangledNameHash());
    ASSERT_EQ(0x0000058cu, ImmutableString("gl_TessLevelOuter").mangledNameHash());
    ASSERT_EQ(0x0000058du, ImmutableString("gl_TessLevelInner").mangledNameHash());
    ASSERT_EQ(0x0000058eu, ImmutableString("gl_out").mangledNameHash());
    ASSERT_EQ(0x0000058fu, ImmutableString("gl_BoundingBox").mangledNameHash());
    ASSERT_EQ(0x00000590u, ImmutableString("gl_BoundingBoxEXT").mangledNameHash());
    ASSERT_EQ(0x00000591u, ImmutableString("gl_BoundingBoxOES").mangledNameHash());
    ASSERT_EQ(0x00000592u, ImmutableString("gl_TessCoord").mangledNameHash());
    ASSERT_EQ(0x00000593u, ImmutableString("gl_ViewID_OVR").mangledNameHash());
    ASSERT_EQ(0x00000594u, ImmutableString("gl_CullDistance").mangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("radians").unmangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("degrees").unmangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("sin").unmangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("cos").unmangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("tan").unmangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("asin").unmangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("acos").unmangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("atan").unmangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("sinh").unmangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("cosh").unmangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("tanh").unmangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("asinh").unmangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("acosh").unmangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("atanh").unmangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("pow").unmangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("exp").unmangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("log").unmangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("exp2").unmangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("log2").unmangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("sqrt").unmangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("inversesqrt").unmangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("abs").unmangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("sign").unmangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("floor").unmangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("trunc").unmangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("round").unmangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("roundEven").unmangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("ceil").unmangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("fract").unmangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("mod").unmangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("min").unmangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("max").unmangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("clamp").unmangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("mix").unmangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("step").unmangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("smoothstep").unmangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("modf").unmangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("isnan").unmangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("isinf").unmangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("floatBitsToInt").unmangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("floatBitsToUint").unmangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("intBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("uintBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("fma").unmangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("frexp").unmangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("ldexp").unmangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("packSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("packHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("unpackSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("unpackHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("packUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("unpackUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("packUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("packSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("unpackUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("unpackSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("length").unmangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("distance").unmangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("dot").unmangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("cross").unmangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("normalize").unmangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("faceforward").unmangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("reflect").unmangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("refract").unmangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("matrixCompMult").unmangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("outerProduct").unmangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("transpose").unmangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("determinant").unmangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("inverse").unmangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("lessThan").unmangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("lessThanEqual").unmangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("greaterThan").unmangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("greaterThanEqual").unmangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("equal").unmangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("notEqual").unmangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("any").unmangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("all").unmangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("not").unmangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("bitfieldExtract").unmangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("bitfieldInsert").unmangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("bitfieldReverse").unmangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("bitCount").unmangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("findLSB").unmangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("findMSB").unmangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("uaddCarry").unmangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("usubBorrow").unmangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("umulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("imulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("texture2D").unmangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("texture2DProj").unmangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("textureCube").unmangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("texture3D").unmangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("texture3DProj").unmangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("shadow2DEXT").unmangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("shadow2DProjEXT").unmangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("texture2DRect").unmangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("texture2DRectProj").unmangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("texture2DGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("texture2DProjGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("textureCubeGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("textureVideoWEBGL").unmangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("texture3DLod").unmangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("texture3DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("texture2DLod").unmangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("texture2DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("textureCubeLod").unmangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("texture2DLodEXT").unmangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("texture2DProjLodEXT").unmangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("textureCubeLodEXT").unmangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("texture").unmangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("textureProj").unmangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("textureLod").unmangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("textureSize").unmangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("textureProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("texelFetch").unmangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("textureGrad").unmangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("textureProjGrad").unmangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("textureOffset").unmangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("textureProjOffset").unmangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("textureLodOffset").unmangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("textureProjLodOffset").unmangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("texelFetchOffset").unmangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("textureGradOffset").unmangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("textureProjGradOffset").unmangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("textureGather").unmangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("textureGatherOffset").unmangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("textureGatherOffsets").unmangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("textureQueryLOD").unmangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("rgb_2_yuv").unmangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("yuv_2_rgb").unmangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("dFdx").unmangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("dFdy").unmangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("fwidth").unmangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("interpolateAtCentroid").unmangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("interpolateAtSample").unmangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("interpolateAtOffset").unmangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("atomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("atomicCounterIncrement").unmangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("atomicCounterDecrement").unmangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("atomicAdd").unmangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("atomicMin").unmangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("atomicMax").unmangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("atomicAnd").unmangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("atomicOr").unmangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("atomicXor").unmangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("atomicExchange").unmangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("atomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("imageSize").unmangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("imageStore").unmangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("imageLoad").unmangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("imageAtomicAdd").unmangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("imageAtomicMin").unmangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("imageAtomicMax").unmangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("imageAtomicAnd").unmangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("imageAtomicOr").unmangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("imageAtomicXor").unmangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("imageAtomicExchange").unmangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("imageAtomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("pixelLocalLoadANGLE").unmangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("pixelLocalStoreANGLE").unmangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("beginInvocationInterlockNV").unmangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("endInvocationInterlockNV").unmangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("beginFragmentShaderOrderingINTEL").unmangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("beginInvocationInterlockARB").unmangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("endInvocationInterlockARB").unmangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("memoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("memoryBarrierAtomicCounter").unmangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("memoryBarrierBuffer").unmangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("memoryBarrierImage").unmangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("barrier").unmangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("memoryBarrierShared").unmangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("groupMemoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x000000acu, ImmutableString("EmitVertex").unmangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("EndPrimitive").unmangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("subpassLoad").unmangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("numSamples").unmangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("samplePosition").unmangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("interpolateAtCenter").unmangledNameHash());
    ASSERT_EQ(0x000000b2u, ImmutableString("loopForwardProgress").unmangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("saturate").unmangledNameHash());
}

}  // namespace sh
