!if $wims_read_parm!=$empty
  !goto $wims_read_parm
!endif

:general
<h2 id="general">Introduction</h2>

<p>
Une feuille permet de proposer aux lves une activit note forme
d'une liste d'exercices WIMS.
</p>
<div>
Le serveur enregistre un certains nombre de donnes sur le travail
effectu par un participant sur les exercices d'une feuille permettant
 l'enseignant de suivre l'activit des participants :
<ul><li>date  laquelle un lve demande l'nonc d'un exercice de la feuille,
</li><li> date  laquelle il entre ses rponses,
</li><li>son score  l'exercice.
</li></ul>
<p>
Une note sur la feuille est calcule  partir des scores obtenus  chaque essai
sur des exercices de la feuille. Par dfaut, cette note est calcule sur 10.
</p>
</div>
<div>
Par dfaut, un lve peut :
<ul><li>recommencer autant de fois qu'il veut un mme exercice de la feuille ;
</li><li>
travailler sur les exercices d'une feuille dans l'ordre qu'il veut ;
</li><li>choisir de travailler sur une feuille sans que les scores
 obtenus soient pris en compte dans la note de la feuille.
</li></ul>
</div>
<div>
Par dfaut, le temps pendant lequel un lve peut rpondre  un exercice  partir
du moment o il a cliqu pour obtenir un nonc est seulement limit par la
dure maximale d'une session (la dure maximale d'une session sans activit
est fixe par l'administrateur du serveur  $idle_time minutes).
</div>
<div style="margin-top:1em">
Pour constituer les feuilles de sa classe, on peut
<ul><li>
importer des feuilles trouves grce au moteur de recherche (cliquez sur
le titre de la feuille puis sur le lien
<span class="tt wims_code_words">$wims_name_import</span>)
et la modifier ensuite ventuellement ;
</li><li>
crer une nouvelle feuille  partir du lien
<span class="tt wims_code_words">$wims_name_add_sheet</span> dans la page d'accueil
de la classe,
puis constituer le contenu de la feuille en insrant
les exercices trouvs  partir du moteur de recherche ou parmi les exercices
de sa classe ; (le lien <span class="tt wims_code_words">$wims_name_add</span>
est visible lorsqu'on va travailler sur un nonc d'un exercice,
le lien <span class="tt wims_code_words">$wims_name_addallexo</span>
est visible dans la page d'introduction de certains modules d'exercices) ;
</li><li>
crer une nouvelle feuille  partir des exercices d'un document
publi sur le serveur (la cration d'une feuille est propose au moment
de l'insertion d'un document dans la classe).
</li></ul>
Une fois la feuille cre, il est aussi possible d'insrer un fichier source d'une
liste d'exercices trouv par exemple dans un document wims.
</div>
<p>
A chaque exercice de la feuille, l'enseignant peut associer une aide sous forme
d'un lien vers un document, un exercice WIMS ou une glose d'un gossaire qui sera
 propos  l'lve lorsque son score  un essai sur l'exercice sera strictement infrieur 
  une valeur choisie.
Il peut dfinir des dpendances avec les autres exercices d'une feuille afin de ne rendre accessible
certains exercices que lorsque l'lve a obtenu un score suffisant sur l'exercice.
</p><p>
Les feuilles sont numrotes dans l'ordre de leur cration/insertion dans la classe.
Il est possible de rorganiser la prsentation des feuilles pour les lves en utilisant
le lien <span class="tt wims_code_words">$wims_name_reorder</span>.
</p>

!if $wims_read_parm!=$empty
  !exit
!endif

:statut
<h2 id="statut">Statut d'une feuille</h2>
Une feuille  peut avoir quatre statuts :
<span class="wims_code_variable">
!replace internal , by ,$ $ in $(wims_name_shstatus).
</span>
<p>
<span class="wims_code_variable">$(wims_name_shstatus[1]) :</span>
c'est le statut initial d'une feuille. Dans ce statut, la feuille n'est pas
visible des lves.
</p><p>
<span class="wims_code_variable">$(wims_name_shstatus[2]) :</span>
lorsqu'on clique sur
<span class="tt wims_code_words">$(wims_name_actionlist[1])</span>,
la feuille devient visible par les lves (ils pourront travailler
sur les exercices  si aucun paramtre dans le champ
<span class="tt wims_code_words">$(name_shinfo[6])</span>
ne l'empche), son contenu
n'est plus modifiable except les titres et les textes d'explication de la feuille et
des exercices, le champ
<span class="tt wims_code_words">$(name_shinfo[6])</span> ainsi que
les champs
<span class="tt wims_code_words">$wims_name_feedbackexo</span> des exercices.
</p><p>
Du statut
<span class="tt wims_code_words">$(wims_name_shstatus[2])</span>,
la feuille  peut passer au statut
<span class="tt wims_code_words">$(wims_name_shstatus[3])</span>
 en cliquant sur le bouton
 <span class="tt wims_code_words">$(wims_name_actionlist[2])</span>.
On ne peut pas revenir au statut
<span class="tt wims_code_words">$(wims_name_shstatus[1])</span>.
</p><p>
<span class="wims_code_variable">$(wims_name_shstatus[3]) :</span>
l'lve peut travailler sur la feuille mais son travail n'est pas comptabilis.
</p><p>
Une fois la feuille expire, on peut la rendre invisible aux lves en cliquant sur
<span class="tt wims_code_words">$(wims_name_actionlist[4])</span>,
mais on peut aussi la remettre dans le statut
<span class="tt wims_code_words">$(wims_name_shstatus[2])</span>.
 </p>
!if $wims_read_parm!=$empty
  !exit
!endif

:allowtype
<h2 id="allowtype">Paramtrage de l'enregistrement des notes.</h2>

Vous pouvez imposer une restriction, par exemple dans le temps, pour
l'enregistrement des notes. Plusieurs options sont disponibles :
<ul>
 <li><span class="tt wims_code_words">$(name_allowtype[1])</span> :
les notes seront enregistres.</li>
 <li><span class="tt wims_code_words">$(name_allowtype[2])</span> :
aucune note ne sera enregistre.</li>
 <li><span class="tt wims_code_words">$(name_allowtype[3])</span> :
une interface de saisie,
<span class="tt wims_code_words">$(name_shinfo[6])</span>,
apparat et vous pouvez indiquer une plage horaire ainsi que les
adresses IP  partir desquelles les notes seront enregistres.
Cette restriction s'crit  l'aide d'une expression en trois parties (qui peuvent
 ne pas toutes tre prsentes) : <br>
 <ul>
  <li>Une date et une heure de dbut ;</li>
  <li>Une date et une heure de fin ;</li>
  <li>Une plage d'IP ;</li>
 </ul>
Les dates (format <span class="tt wims_code_words">aaaammjj</span>) et heures
(format <span class="tt wims_code_words">hh:mm</span>) doivent tre en temps local du SERVEUR.
 <p>
Exemple :
$wims_name_form <span class="tt wims_code_words">20131007</span> $wims_name_at <span class="tt wims_code_words">10:30</span> $wims_name_to <span class="tt wims_code_words">20131001</span> $wims_name_at <span class="tt wims_code_words">10:00</span> $wims_name_IP<span class="tt wims_code_words"> 127.0.</span> <br>
permet l'enregistrement des notes entre 2 dates et seulement pour les numros IP commenant
par <span class="tt wims_code_words">127.0.</span>.
</p>
</li><li><span class="tt wims_code_words">$(name_allowtype[4])</span> :
cette option peut tre choisie afin d'individualiser les restrictions
d'accs  l'aide d'une <span class="tt wims_code_words">variable
technique</span> (cette variable technique est dfinie pour chaque
participant soit manuellement en utilisant le module de gestion des
variables techniques soit  l'aide d'un
<span class="tt wims_code_words">$wims_name_Vote</span>).
Lors du choix de cette option, un menu permet de choisir la variable
 technique qui sert de diffrenciation et un tableau permet
d'effectuer un rglage du filtre (en utilisant le mme format que
prcdemment) pour chaque valeur possible de la variable.
Ne rien prciser comme filtre  pour une valeur de la variable technique signifie
ne pas ouvrir l'enregistrement des notes pour les participants qui ont cette valeur.
<p>
Dans le cas d'une variable technique dfinie  l'aide du modle
<span class="tt wims_code_words">Accs individualis</span>
d'un <span class="tt wims_code_words">$wims_name_Vote</span>
spcifique  la cration de rservation de crneau horaire,
le tableau est dj pr-rempli avec les donnes proposes lors de la
 cration du questionnaire. Ces donnes peuvent tre modifies,
mais les modifications ne sont pas rpercutes sur le questionnaire.
</p>
<p>Exemple : Supposons que le tableau dcrivant les filtres pour la variable technique
<span class="tt wims_code_variable">groupe</span> prenant les valeurs 1, 2 et 3 soit :
!readproc slib/text/matrixhtml [$name_value,$name_filtre\
$name_EMPTY, 129.50.10. &#62;20160915.12&#58;00\
1,&#62;20160915.15&#58;00 &#60;20160925.12&#58;00\
2,\
3,127.0.],wimscenter wimsborder wimstable,TH=[1;]
$slib_out
</p>
Dans la limite de la date de premption de la feuille,
<ul><li>
pour les lves pour lesquels
<span class="tt wims_code_variable">groupe</span> n'a pas de valeur,
l'enregistrement des notes est ouvert  partir du
15/09/2016 12h et uniquement sur les postes dont l'IP commence par
129.50.10.
</li><li>
pour les lves pour lesquels <span class="tt wims_code_variable">groupe=1</span>,
l'enregistrement des notes est ouvert entre le 15/09/2016 15h et le 25/09/2016 12h.
</li><li>
pour les lves pour
lesquels <span class="tt wims_code_variable">groupe=2</span>, l'enregistrement des notes n'est pas ouvert.
</li><li>
pour les lves pour lesquels
<span class="tt wims_code_variable">groupe=3</span>,
l'enregistrement des notes est ouvert uniquement  partir des postes
dont l'IP commence par 127.0.
</li></ul>
</li>
<li>Ces rglages peuvent tre propags :
<ul>
  <li>dans un groupement, pour des classes en partage  partir de la classe ayant initi le partage et en utilisant une variable technique provenant du groupement,</li>
  <li>dans un portail,  partir d'un programme vers les cours en utilisant une variable technique provenant du portail ou du niveau.</li>
</ul>
</li>
</ul>

!if $tv_listtechvar!=$empty
 Les variables techniques actuellement disponibles dans votre classe sont :
 !read adm/vfilter/listvar.phtml
!else
<div class="wims_msg info">
 Il n'y a actuellement aucune variable technique dfinie dans votre
classe. Si vous voulez utiliser cette option, il faut d'abord
dfinir une variable technique.
</div>
!endif
!if $wims_read_parm!=$empty
  !exit
!endif

:variable
<p>
Afin d'individualiser les restrictions d'accs, il est possible de mettre
une variable (dans l'exemple ci-dessous, mettre
<span class="tt wims_code_words">\timelimit</span>).
Cette variable doit alors tre dfinie pour chaque participant selon
les rgles prcdentes soit manuellement dans les proprits du
compte d'un participant (variable technique).
</p><p>
Exemple : mettre
<span class="tt wims_code_words">timelimit=&lt;20131007.10:30 &gt;20131001.10:00</span>
dans le champ <span class="tt wims_code_words">variable technique</span>
des proprits du compte d'un lve.
Pour les participants pour lesquels cette variable est vide,
l'enregistrement des notes est ferm.
</p><p>
Il est possible d'ajouter cette variable par liaison tableur.
Si la restriction est un choix du participant (inscription selon
certaines dates par exemple), il est possible de crer et utiliser
un questionnaire en mode guid (voir l'aide correspondante).
</p>
!!if $wims_read_parm!=$empty
!exit
!!endif

:dependancies
<h2 id="dependancies">$(name_shtab[6])</h2>
<p>
Si l'on met une dpendance des scores sur un exercice, un participant doit
d'abord acqurir suffisamment de points dans d'autres exercices de la feuille. </p>
Le champ <span class="tt wims_code_words">$(name_shtab[6])</span>
d'un exercice permet de prciser les points que doit acqurir un participant
sur d'autres exercices de la feuille avant de pouvoir travailler sur celui-ci.
Par exemple, mettre <span class="tt wims_code_words">1:50,2:30,3+4+5:60</span>
sur l'exercice 6 signifie que le participant doit avoir un succs de 50% sur
l'exercice 1, 30% sur l'exercice 2, et une moyenne de succs de 60% sur
 les exercices 3, 4, 5 pour pouvoir faire l'exercice 6.
</p>

!if $wims_read_parm!=$empty
  !exit
!endif

:feedback
<h2 id="feedback">$(name_shtab[10])</h2>

On peut indiquer dans ce champ un lien sur un document de WIMS, un exercice de WIMS 
ou une glose du glossaire gnral ; ce lien apparatra lorsque le score est
soumis  certaines conditions, par exemple s'il est strictement infrieur  une note
 fixe (sur 10). Le premier item est l'adresse sous la forme suivante (forme abrge):
<ul><li>
exercice d'un module public ou document public :
<span class="tt wims_address">module=xxx</span>
(comme dans <span class="wims_button disabled">$wims_name_about</span>)
</li><li>
exercice de la classe :
<span class="tt wims_address">module=classes/fr&exo=_nom_fichier_</span>
o <span class="tt">_nom_fichier_</span> est le nom du fichier de l'exercice
(sans l'extension <span class="tt">.oef</span>)
</li><li>
document de la classe :
<span class="tt wims_address">module=adm/doc&doc=c1&+block=_nom_bloc</span>
</li><li>
glose du glossaire gnral :
<span class="tt wims_address">module=adm/tool/glossary&special_parm=_nom_glose</span>
(par exemple, _nom_glose est mathematics/algebra/fr/affixe). 
</li><li>
certains encadrs d'une glose : 
<span class="tt wims_address">module=adm/tool/glossary&special_parm=_nom_glose|content=[liste]</span>
(o liste est  remplacer par la liste des numros des encadrs spars par une virgule). 
</li>
</ul>
Les items suivants sont la note maximale et la note minimale (par dfaut 0)
pour que le lien apparaisse (les trois items doivent tre sur la mme ligne).
Par exemple, dans l'exemple ci-dessous, si la note est infrieure 
5, l'lve sera dirig sur le document <span class="tt">c2</span>
de la classe, et plus prcisment
sur la page correspondant au bloc
<span class="tt">aaa</span> de ce document.
<pre>module=adm/doc&doc=c2&+block=aaa,5</pre>
Dans l'exemple ci-dessous, il y aura un
lien vers un exercice du module <span class="tt wims_fname">H6/set/oefset.fr</span>
dont le source a pour nom <span class="tt">traduction1</span>
(la note que l'lve aura sur cet exercice ne sera pas enregistre dans
la classe).
<pre>module=H6/set/oefset.fr&cmd=new&exo=traduction1,10</pre>

En mettant deux nombres (dont le deuxime est strictement positif), le bouton
apparat lorsque le score est compris entre le second nombre
et le premier nombre : par exemple, si vous mettez
<pre>module=H6/set/oefset.fr&cmd=new&exo=traduction1,11,10</pre>
le bouton apparat lorsque le score est de 10 et c'est le mot
$wims_name_feedbackplus qui apparat. Si le deuxime nombre est 0,
le comportement est le mme que s'il n'existait pas.

Il est possible de dfinir plusieurs liens correspondant 
des plages de notes diffrentes (pour l'instant, aucune vrification
n'est faite par le logiciel).

<pre>module=H6/set/oefset.fr&cmd=new&exo=traduction1,10,5
module=adm/doc&doc=c2&+block=aaa,5,4
</pre>

Vous pouvez aussi insrer un lien d'aide dans la feuille en
slectionnant d'abord une ressource WIMS et en suivant le lien
<span class="wims_button disabled">$wims_name_addh</span>
dans le menu de gauche. Il est cependant conseill de vrifier aprs avoir
insr tous les liens la compatibilit des plages de notes.

!exit

:series
<p>
En gnral, les exercices d'une srie sont tirs alatoirement
et au moins un exercice de chaque type est propos si le nombre
demand le permet.
</p><p>
Vous avez demand dans le paramtrage expert que l'ordre ne soit
pas alatoire,
vous pouvez ici changer l'ordre des exercices d'une srie.
</p>
!exit

:score
!changeto adm/lang/help.score.fr

:exotrymax
<h2 id="exotrymax">Nombre maximal d'essais comptabiliss</h2>
Paramtre permettant de fixer un nombre maximal <span class="tt">n</span>
d'essais comptabiliss dans le calcul des notes pendant les priodes o l'enregistrement des notes
est ouvert sur la feuille.
<p>
Laissez le champ vide si vous ne voulez pas mettre de limite au nombre d'essais comptabiliss.
</p>
<p>
<strong>Essai</strong> : le travail sur une srie d'exercices est considr comme un essai
 qu'une rponse ait t donne ou pas et que l'enregistrement des notes ait t activ ou pas.
</p>
Si vous mettez un entier positif <span class="tt">n</span>
<ul><li>
le travail sur l'exercice est toujours possible une fois ce nombre atteint ;
</li><li>
le compteur du nombre d'essais ne s'incrmente que lorsque l'enregistrement
des notes est ouvert sur la feuille par l'enseignant ;
</li><li>
le calcul des notes ne tient compte que des scores des <span class="tt">n</span>
 premiers essais o l'enregistrement des notes a t activ. En consquence, le nombre de points
requis sur l'exercice ne doit pas dpasser <span class="tt">10 x n,</span> puisque c'est le nombre maximum
de points qu'un participant pourra obtenir sur l'exercice.
</li></ul>
!exit

:weight
!changeto adm/lang/weight.fr
!exit

:weightexo
!set wims_backslash_insmath=yes
<h2 id="weightexo">Poids d'un exercice dans la feuille</h2>
Le poids de l'exercice dans la feuille intervient  la fois dans le calcul des trois
 indicateurs de travail sur la feuille - <span class="wims_code_variable">$(wims_name_thsheet[5]),
$(wims_name_thsheet[10]), $(wims_name_thsheet[13])</span> -
et dans le calcul de la note <span class="wims_code_variable">$(wims_name_thsheet[7])</span> de la feuille.
<ul><li>
La valeur de l'indicateur <span class="wims_code_variable">$(wims_name_thsheet[5])</span>
est une moyenne pondre de l'indicateur
de cumul sur chaque exercice de la feuille, avec comme coefficient de pondration le produit du poids
de l'exercice dans la feuille par le nombre de points requis. La rgle est analogue pour le calcul des
 valeurs de <span class="wims_code_variable">$(wims_name_thsheet[10])</span>
 et <span class="wims_code_variable">$(wims_name_thsheet[13])</span>.
 </li><li>
La valeur de la note <span class="wims_code_variable">$(wims_name_thsheet[7])</span>
 sur la feuille est une moyenne pondre de la note de qualit
obtenue sur chaque exercice avec comme coefficient de pondration le produit
du poids de l'exercice par l'indicateur de cumul obtenu sur l'exercice.
</li></ul>
<p>
Mettez le poids 0 si vous ne voulez pas que les scores obtenus sur cet exercice
soient comptabiliss.
</p>
Exemple : le tableau dcrit les rsultats obtenus par un participant sur
une feuille comportant 3 exercices :
$table_header
  <thead>
  $table_hdtr
    <th scope="col" data-sort-method="number">$(wims_name_thsheet[1])</th>
    <th scope="col">$(wims_name_thsheet[2])</th>
    <th scope="col" data-sort-method="number">$(wims_name_thsheet[3])</th>
    <th scope="col" data-sort-method="number">$(wims_name_thsheet[4])</th>
  !!qualite
    <th scope="col" data-sort-method="number">$(wims_name_thsheet[7])</th>
    <th scope="col" data-sort-method="number">$(wims_name_thsheet[5])</th>
  </tr>
  </thead>
  <tbody>
<tr><td> 1 </td><td>Exo 1</td><td>20</td><td>2</td><td>5.5</td><td>60%</td></tr>
<tr><td> 2 </td><td>Exo 2</td><td>10</td><td>3</td><td>6.5</td><td>25%</td></tr>
<tr><td> 3 </td><td>Exo 3</td><td>10</td><td>0</td><td>8.5</td><td>100%</td></tr>
  </tbody>
$table_end
<ul><li>La note $(wims_name_thsheet[5]) sur la feuille est
\(\frac{2\times 20 \times 60 + 3 \times 10 \times 80 + 0}{2\times 20 + 3 \times 10}\% = 68.57\%\)
</li><li>
La note $(wims_name_thsheet[7]) sur la feuille est
\(\frac{2\times 60 \times 5.5 + 3 \times 80 \times 6.5 + 0}{2\times 60 + 3 \times 80} = 6.17\)
</li></ul>
!if $wims_read_parm!=$empty
  !exit
!endif

:exodescshow
<h2 id="statut">$(name_shinfo[13])</h2>
Si vous cochez sur <span class="tt">$wims_name_yes</span>, la description de l'exercice
apparaitra dans l'en-tte de l'exercice et pas seulement dans la liste des exercices
de la feuille.
!if $wims_read_parm!=$empty
  !exit
!endif

:indivtechvar
<h2 id="statut">$name_individualisation</h2>
L'option <span class="wims_code_words">$name_desc_indivtechvar</span>
permet d'indiquer une variable technique qui servira   slectionner certains
exercices de la feuille pour chaque valeur de la variable technique : cela permet de proposer des versions
diffrentes de la feuille  des groupes de participants.
<p>
Le participant voit la version de la feuille correspondant  la valeur de la
variable technique qui lui a t attribue. Les participants dont la variable
 technique n'a pas t attribue voient tous les exercices de la feuille.<br>
Remarque : le participant verra le nom de la variable technique suivi de sa valeur
 en dessous du titre de la feuille et dans le tableau dcrivant son travail sur la feuille.
</p><p>
La constitution des diffrentes versions de la feuille s'effectue dans l'onglet <span class="wims_code_words">$name_individualisation</span>
  qui apparat seulement lorsqu'une variable technique est slectionne.
  Il est alors possible de slectionner les sries d'exercices prsentes dans
  chaque version de la feuille et de fixer les points et les poids attribus  ces sries d'exercices.
<p><p class="wims_msg warning">
Cette option est incompatible avec les dpendances de score.
La variable technique doit tre locale.
</p><p class="wims_msg info">
!if $tv_listlocal!=$empty
 Les variables techniques locales actuellement disponibles dans votre classe sont :
 !read adm/vfilter/listvar.phtml local
!else
  Il n'y a actuellement aucune variable technique dfinie dans votre
  classe. Si vous voulez utiliser cette option, dfinissez d'abord
  une variable technique.
!endif
</p>
!if $wims_read_parm!=$empty
  !exit
!endif
