/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package trait

import (
	traitv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1/trait"
)

const (
	deployerTraitID    = "deployer"
	deployerTraitOrder = 900
)

type deployerTrait struct {
	BasePlatformTrait
	traitv1.DeployerTrait `property:",squash"`
}

var _ ControllerStrategySelector = &deployerTrait{}

func newDeployerTrait() Trait {
	return &deployerTrait{
		BasePlatformTrait: NewBasePlatformTrait(deployerTraitID, deployerTraitOrder),
	}
}

func (t *deployerTrait) Configure(e *Environment) (bool, *TraitCondition, error) {
	var condition *TraitCondition

	return e.Integration != nil, condition, nil
}

func (t *deployerTrait) Apply(e *Environment) error {
	// Register a post action that patches the resources generated by the traits
	e.PostActions = append(e.PostActions, func(env *Environment) error {
		applier := e.Client.ServerOrClientSideApplier()
		for _, resource := range env.Resources.Items() {
			if err := applier.Apply(e.Ctx, resource); err != nil {
				return err
			}
		}

		return nil
	})

	return nil
}

func (t *deployerTrait) SelectControllerStrategy(e *Environment) (*ControllerStrategy, error) {
	//nolint:staticcheck
	if t.Kind != "" {
		strategy := ControllerStrategy(t.Kind)

		return &strategy, nil
	}

	return nil, nil
}

func (t *deployerTrait) ControllerStrategySelectorOrder() int {
	return 0
}

// RequiresIntegrationPlatform overrides base class method.
func (t *deployerTrait) RequiresIntegrationPlatform() bool {
	return false
}
