/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree;

import org.psjava.ds.tree.BinaryTreeNode;
import org.psjava.util.AssertStatus;

public class BinaryTreeNodeFactory {
    public static <T> BinaryTreeNode<T> create(final T initData) {
        return new BinaryTreeNode<T>(){
            T data;
            BinaryTreeNode<T> left;
            BinaryTreeNode<T> right;
            {
                this.data = initData;
                this.left = null;
                this.right = null;
            }

            @Override
            public T getData() {
                return this.data;
            }

            @Override
            public void setData(T data) {
                this.data = data;
            }

            @Override
            public boolean hasLeft() {
                return this.left != null;
            }

            @Override
            public boolean hasRight() {
                return this.right != null;
            }

            @Override
            public BinaryTreeNode<T> getLeft() {
                AssertStatus.assertTrue(this.hasLeft());
                return this.left;
            }

            @Override
            public BinaryTreeNode<T> getRight() {
                AssertStatus.assertTrue(this.hasRight());
                return this.right;
            }

            @Override
            public void putLeft(BinaryTreeNode<T> child) {
                this.left = child;
            }

            @Override
            public void putRight(BinaryTreeNode<T> child) {
                this.right = child;
            }

            @Override
            public void removeLeft() {
                AssertStatus.assertTrue(this.hasLeft());
                this.left = null;
            }

            @Override
            public void removeRight() {
                AssertStatus.assertTrue(this.hasRight());
                this.right = null;
            }
        };
    }

    private BinaryTreeNodeFactory() {
    }
}

