/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.ResultSetBuilder;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;

public abstract class Selector {
    public abstract void addFetchedColumns(ColumnFilter.Builder var1);

    public abstract void addInput(ProtocolVersion var1, ResultSetBuilder var2) throws InvalidRequestException;

    public abstract ByteBuffer getOutput(ProtocolVersion var1) throws InvalidRequestException;

    public abstract AbstractType<?> getType();

    public abstract void reset();

    public static abstract class Factory {
        public void addFunctionsTo(List<Function> functions) {
        }

        public ColumnSpecification getColumnSpecification(TableMetadata table) {
            return new ColumnSpecification(table.keyspace, table.name, new ColumnIdentifier(this.getColumnName(), true), this.getReturnType());
        }

        public abstract Selector newInstance(QueryOptions var1) throws InvalidRequestException;

        public boolean isAggregateSelectorFactory() {
            return false;
        }

        public boolean isWritetimeSelectorFactory() {
            return false;
        }

        public boolean isTTLSelectorFactory() {
            return false;
        }

        public boolean isSimpleSelectorFactory() {
            return false;
        }

        public boolean isSimpleSelectorFactoryFor(int index) {
            return false;
        }

        protected abstract String getColumnName();

        protected abstract AbstractType<?> getReturnType();

        protected abstract void addColumnMapping(SelectionColumnMapping var1, ColumnSpecification var2);

        abstract boolean areAllFetchedColumnsKnown();

        abstract void addFetchedColumns(ColumnFilter.Builder var1);
    }
}

