/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.diag.DiagnosticEventService;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.GossiperEvent;
import org.apache.cassandra.locator.InetAddressAndPort;

final class GossiperDiagnostics {
    private static final DiagnosticEventService service = DiagnosticEventService.instance();

    private GossiperDiagnostics() {
    }

    static void markedAsShutdown(Gossiper gossiper, InetAddressAndPort endpoint) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.MARKED_AS_SHUTDOWN)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.MARKED_AS_SHUTDOWN, gossiper, endpoint, null, null));
        }
    }

    static void convicted(Gossiper gossiper, InetAddressAndPort endpoint, double phi) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.CONVICTED)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.CONVICTED, gossiper, endpoint, null, null));
        }
    }

    static void replacementQuarantine(Gossiper gossiper, InetAddressAndPort endpoint) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.REPLACEMENT_QUARANTINE)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.REPLACEMENT_QUARANTINE, gossiper, endpoint, null, null));
        }
    }

    static void replacedEndpoint(Gossiper gossiper, InetAddressAndPort endpoint) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.REPLACED_ENDPOINT)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.REPLACED_ENDPOINT, gossiper, endpoint, null, null));
        }
    }

    static void evictedFromMembership(Gossiper gossiper, InetAddressAndPort endpoint) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.EVICTED_FROM_MEMBERSHIP)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.EVICTED_FROM_MEMBERSHIP, gossiper, endpoint, null, null));
        }
    }

    static void removedEndpoint(Gossiper gossiper, InetAddressAndPort endpoint) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.REMOVED_ENDPOINT)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.REMOVED_ENDPOINT, gossiper, endpoint, null, null));
        }
    }

    static void quarantinedEndpoint(Gossiper gossiper, InetAddressAndPort endpoint, long quarantineExpiration) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.QUARANTINED_ENDPOINT)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.QUARANTINED_ENDPOINT, gossiper, endpoint, quarantineExpiration, null));
        }
    }

    static void markedAlive(Gossiper gossiper, InetAddressAndPort addr, EndpointState localState) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.MARKED_ALIVE)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.MARKED_ALIVE, gossiper, addr, null, localState));
        }
    }

    static void realMarkedAlive(Gossiper gossiper, InetAddressAndPort addr, EndpointState localState) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.REAL_MARKED_ALIVE)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.REAL_MARKED_ALIVE, gossiper, addr, null, localState));
        }
    }

    static void markedDead(Gossiper gossiper, InetAddressAndPort addr, EndpointState localState) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.MARKED_DEAD)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.MARKED_DEAD, gossiper, addr, null, localState));
        }
    }

    static void majorStateChangeHandled(Gossiper gossiper, InetAddressAndPort addr, EndpointState state) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.MAJOR_STATE_CHANGE_HANDLED)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.MAJOR_STATE_CHANGE_HANDLED, gossiper, addr, null, state));
        }
    }

    static void sendGossipDigestSyn(Gossiper gossiper, InetAddressAndPort to) {
        if (GossiperDiagnostics.isEnabled(GossiperEvent.GossiperEventType.SEND_GOSSIP_DIGEST_SYN)) {
            service.publish(new GossiperEvent(GossiperEvent.GossiperEventType.SEND_GOSSIP_DIGEST_SYN, gossiper, to, null, null));
        }
    }

    private static boolean isEnabled(GossiperEvent.GossiperEventType type) {
        return service.isEnabled(GossiperEvent.class, type);
    }
}

